//LabPlot : PlotSettingsDialog.h

#ifndef PLOTSETTINGSDIALOG_H
#define PLOTSETTINGSDIALOG_H

#include <qtoolbutton.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include <qhbuttongroup.h>
#include "Worksheet.h"
#include "Dialog.h"

class PlotSettingsDialog: public Dialog
{
	Q_OBJECT
public:
	PlotSettingsDialog(MainWin *mw, const char *name);
	void updateDialog();
public slots:
	void autoScaleX();
	void autoScaleY();
	void autoScaleZ();
	void enableAspectRatio(bool a=true) { aspect->setChecked(a); }
	bool AspectRatioEnabled() { return aspect->isChecked(); }
	void setPlotPosition(double x, double y) { 
		posx->setText(QString::number(x)); posy->setText(QString::number(y)); 
	}
	void setPlotPosition(Point v) { 
		posx->setText(QString::number(v.X())); posy->setText(QString::number(v.Y())); 
	}
	Point PlotPosition() { return Point(posx->text().toDouble(),posy->text().toDouble()); }
	void setPlotSize(double x, double y) { 
		sizex->setText(QString::number(x)); sizey->setText(QString::number(y)); 
	}
	void setPlotSize(Point v) { 
		sizex->setText(QString::number(v.X())); sizey->setText(QString::number(v.Y())); 
	}
	Point PlotSize() { return Point(sizex->text().toDouble(), sizey->text().toDouble()); }
	void enableLeftPanel(bool e=true) { leftpanel->setChecked(e); }
	void enableRightPanel(bool e=true) { rightpanel->setChecked(e); }
	void enableTopPanel(bool e=true) { toppanel->setChecked(e); }
	void enableBottomPanel(bool e=true) { bottompanel->setChecked(e); }
	
	void setXRange(LRange *r) { 
		xmin->setText(QString::number(r->rMin())); xmax->setText(QString::number(r->rMax()));
	}
	LRange *XRange() { return new LRange(xmin->text().toDouble(),xmax->text().toDouble()); }
	void setYRange(LRange *r) { 
		ymin->setText(QString::number(r->rMin())); ymax->setText(QString::number(r->rMax()));
	}
	LRange *YRange() { return new LRange(ymin->text().toDouble(),ymax->text().toDouble()); }
	void setClippingOffset(int c) { clipni->setValue(c); }
	int ClippingOffset() { return clipni->value(); }
	
	void setTransparent(bool e=true) { transparentcb->setChecked(e); }
	bool Transparent() { return transparentcb->isChecked(); }
	void setBackground(QColor c) { bgcolor->setColor(c); }
	void setBackground(QString c) { bgcolor->setColor(QColor(c)); }
	QColor Background() { return bgcolor->color(); }
	void setGraphBackground(QColor c) { gbgcolor->setColor(c); }
	void setGraphBackground(QString c) { gbgcolor->setColor(QColor(c)); }
	QColor GraphBackground() { return gbgcolor->color(); }
	
	void setBaseline(double v) { baselinele->setText(QString::number(v)); }
	double Baseline() { return baselinele->text().toDouble(); }
	void setXBaseline(double v) { xbaselinele->setText(QString::number(v)); }
	double XBaseline() { return xbaselinele->text().toDouble(); }
	void enableBaseline(bool e=true) { baselinecb->setChecked(e); }
	bool BaselineEnabled() { return baselinecb->isChecked(); }
	void enableXBaseline(bool e=true) { xbaselinecb->setChecked(e); }
	bool XBaselineEnabled() { return xbaselinecb->isChecked(); }
	void enableRegion(bool e=true) { regioncb->setChecked(e); }	
	bool RegionEnabled() { return regioncb->isChecked(); }
	void setRegion(double min, double max) { 
		regionminle->setText(QString::number(min)); 
		regionmaxle->setText(QString::number(max)); 
	}

	void EnableMarker(bool e=true) { markercb->setChecked(e); }
	bool MarkerEnabled() { return markercb->isChecked(); }
	void setXMarker(double min, double max) {
		markxminle->setText(QString::number(min));
		markxmaxle->setText(QString::number(max));	
	}
	LRange *XMarker() { return new LRange(markxminle->text().toDouble(),markxmaxle->text().toDouble()); }
	void setYMarker(double min, double max) {
		markyminle->setText(QString::number(min));
		markymaxle->setText(QString::number(max));	
	}
	LRange *YMarker() { return new LRange(markyminle->text().toDouble(),markymaxle->text().toDouble()); }
	
	// TODO : surface style ?	-> in Dialog.h	// setStyle() ???

	// QWT 3D
	void disableMouse(bool e=false) { disablemousecb->setChecked(e); }
	bool MouseDisabled() { return disablemousecb->isChecked(); }
	void setResolution(int r) { resolutionle->setText(QString::number(r)); }
	int Resolution() { return resolutionle->text().toInt(); }
	void setAspectRatio(int v) { aspectcb->setCurrentItem(v); }
	int AspectRatio() { return aspectcb->currentItem(); }
	void setPlotStyle(int v) { plotstyle->setCurrentItem(v); }
	int PlotStyle() { return plotstyle->currentItem(); }
	void setCoordinateStyle(int v) { coordinatestyle->setCurrentItem(v); }
	int CoordinateStyle() { return coordinatestyle->currentItem(); }
	void setFloorStyle(int v) { floorstyle->setCurrentItem(v); }
	int FloorStyle() { return floorstyle->currentItem(); }
	void setIsoline(int i) { isolines->setText(QString::number(i)); }
	int Isolines() { return isolines->text().toInt(); }
	// selectColormap() ?
	
	void fillColorChanged();
	void bgColorChanged();
	void gbgColorChanged();
	void enableFill(bool e=true) { fillcb->setChecked(e); }
	bool fillEnabled() { return fillcb->isChecked(); }
	int fillG1() { return fillg1le->text().toInt(); }
	void setFillG1(int g) { fillg1le->setText(QString::number(g)); }
	int fillG2() { return fillg2le->text().toInt(); }
	void setFillG2(int g) { fillg2le->setText(QString::number(g)); }
	QBrush fillBrush() { return QBrush(fillcolorcb->color(),(Qt::BrushStyle)fillbrushcb->currentItem()); }
	void setFillBrush(QBrush b) { fillcolorcb->setColor(b.color()); fillbrushcb->setCurrentItem(b.style()); }
	QColor fillColor() { return fillcolorcb->color(); }
	void setFillColor(QColor c) { fillcolorcb->setColor(c); }
	int fillBrushStyle() { return fillbrushcb->currentItem(); }
	void setFillBrushStyle(int v) { fillbrushcb->setCurrentItem(v); }
	int Apply() { return apply_clicked(); }
private:
	Plot *plot;
	int type;
	KLineEdit *posx, *posy, *sizex, *sizey;
	QCheckBox *aspect, *render, *leftpanel, *rightpanel, *toppanel, *bottompanel;
	KLineEdit *borderwidth, *baselinele, *xbaselinele;
	KColorButton *bgcolor, *gbgcolor;
	KComboBox *bgbrushcb, *gbgbrushcb;
	KLineEdit *xmin, *xmax, *ymin, *ymax, *zmin, *zmax;
	KIntNumInput *clipni;
	QCheckBox *baselinecb, *xbaselinecb, *regioncb, *transparentcb;
	KLineEdit *regionminle, *regionmaxle;
	QCheckBox *markercb;
	KLineEdit *markxminle, *markxmaxle, *markyminle, *markymaxle;
	KComboBox *aspectcb;
	KComboBox *plotstyle, *coordinatestyle, *floorstyle;
	KLineEdit *isolines, *resolutionle;
	QCheckBox *disablemousecb;
	QCheckBox *fillcb;						// fill
	QHButtonGroup *hbg;
	KLineEdit *fillg1le, *fillg2le;
	KColorButton *fillcolorcb;
	KComboBox *fillbrushcb;
	KComboBox *datamodegraphcb;
	KColorButton *datamodecolorcb;
private slots:
	void ok_clicked() {apply_clicked(); accept(); }
	void saveSettings();
	int apply_clicked();
};

#endif //PLOTSETTINGSDIALOG_H
