//LabPlot : Plot2DSurface.h

#ifndef PLOT2DSURFACE_H
#define PLOT2DSURFACE_H

#include <iostream>
#include "Plot2D.h"

#ifdef HAVE_GL
#include "qwt3d_surfaceplot.h"
#endif

using namespace std;

//! surface 2D Plot	(density, contour)
class Plot2DSurface:public Plot2D {
public:
	Plot2DSurface(Worksheet *p);
	void saveSurfaceXML(QDomDocument doc, QDomElement plottag);
	void openSurfaceXML(QDomElement e);
	QStringList Info();
	void drawFill(QPainter *, int, int) {}	// unused
	void drawLegend(QPainter *p, int x, int y);
	void drawCurves(QPainter *p,int w, int h);
	bool contourEnabled() { return contourenabled; }
	void enableContour(bool e=true) { contourenabled = e; }
	QColor ContourColor() { return contour_color; }
	void setContourColor(QColor c) { contour_color = c; }
	void setContourColor(QString c) { contour_color = QColor(c); }
	bool ColoredContour() { return colored_contour; }
	void setColoredContour(bool c) {colored_contour = c; }
	int ContourWidth() { return contour_width; }
	void setContourWidth(int w=0) { contour_width=w; }
	bool Mesh(){ return mesh; }
	void setMesh(bool m) { mesh=m; }
	bool Relative() { return relative; }
	void setRelative(bool r) { relative=r; }
	int Brush(){ return brush; }
	void setBrush(int b) { brush=b; }
	bool densityEnabled() { return densityenabled; }
	void enableDensity(bool e=true) { densityenabled = e; }
	int Number() { return number; }
	void setNumber(int n) { number = n; }
	double Threshold() { return threshold; }
	void setThreshold(double t) { threshold = t; }
//	int Palette() { return palette; }
//	void setPalette(int p) { palette = p; }
	QColor Color(int value);	// used also by PlotDialog
#ifdef HAVE_GL
	void setColorVector(Qwt3D::ColorVector c) { cv=c; }
	Qwt3D::ColorVector getColorVector() { return cv; }
#endif
private:
	int graph_segment(QPainter *p,double x1,double y1, double z1, double x2, double y2, double z2,
		double x3, double y3, double z3, double level);
	bool densityenabled;	// density enabled
	bool contourenabled;	// contour enabled
	QColor contour_color;	// contour line color
	bool colored_contour;	// colored contour lines
	int contour_width;	// contour width
	bool mesh;		// draw mesh (grid)
	bool relative;		// use relative (full) color scale (e.g. 5-10 -> 0..255) or absolute (e.g. 5-10 -> 190..255)
	int brush;		// brush for density
	int number;		// number of level
	double threshold;	// threshold for plotting
#ifdef HAVE_GL
	Qwt3D::ColorVector cv;	// colorscale
#endif
};

#endif // PLOT2DSURFACE_H
