//LabPlot : GraphListView.cc

#include <iostream>
#include <qlabel.h>
#include <kdebug.h>
#include "GraphListView.h"
#include "Plot2DSurface.h"

using namespace std;

GraphListView::GraphListView(QWidget *p)
	: KListView(p)
{
	addColumn(i18n("Style"));
	addColumn(i18n("Name"));
	addColumn(i18n("Type"));
	addColumn(i18n("Shown"));

	addColumn(i18n("Rows"));
	addColumn(i18n("Columns"));

	addColumn(i18n("X Range"));
	addColumn(i18n("Y Range"));

	for (int i=0;i<columns();i++)
		setColumnAlignment(i,Qt::AlignHCenter);

	setAllColumnsShowFocus(true);

	// multi selection with CTRL and SHIFT
	setSelectionMode(QListView::Extended);

	setMinimumWidth(500);
	setMinimumHeight(150);
}
