importData("sample-data/sin.dat");

s = activeSpreadsheet();
s.plot2DSimple();

w = activeWorksheet();
p = w.get2DPlot(w.API());

p.setBackground("green");
p.setGraphBackground("lightblue");

r = p.ActRange(0);
r.setRange(250,750);
r = p.ActRange(1);
r.setRange(-2,2);

l = p.getLegend();
l.setPosition(.5,.4);

t = p.Title();
t.setTitle("example title");
t.setBoxed();

a = p.getAxis(0);
a.enableMajorGrid();
ll = a.getLabel();
ll.setTitle("different x axis");
font = new Font("SanSerif");
a.setTickLabelFont(font);

p.setMarksEnabled();
mark = p.markX();
mark.setRange(450,550);

p.setRegionEnabled();
p.setRegion(350,650);

// w.redraw();

exportEPS("export.eps");
exit();

