//LabPlot : CorrelationListDialog.cc

#include <kdebug.h>
#include "CorrelationListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_fft_real.h>
#include <gsl/gsl_fft_halfcomplex.h>
#endif
	
CorrelationListDialog::CorrelationListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	kdDebug()<<"CorrelationListDialog()"<<endl;
	setCaption(i18n("Correlation Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Correlation" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n("Type : "),hb);
	typecb = new KComboBox(hb);
	typecb->insertItem(i18n("auto correlation"));
	typecb->insertItem(i18n("cross correlation"));
	typecb->setCurrentItem(config->readNumEntry("Type",0));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE) {
		styletab = surfaceStyle(tw,true);
	}
	else {
		styletab = simpleStyle(tw, style, symbol);
	}

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void CorrelationListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Correlation" );
	config->writeEntry("Type", typecb->currentItem());
}

int CorrelationListDialog::apply_clicked() {
	kdDebug()<<"CorrelationListDialog::apply_clicked()"<<endl;
	
	bool type = typecb->currentItem();
	
	Point *data=0, *data2=0;
	int n=0;
	QString label, label2;
	if(s) {
		if(type) {
			KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
			return -1;
		}
		Graph2D *g = s->getGraph2D();
		n=g->Number();
		data = g->Data();
		label = g->getLabel()->simpleTitle();
	}
	else if(p) {
		GraphList *gl = p->getPlot(p->API())->getGraphList();

		// get selected items
		int item=-1, item2=-1;
#if QT_VERSION > 0x030102
		QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
		QListViewItemIterator it(lv);
#endif
		for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
			if(!it.current()->isSelected())
				continue;
#endif
			// take items;
			if(item== -1)
				item = (int) (lv->itemPos(it.current())/it.current()->height());
			else if(item2 == -1)
				item2 = (int) (lv->itemPos(it.current())/it.current()->height());
		}
		kdDebug()<<"SELECTED ITEMS for Correlation = "<<item<<' '<<item2<<endl;

		// get first data
		Graph *g = gl->getGraph(item);
		n = g->Number();
		label = g->getLabel()->simpleTitle();
		GRAPHType st = gl->getStruct(item);
		if (st == GRAPH2D) {
			Graph2D *g = gl->getGraph2D(item);
			data = g->Data();
		}
		else if (st == GRAPH3D) {
			Graph3D *g = gl->getGraph3D(item);
			for(int i=0;i<n;i++)
				data[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
		}
		else if (st == GRAPH4D) {
			Graph4D *g = gl->getGraph4D(item);
			for(int i=0;i<n;i++)
				data[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
		}
		
		if(type) {
			// get second data
			if(item2 == -1) {
				KMessageBox::error(this,i18n("Please select two graphs for cross correlation!"));
				return -1;
			}
		
			Graph *g = gl->getGraph(item2);
			label2 = g->getLabel()->simpleTitle();
			GRAPHType st2 = gl->getStruct(item2);
			if (st2 == GRAPH2D) {
				Graph2D *g = gl->getGraph2D(item2);
				data2 = g->Data();
			}
			else if (st2 == GRAPH3D) {
				Graph3D *g = gl->getGraph3D(item2);
				for(int i=0;i<n;i++)
					data2[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
			}
			else if (st2 == GRAPH4D) {
				Graph4D *g = gl->getGraph4D(item2);
				for(int i=0;i<n;i++)
					data2[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
			}
		}
	}

	if(data == 0) {
		KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
		return -1;
	}

#ifdef HAVE_GSL
	// round N up to the nearest power of two
	int N = (int)pow( 2.0, ceil( log2( (double)2*n )) );

	double *tmpdata = new double[N], *tmpdata2 = new double[N];
	if(tmpdata != 0 && tmpdata2 != 0) {
			// zero-pad the two arrays...
		memset( tmpdata, 0, N * sizeof( double ) );
		memset( tmpdata2, 0, N * sizeof( double ) );
		for(int i=0;i<n;i++) {
			tmpdata[i]=data[i].Y();
			if(type)
				tmpdata2[i]=data2[i].Y();
			else
				tmpdata2[i]=data[i].Y();
		}

		// calculate the FFTs of the two functions...
		if( gsl_fft_real_radix2_transform( tmpdata, 1, N ) == 0 && gsl_fft_real_radix2_transform( tmpdata2, 1, N ) == 0) {
			// multiply the FFT by its complex conjugate...
			for(int i=0; i<N/2; i++ ) {
				if( i==0 || i==(N/2)-1 ) {
					tmpdata[i] *= tmpdata[i];
				}
				else {
					double dReal = tmpdata[i] * tmpdata2[i] + tmpdata[N-i] * tmpdata2[N-i];
					double dImag = tmpdata[i] * tmpdata2[N-i] - tmpdata[N-i] * tmpdata2[i];
					
					tmpdata[i] = dReal;
					tmpdata[N-i] = dImag;
				}
			}
		}

		// do the inverse FFT...
		gsl_fft_halfcomplex_radix2_inverse(tmpdata, 1, N );
	}

	// create new graph from out data
	Point *ptr = new Point[n];
	for (int i = 0;i<n;i++) {
		double y=0;
		if(i < n/2)
			y = tmpdata[N - n/2 + i];
		else
			y = tmpdata[i-n/2];
		ptr[i].setPoint(double(i - n/2), y);
	}
	delete[] tmpdata;
	delete[] tmpdata2;

	double xmin=0, xmax=1, ymin=0, ymax=1;
	mw->calculateRanges2D(ptr,n,&xmin,&xmax,&ymin,&ymax);

	// create the new Graph
	LRange range[2];
	range[0] = LRange(xmin,xmax);
	range[1] = LRange(ymin,ymax);

	QString fun;
	if(type)
		fun = QString(i18n("Crosscorrelation of ")+label+' '+i18n("and")+' '+label2);
	else
		fun = QString(i18n("Autocorrelation of ")+label);
	
	Style *style = 0;
	Symbol *symbol = 0;
	if(p) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
	//TODO : spreadsheet : select destination
	int item=0;
	if(p)
		item=sheetcb->currentItem();
	mw->addGraph2D(ng,item);
#endif

	if(p) updateList();

	return 0;
}
