/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSVectorLayer.h,v 1.4 2002/04/23 09:28:18 com Exp $
*/

#ifndef GRASSVECTORLAYER_H
#define GRASSVECTORLAYER_H

extern "C" {
#include <Vect.h>
#include <gis.h>
}


#include <GRASSLayer.h>
#include <qcolor.h>


class GRASSPainter;

/**
 *
 *
 **/

class GRASSVectorLayer : public GRASSLayer {
public:  
  
  GRASSVectorLayer(GRASSPainter* painter, 
		    char* name,
		    char* mapset);
  
  virtual ~GRASSVectorLayer();
  
  virtual void draw(QPainter* p);

  /** color line is drawn with */
  virtual QColor& penColor() { return _penColor; }

  /** set the color the line is drawn with */
  virtual void penColor(QColor c) { _penColor = c; }

  /** color line is drawn with */
  virtual QColor& fillColor() { return _fillColor; }

  /** set the color the line is drawn with */
  virtual void fillColor(QColor c) { _fillColor = c; }

  enum DrawMode {line=0, fill};

  virtual void drawMode(DrawMode m) { _drawMode = m; }

  virtual DrawMode& drawMode() { return _drawMode;  }
  
  virtual int rtti() { return GRASSVectorLayerID; };

  static int const GRASSVectorLayerID = 1;

protected:

  int plot_line(double east1, double north1,
		double east2, double north2, QPainter* p);

  void polyPlot(QPainter* p);

  void linePlot(QPainter* p);

private:

  GRASSVectorLayer(const GRASSVectorLayer& rhs);

  GRASSVectorLayer& operator=(const GRASSVectorLayer& rhs);

  GRASSPainter* _painter;
  
  struct Map_info P_map;

  struct line_pnts* _points;

  QColor _penColor;

  QColor _fillColor;

  DrawMode _drawMode;
};	// end of class GRASSVectorLayer


#endif /* GRASSVECTORLAYER_H */
