\ gfit.4th
\
\ Fit a double gaussian to a data file
\
\ K. Myneni, 10-12-1998
\ Revised: 5-10-2000

include matrix
include func_2gauss
include curvefit

create x 1024 8 * 8 + allot
create y 1024 8 * 8 + allot
create a 8 8 * 8 + allot
create deltaa 8 8 * 8 + allot

variable np 

: put_data ( y1 ... yn -- )
	np @ 1 x mat_size!
	np @ 1 y mat_size!
	np @ 0 do
	  s>f np @ i - 1 y fmat!
	  i 1+ s>f i 1+ 1 x fmat!	\ x is a running index
	loop
;

include wfms01-1.dat	\ put the data from the file onto the stack
513 np !		\ number of data points in the file
put_data		\ move the data from the stack to the y matrix

7 1 a mat_size!
7 1 deltaa mat_size!

\ Setup initial values for parameters and increments

20000e 1 1 a fmat!	\ A
206e 2 1 a fmat!	\ mu1
100e 3 1 a fmat!	\ sigma1
15000e 4 1 a fmat!	\ B
390e 5 1 a fmat!	\ mu2
100e 6 1 a fmat!	\ sigma2
-15000e 7 1 a fmat!	\ C

1e 1 1 deltaa fmat!
0.1e 2 1 deltaa fmat!
0.1e 3 1 deltaa fmat!
1e 4 1 deltaa fmat!
0.1e 5 1 deltaa fmat!
0.1e 6 1 deltaa fmat!
1e 7 1 deltaa fmat!


: params. ( -- | display the current values of the parameters )
	a fmat. ;

: iterate ( -- | perform one iteration of curvefit and display results )
	x y a deltaa curfit
	." Fitted Parameters:" cr params. cr
	." Chi-Square = " f. cr ;

: genfit ( -- | display the fitted data values )
	\ You can redirect the output to a file to plot it with another program
	\   e.g. '>file fit.dat genfit console'
	np @ 0 do
	  i 1+ s>f a functn 	\ compute the fitted y value
	  i 1+ . 2 spaces f. cr \ print the x and y values
	loop ; 

." Initial Parameters are: " cr params. cr cr
." Type 'iterate' to execute curfit once and print the results." cr
." Continue to 'iterate' until chi-square converges." cr cr
." When the fit converges, you may write the fitted data to a file" cr
."   by typing, '>file fit.dat genfit console'" cr cr




