/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: ecefrag.h
 */


/* contains all the defination used internally by ece */

#ifndef __ECEFRAG_H__
#define __ECEFRAG_H__ 1

extern int    frag_assemble(const struct ha_msg *, char **);
extern int    frag_send_msg_wait(const ece_msg_t *ecemsg, const gboolean mcast, 
		const char *node, const u_int32_t corr, const u_int32_t crc,
		const u_int32_t ackval);
extern int    frag_assemble(const struct ha_msg *, char **);
extern void   frag_init(int );
extern void   frag_clean(const char* );
extern void   frag_cleanup(void);
extern void   frag_send_check(void);

#endif /*  __ECEFRAG_H__ */
