/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_main.c
 *
 * Description: Global and core for MD plugins
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <plugin.h>
#define MY_PLUGIN my_plugin
#include "md.h"

plugin_record_t	    		* linear_plugin = &linear_plugin_record;
plugin_record_t	    		* raid1_plugin = &raid1_plugin_record;
plugin_record_t	    		* raid0_plugin = &raid0_plugin_record;
plugin_record_t                 * raid5_plugin = &raid5_plugin_record;
md_volume_t			* volume_list_head = NULL;	// List of real volume groups, indexed by vg_number.
engine_functions_t		* EngFncs;		// The Engine's internal API set.
plugin_record_t			* my_plugin = NULL;
char message_buffer[1024];
plugin_record_t * evms_plugin_records[] = {&linear_plugin_record,
	                                   &raid1_plugin_record,
	                                   &raid0_plugin_record,
	                                   &raid5_plugin_record,
	                                   NULL};


/*
 * Function: calc_log2
 *
 *	Calculate the log-base2 of the argument
 */
long calc_log2( long arg )
{
	long	result = -1;
	long	tmp;

	if ( arg ) {
		tmp = arg;
		result++;
		while ( ! (tmp & 1) ) {
			result++;
			tmp >>= 1;
		}
		if ( tmp != 1 ) {
			// arg isn't a power of 2!
			result = -2;
		}
	}
	RETURN(result);
}
