/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: bbroptions.h
 *
 */

#ifndef   BBR_OPTIONS_HEADER
#define   BBR_OPTIONS_HEADER 1


//
// Create Option Info
//
#define BBR_CREATE_OPTION_COUNT                     1

#define BBR_CREATE_NAME_INDEX                       0
#define BBR_CREATE_NAME_NAME                        "Name"


//
// Expand Option Info
//
#define BBR_EXPAND_OPTION_COUNT                     1

#define BBR_EXPAND_BLOCKCOUNT_INDEX                 0
#define BBR_EXPAND_BLOCKCOUNT_NAME                  "replacement blocks"



//
//   Shrink Option Info
//
#define BBR_SHRINK_OPTION_COUNT                     1

#define BBR_SHRINK_BLOCKCOUNT_INDEX                 0
#define BBR_SHRINK_BLOCKCOUNT_NAME                  "replacement blocks"

                                        
// 
//  BBR Info
//
#define BBR_INFO_COUNT            5

#define BBR_INFO_NAME_INDEX       0
#define BBR_INFO_SIZE_INDEX       1
#define BBR_INFO_BLKS_INDEX       2
#define BBR_INFO_BLKSZ_INDEX      3
#define BBR_INFO_TBLSZ_INDEX      4
                                        
                                        
// 
//  Plugin Info
//
#define BBR_PLUGIN_INFO_COUNT             5

#define BBR_PLUGIN_INFO_SNAME_INDEX       0
#define BBR_PLUGIN_INFO_LNAME_INDEX       1
#define BBR_PLUGIN_INFO_TYPE_INDEX        2
#define BBR_PLUGIN_INFO_VERSION_INDEX     3
#define BBR_PLUGIN_INFO_REQVERSION_INDEX  4



int         BBR_GetOptionCount(task_context_t * task);

int         BBR_InitTask(task_context_t * context);

int         BBR_SetOption( task_context_t * context, u_int32_t index, value_t * value, u_int32_t * info );

int         BBR_GetInfo( storage_object_t  * object, char *name,  extended_info_array_t * * info);

int         BBR_GetPluginInfo( char * descriptor_name, extended_info_array_t * * info );

int         BBR_SetObjects( task_context_t * context,
                            dlist_t          declined_objects,
                            task_effect_t  * effect );
#endif

