/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: aixregmgr
 * File: aix_pv.h
 */

#ifndef _AIX_PV_H_
#define _AIX_PV_H_

extern storage_object_t * aix_find_pv_by_number(storage_container_t	* container,
						unsigned int		pv_num );
extern int aix_allocate_pv(	storage_object_t	* object,
				aix_ipl_rec_t		* ipl,
				aix_lvm_rec_t		* lvm );
extern void aix_deallocate_pv( storage_object_t * object );
extern int aix_read_pv_metadata( storage_object_t * object );
extern int aix_compare_timestamps( storage_object_t * object );

#endif

