/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: object.h
 *
 */

/*
 * Global functions exported by object.c
 */

/* External APIs provided by object.c */

extern int evms_create(plugin_handle_t    plugin,
                       handle_array_t   * objects,
                       option_array_t   * options,
                       handle_array_t * * output_objects);

extern int evms_transfer(object_handle_t  object,
                         plugin_handle_t  plugin,
                         object_handle_t  container,
                         option_array_t * options);

/* Internal functions to share with other Engine source modules */

extern int isa_valid_input_object(ADDRESS object,
                                  TAG     object_tag,
                                  uint    object_size,
                                  ADDRESS object_handle,
                                  ADDRESS parameters);

