#include <glib.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>


#include "entity.h"


static void
render_args (ENode * node)
{
    int i;
    int argc;
    gchar **argv;
    char str[256];
    char *dir;

    argc = entity_get_argc ();
    argv = entity_get_argv ();

    sprintf (str, "%d", argc);
    enode_attrib_str (node, "argc", str);

    dir = econfig_get_attr ("entity-startup-dir");
    enode_attrib_str (node, "startup-directory", dir);

    for (i = 0; i < argc; i++) {
	ENode *new_node = enode_new_child (node, "arg", NULL);
	enode_attrib_str (new_node, "name", argv[i]);
    }
}

void
system_args_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = render_args;
    element->tag = "system-args";
    element->description = "Get arguments passed to entity on command line.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "argc";
    e_attr->description = "Argument count.";
    e_attr->value_desc = "integer";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "startup-directory";
    e_attr->description = "A string representing the current directory.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

}
