#include "csink.h"

CSink_Error csink_error_internal_error[] = {
    {"INTERNAL", "An internal error - please file a bug report."},

    {NULL, NULL}
};

CSink_Error csink_error_table[] = {
    {"NONE", "No error has occured."},

    /* Errors the user should handle */
    {"CONNECT_FAILURE", "Connection attempt failed."},
    {"DISCONN_WRITE", "Attempt to write to an unconnected sink."},    

    /* Socket Errors */    
    {"NO_SOCKET", "?"},
    {"SOCKET_CREATE_FAILED", "Unable to create a socket for communication"},
    {"SEND_PIPE", "Socket connection was broken"},
    {"SEND_EMSGSIZE", "Message too large to send"},
    {"EBADF", "Internal error: tried to use bad file descriptor"},
    {"ENOPROTOOPT", "Internal error: Can't check socket option"},
    {"ENOTSOCK", "Internal error: tried to use wrong file descriptor"},
    {"ECONNRESET", "Connection reset by peer"},
    {"EADDRNOTAVAIL", "Requested interface/port combination is not available"},
    {"EADDRINUSE", "Requested interface/port combination is already taken"},
    {"EINVAL", "\"Socket already has an address\" (EINVAL)"},
    {"EACCES", "You don't have permission to use that interface or port"},
    {"EOPNOTSUPP", "Tried to listen on a socket that doesn not support it"},

    /* Inet Errors */
    {"DNS_LOOKUP_FAILED", "Failed to lookup hostname"},

    /* SSL Errors */
    {"SSL_NO_SEED", "SSL: Not able to seed random number generator"},
    {"SSL_NO_CERT", "SSL: No certificate was specified."},
    {"SSL_BAD_CERT", "SSL: Certificate was not accepted."},
    {"SSL_EXPIRED_CERT", "SSL: Certificate has expired."},
    {"SSL_HASH_MISSING", "SSL: Hash file for certificate missing."},
    {"SSL_PROTOCOL", "SSL: Protocol error, can't continue."},
    {"SSL_ERROR", "SSL: Error writing to the ssl socket."},
    {"SSL_HANDSHAKE", "SSL: Unable to negotiate a connection."},

    /* Internal Errors */
    {"IMPLEMENTATION_DEFAULTCALL", "Internal error: misimplemented sink."},
    {"IMPLEMENTATION_BUG", "Internal error: impossible situation detected."},
    {"INTERNAL", "Internal error: (no further information)"},
    {"UNKNOWN", "Internal error: Unknown syscall result."},
    
    {NULL, NULL},
};
