#!/usr/bin/env entity

<object default-lang="c">
  <timer interval="2000" action="search"/>
  <timer name="create_nodes" interval="1" action="create_nodes"/>
  <system-time/>
  <?c-code
  

#include <sys/types.h>
#include <time.h>

#define NUM_NODES 10000

static char *
thetime (int print_change)
{
    static char buf[1024];
    struct timeval tv;
    static long last_usec;
    
    gettimeofday(&tv, NULL);
    if (print_change) {
	g_snprintf (buf, sizeof (buf), "%d:%d (%f sec ellapsed)", tv.tv_sec, 
		    tv.tv_usec, (tv.tv_usec - last_usec) / 1000000.0);
    } else {
	g_snprintf (buf, sizeof (buf), "%d:%d", tv.tv_sec, 
		    tv.tv_usec);
    }
    last_usec = tv.tv_usec;
    return (buf);
}

EBuf *
search (ENode *timer, GSList *args)
{
    ENode *object;
    GSList *list;
    GSList *tmp;
    int length;
    EBuf *goo;

    g_print ("entering search\n");

    object = enode_parent (timer, "object");
    if (!object)
	return (NULL);

    g_print ("searching nodes..: %s\n", thetime(FALSE));

    goo = ebuf_new_with_str ("goo");
    list = enode_children_attrib (object, "foo", goo);
    ebuf_free (goo);

    length = g_slist_length (list);
    g_print ("returned %d nodes: %s\n", length, thetime(TRUE));
    return (NULL);
}

EBuf *
create_nodes (ENode *timer, GSList *args)
{
    ENode *object;
    ENode *node;
    gint i;

    object = enode_parent (timer, "object");
    g_print ("building %d nodes...: %s\n", NUM_NODES, thetime(FALSE));

    for (i = 0; i < NUM_NODES; i++) {
	node = enode_new_child (object, "fooey", NULL);
	if (! (i % 2)) {
	    enode_attrib (node, "foo", ebuf_new_with_str ("goo"));
	}
    }

    g_print ("done: %s\n", thetime (TRUE));

    enode_attrib (timer, "interval", ebuf_new_with_str ("-1"));
    return (NULL);
}

?>
</object>
