from setuptools import setup, Extension, find_packages

ctraits = Extension(
    'enthought.traits.ctraits',
    sources=['enthought/traits/ctraits.c'],
)


# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
ETSCONFIG = etsdep('enthought.etsconfig', '2.0.2', '3.0')
PYFACE_DOCK = etsdep('enthought.pyface[dock]', '2.0.4', '3.0')
RESOURCE = etsdep('enthought.resource', '2.0.4', '3.0')
#TRAITSUIWX -- we explicitly ignore the imports of this.  see the TODO list.


# Configure setup.
setup(
    author = 'David C. Morrill',
    author_email = 'dmorrill@enthought.com',
    dependency_links = [
        'http://code.enthought.com/enstaller/eggs/source',
        ],
    description = 'Explicitly typed Python attributes package',
    extras_require = {
        'ui': [
            PYFACE_DOCK,
            RESOURCE,
            ],

        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            'numpy >=1.0.2',
            'testoob',
            ],
        },
    ext_modules = [ctraits],
    include_package_data = True,
    install_requires = [
        ETSCONFIG,
        ],
    license = 'BSD',
    name = 'enthought.traits',
    namespace_packages = [
        "enthought",
        "enthought.traits",
        "enthought.traits.ui",
        ],
    packages = find_packages(exclude=['examples', 'integrationtests']),
    tests_require=[
        'nose >= 0.9',
        'testoob',
        ],
    test_suite = 'nose.collector',
    url = 'http://code.enthought.com/traits',
    version = '2.0.5',
    zip_safe = False,
    )

