""" Demo to redefine legal values of one attribute based on another via GUI.
"""

from enthought.traits.api \
    import HasTraits, Str, Enum, TraitEnum, List, Instance
    
from enthought.traits.ui.api \
    import View, Group, Item, Handler, EnumEditor


# Dictionary of defined states and cities.
cities_by_state = {
    'GA': [ 'Athens', 'Atlanta', 'Macon', 'Marietta', 'Savannah' ],
    'TX': [ 'Austin', 'Amarillo', 'Dallas', 'Houston', 'San Antonio', 'Waco' ],
    'OR': [ 'Albany', 'Eugene', 'Portland' ]
}


class Address ( HasTraits ):
    """ Demo class for demonstrating dynamic redefinition of valid trait values.
    """
    street_address = Str
    st             = Str
    city           = Str
    _cities        = List

    view = View( Item( name  = 'street_address' ),
                 Item( name  = 'st', 
                       label = 'State' ),
                 Item( name  = 'city', 
                       editor = EnumEditor(name='_cities'), 
                       id     = 'cityedit' ),
                 title   = 'Address Information')
    
    def _st_changed( self ):
        if cities_by_state.has_key( self.st ):
            self._cities = cities_by_state[ self.st ]
            self.city = self._cities[ 0 ]
        else:
            self._cities = []
        
# Code to run the demo standalone:
if __name__ == '__main__':
    addr = Address()
    addr.configure_traits()

