""" Demo to redefine legal values of an attribute depending on its object.

    Code sample showing a simple implementation of the dynamic 
    redefining of a trait attribute's legal values on the basis of 
    another attribute of the object to which the trait belongs.
"""

from enthought.traits.api \
    import HasTraits, Str, List
    
from enthought.traits.ui.api \
    import View, Item, EnumEditor


class Person ( HasTraits ):
    """ Demo class for demonstrating dynamic redefinition of valid trait values.
    """
    first_name   = Str
    last_name    = Str
    current_memo = Str
    memo_list    = List

    view_memos = View( Item( name   = 'first_name' ),
                       Item( name   = 'last_name' ),
                       Item( name   = 'current_memo', 
                             editor = EnumEditor( name = 'memo_list' ) ),
                       title = 'To Do List' )

                       
# Code to run demo as a standalone.
Sam = Person( first_name = 'Samuel',
              last_name  = 'French',
              memo_list  = [ "Sam's Grocery List", 
                             "Sam's Diary" ] )

Bob = Person( first_name = 'Robert',
              last_name  = 'Brown',
              memo_list  = [ "Bob's Date Book",
                             "Bob's Grocery List",
                             "Bob's Journal" ] )

    
# Code to run the demo standalone:                             
if __name__ == '__main__':                             
    Sam.edit_traits( kind = 'modal' )
    Bob.edit_traits( kind = 'modal' )
