/*
** 
** Copyright (C) 1993 Swedish University Network (SUNET)
** 
** 
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** 
**                                           Martin.Wendel@its.uu.se
** 				             Torbjorn.Wictorin@its.uu.se
** 
**                                           ITS	
**                                           P.O. Box 887
**                                           S-751 08 Uppsala
**                                           Sweden
** 
*/
#include "emil.h"

void	encode_mailtool(struct message *m)
{
  char buf[HDRLEN];
  if (m->sd->format == MAILTOOL &&
      m->sd == m->td)
    return;
  if (m->level == 0)
    {
      rm_header(m, "X-Charset");
      rm_header(m, "X-Char-Esc");
      if (match(m->sd->type, "TEXT"))
	{
	  add_header(m, "Content-Type", "text", MAILTOOL);
	  sprintf(buf, "%d", get_body_lines(m->td));
	  add_header(m, "X-lines", buf, MAILTOOL); 
	}
      else
	{
	  add_header(m, "Content-Type", "X-Sun-Attachment", MAILTOOL);
	  m->td->startbound = NEWSTR("----------");
	}
    }
  else
    {
      unsigned char *dt = NULL;
      if (m->td->encoding == EMULTI)
	{
	  m->td->startbound = NEWSTR("----------");
	  return;
	}
      if ((dt = (char *)confextr("MAILTOOL", NULL, m->sd->type)) != NULL ||
	   (dt = (char *)confextr("MAILTOOL", NULL, "DEFAULT")) != NULL)
	{
	  add_header(m, "X-Sun-Data-Type", dt, MAILTOOL);
	}
      else
	{
	  add_header(m, "X-Sun-Data-Type", "default", MAILTOOL);
	}


/*
      if (match(m->sd->type, "TEXT"))
	{
	  add_header(m, "X-Sun-Data-Type", "text", MAILTOOL);
	}
      else
      if (match(m->sd->type, "APPLICATION"))
	{
	  add_header(m, "X-Sun-Data-Type", "default-app", MAILTOOL);
	}
      else
      if (match(m->sd->type, "GIF"))
	{
	  add_header(m, "X-Sun-Data-Type", "gif-file", MAILTOOL);
	}
      else
      if (match(m->sd->type, "ULAW"))
	{
	  add_header(m, "X-Sun-Data-Type", "audio-file", MAILTOOL);
	}
      else
	{
	  add_header(m, "X-Sun-Data-Type", "default", MAILTOOL);
	}
*/
      switch (m->td->encoding) {
      case EUUENCODE:
	add_header(m, "X-Sun-Encoding-Info", "uuencode", MAILTOOL);
	break;
      case EBINHEX:
	add_header(m, "X-Sun-Encoding-Info", "binhex", MAILTOOL);
	break;
      case EBASE64:
	add_header(m, "X-Sun-Encoding-Info", "base64", MAILTOOL);
	break;
      }
      if (m->sd->description != NULL)
	add_header(m, "X-Sun-Data-description", m->sd->description, MAILTOOL);
      else
	add_header(m, "X-Sun-Data-description", "default", MAILTOOL);
      
      if (m->sd->name != NULL)
	add_header(m, "X-Sun-Data-name", m->sd->name, MAILTOOL);

      sprintf(buf, "%d", get_body_lines(m->td));
      add_header(m, "X-Sun-Content-lines", buf, MAILTOOL);
    }
}

int decode_mailtool(struct message *m)
{
  if (m->level == 0)
    {
      if (matchheader(m, "Content-Type", "text", MAILTOOL))
	{
	  if ((m->sd->charset = (char *)gethval(m, "X-Sun-charset", MAILTOOL)) == NULL)
	    return(NOK);
	  m->sd->format = MAILTOOL;
	  m->sd->type = NEWSTR("TEXT");
	  m->sd->encoding = E7BIT;
	}
      else
      /* Look for SUN Mailtool */
      if (matchheader(m, "Content-Type", "X-Sun-Attachment", MAILTOOL))
	    {
	      m->sd->format = MAILTOOL;
	      m->sd->type = NEWSTR("MULTIPART");
	      m->sd->check = EMULTI;
	      m->sd->encoding = EMULTI;
	      m->sd->startbound = NEWSTR("----------");
	    }

      if (m->sd->format == MAILTOOL)
	{
	  m->sd->length = string2dec(gethval(m, "Content-length", MAILTOOL));
	  m->sd->bodylines = string2dec(gethval(m, "X-lines", MAILTOOL));
	  return(OK);
	}
      else
	return(NOK);
    }
  /**
   ** This is valid for SUN Mailtool message, except for root header 
   **/

  if (m->sd->format == MAILTOOL && m->level != 0)
    {
      char *line = NULL;
      m->sd->charset = (char *)gethval(m, "X-Sun-charset", MAILTOOL);
      
      if ((line = (char *)gethval(m, "X-Sun-Data-Type", MAILTOOL)) == NULL)
	{
	  m->sd->type = NEWSTR("TEXT");
	  m->sd->charset = NEWSTR("US-ASCII");
	}
      else
	{
	  while (isspace(*line))
	    line++;
	  if ((m->sd->type = confextr("MAILTOOL", clear_end_space(line), NULL)) == NULL)
	    m->sd->type = NEWSTR("APPLICATION");
	}
/*									   

      if (matchheader(m, "X-Sun-Data-Type", "text", MAILTOOL))
	{
	  m->sd->type = NEWSTR("TEXT");
	  m->sd->charset = "ISO-8859-1";
	  m->sd->encoding = E7BIT;
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "default", MAILTOOL))
	{
	  m->sd->type = NEWSTR("TEXT");
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "default-app", MAILTOOL))
	{
	  m->sd->type = NEWSTR("APPLICATION");
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "gif-file", MAILTOOL))
	{
	  m->sd->type = NEWSTR("GIF");
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "audio-file", MAILTOOL))
	{
	  m->sd->type = NEWSTR("ULAW");
	}
      else
	m->sd->type = NEWSTR("APPLICATION");
*/
      m->sd->encoding = E7BIT;
      if (matchheader(m, "X-Sun-Encoding-Info", "uuencode", MAILTOOL))
	{
	  m->sd->encoding = EUUENCODE;
	}
      else
      if (matchheader(m, "X-Sun-Encoding-Info", "binhex", MAILTOOL))
	{
	  m->sd->encoding = EBINHEX;
	}
      else
      if (matchheader(m, "X-Sun-Encoding-Info", "base64", MAILTOOL))
	{
	  m->sd->encoding = EBASE64;
	}

      if (matchheader(m, "X-Sun-Data-Type", "default", MAILTOOL) && m->sd->charset != NULL && m->sd->encoding == E7BIT)
	{
	  m->sd->type = NEWSTR("TEXT");
	}
      
      m->sd->length = string2dec(gethval(m, "X-Sun-Content-length", MAILTOOL));
      m->sd->bodylines = string2dec(gethval(m, "X-Sun-Content-lines", MAILTOOL));
      m->sd->description = (char *)gethval(m, "X-Sun-Data-description", MAILTOOL);
      m->sd->name = (char *)gethval(m, "X-Sun-Data-name", MAILTOOL);
    }  
  else
    return (NOK);
  return (OK);
}

int
get_body_lines(struct data *d)
{
  char *c;
  int i, e, l;
  
  l = 0;
  i = d->bodystart;
  e = d->bodyend;
  c = d->contents + i;
  for (; i < e; i++, c++)
    if (*c == '\n')
      l++;
  return(l);
}

