
#ifndef _PTGNodeLIST_H
#define _PTGNodeLIST_H

/* include header file defining PTGNode if ptg_gen is set: */
#define EMPTYptg_genHDR
#ifndef EMPTYHDR
#include "ptg_gen.h"
#endif
#undef EMPTYptg_genHDR

#include "PTGNodeFunctionTypes.h"

typedef struct _PTGNodeLE *PTGNodeList;
typedef PTGNodeList    *PTGNodeListPtr;

struct _PTGNodeLE {
PTGNode         head;
PTGNodeList     tail;
};

#define NULLPTGNodeList         ((PTGNodeList)0)
#define NullPTGNodeList()       ((PTGNodeList)0)
#define SinglePTGNodeList(e)    (ConsPTGNodeList((e),NULLPTGNodeList))

#if defined(__STDC__) || defined(__cplusplus)

extern void FinlPTGNodeList(void);
   /* Deallocates all PTGNodeLists. */
   /* Dynamic storage is allocated on first need */

extern PTGNodeList ConsPTGNodeList (PTGNode e, PTGNodeList l);
   /* Constructs a PTGNodeList of an element e and a given tail l.
    * e is the first element of the list. */

extern PTGNode HeadPTGNodeList (PTGNodeList l);
   /* Returns the first element of the list l.
    * The list l must not be empty. */

extern PTGNodeList TailPTGNodeList (PTGNodeList l);
   /* Returns the tail of the list l.
    * If l is empty, an empty list is returned. */

extern int LengthPTGNodeList (PTGNodeList l);
   /* Returns the number of elements in the list l. */

extern PTGNode IthElemPTGNodeList (PTGNodeList l, int i);
   /* Returns the i-th element of the List l. The head of l
    * is referred to as 1. If the value of
    * i is greater than the length of the list, an error
    * is reported and the program exits.
    */

extern PTGNodeList CopyPTGNodeList (PTGNodeList l, PTGNodeMapFct cp);
   /* Copies the list l. Elements are copied by calls of cp. */

extern PTGNodeList AppPTGNodeList (PTGNodeList l1, PTGNodeList l2);
   /* Concatenates two lists l1 and l2. The resulting list contains l2 at
    * the end of a copy of list l1. */

extern PTGNodeList AppElPTGNodeList (PTGNodeList l, PTGNode e);
   /* Appends an element e to the list l.
    * The list l is not copied, it is modified as a side-effect
    * of this function. */

extern void InsertAfterPTGNodeList (PTGNodeList l, PTGNode e);
   /* This function requires a non-empty list l. The element e is inserted
    * just after the first element of l. 
    * The list l is modified as a side-effect of this function. */

extern PTGNodeList OrderedInsertPTGNodeList (PTGNodeList l, PTGNode e, PTGNodeCmpFctType fcmp);
   /* Inserts the element e into the list l maintaining l in
    * ascending order with respect to the compare fcmp. 
    * The list l is modified as a side-effect of this function. */

extern PTGNodeListPtr RefEndConsPTGNodeList (PTGNodeListPtr addr, PTGNode e);
   /* Appends an element e to the end of a list given by its address addr.
    * The address where the next element may be appended is returned.
    * The list is modified as a side-effect of this function. */

extern PTGNodeListPtr RefEndAppPTGNodeList (PTGNodeListPtr addr, PTGNodeList l);
   /* Appends a list l to the end of a list given by its address addr.
    * The address where the next element may be appended is returned.
    * The list is modified as a side-effect of this function. */

extern int ElemInPTGNodeList (PTGNode e, PTGNodeList l, PTGNodeCmpFctType cmpfct);
   /* This function returns true (1) iff the element e is in the List l.
    * List elements are compared by the function cmpfct. */

extern PTGNodeList AddToSetPTGNodeList (PTGNode e, PTGNodeList l, PTGNodeCmpFctType cmpfct);
   /* A list is returned that has e as an element.
    * l is checked whether it already contains e using the compare
    * function cmpfct. */

extern PTGNodeList AddToOrderedSetPTGNodeList 
       (PTGNode e, PTGNodeList l, PTGNodeCmpFctType cmpfct);
   /* A list is returned that has e as an element.
    * l is checked whether it already contains e using the compare
    * function cmpfct. l is assumed to be ordered increasingly in the sense of
    * cmpfct. */

extern PTGNodeList MapPTGNodeList (PTGNodeList l, PTGNodeMapFct f);
   /* Returns a new PTGNodeList obtained by applying f to each element of l. */

extern int CompPTGNodeList (PTGNodeList l1, PTGNodeList l2, PTGNodeCmpFctType f);
   /* Compares the lists l1 and l2 lexicographically by applying f
    * to the corresponding elements. */

extern PTGNode SumPTGNodeList (PTGNodeList l, PTGNodeSumFct f, PTGNode a);
   /* Applies the binary function f to the elements of the List:
    *   f( f(... f(a, e1), e2, ...), en)
    * If l is empty a is returned. */

#else

extern void FinlPTGNodeList ();
extern PTGNodeList ConsPTGNodeList ();
extern PTGNode HeadPTGNodeList ();
extern PTGNodeList TailPTGNodeList ();
extern int LengthPTGNodeList ();
extern PTGNode IthElemPTGNodeList ();
extern PTGNodeList CopyPTGNodeList ();
extern PTGNodeList AppPTGNodeList ();
extern PTGNodeList AppElPTGNodeList ();
extern void InsertAfterPTGNodeList ();
extern PTGNodeList OrderedInsertPTGNodeList ();
extern PTGNodeListPtr RefEndConsPTGNodeList ();
extern PTGNodeListPtr RefEndAppPTGNodeList ();
extern int ElemInPTGNodeList ();
extern PTGNodeList AddToSetPTGNodeList ();
extern PTGNodeList MapPTGNodeList ();
extern int CompPTGNodeList ();
extern PTGNode SumPTGNodeList ();

#endif

#ifdef MONITOR
#define DAPTO_RESULTPTGNodeList(l) DAPTO_RESULT_PTR(l)
#define DAPTO_ARGPTGNodeList(l)    DAPTO_ARG_PTR (l, PTGNodeList)
#endif

#endif
