/* (C) Copyright 1997 University of Paderborn */

/* This file is part of the Eli translator construction system.

Eli is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

Eli is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Eli; see the file COPYING.  If not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
** $Id: comar.h,v 1.6 1997/08/29 08:38:08 mjung Exp $
*/

#ifndef COMAR_H
#define COMAR_H

/* comar.h - IDL declarations generated by idlc, version 3.2
    on Mon Mar 12 14:00:11 1990
*/

/* Changes to the generated version:
 *   1. < # include "/net/corona/usr/local/idl3.2/include/C/global.h"
 *      ---
 *      > # include "global.h"
 *   2. In the following macros the parameter 'classnamevalue' is replaced
 *	by 'classnamevalue.IDLinternal' to make them portable:
 *	inSEQclassname, appendfrontSEQclassname, appendrearSEQclassname,
 *	orderedinsertSEQclassname, removeSEQclassname.
 */

# include "global.h"

/* Private Types */

/* Class Headers */
typedef struct CAsymb_entry * CPsymb_entry;
typedef struct CAdef_entry * CPdef_entry;
typedef struct CAprop_entry * CPprop_entry;

/* Nodes */
typedef struct Rp_alt * p_alt;
# define Kp_alt 2
# define Np_alt (Ip_alt((p_alt)N_INIT( \
	GetNode(sizeof(struct Rp_alt),Kp_alt), \
	Kp_alt,sizeof(struct Rp_alt))))
# define Dp_alt(n) {Fp_alt(n); FreeNode(n, Kp_alt);}
# define Ip_alt(N) (N)
# define Fp_alt(N)

typedef struct Rp_comar * p_comar;
# define Kp_comar 4
# define Np_comar (Ip_comar((p_comar)N_INIT( \
	GetNode(sizeof(struct Rp_comar),Kp_comar), \
	Kp_comar,sizeof(struct Rp_comar))))
# define Dp_comar(n) {Fp_comar(n); FreeNode(n, Kp_comar);}
# define Ip_comar(N) (N)
# define Fp_comar(N)

typedef struct Rp_delrep * p_delrep;
# define Kp_delrep 6
# define Np_delrep (Ip_delrep((p_delrep)N_INIT( \
	GetNode(sizeof(struct Rp_delrep),Kp_delrep), \
	Kp_delrep,sizeof(struct Rp_delrep))))
# define Dp_delrep(n) {Fp_delrep(n); FreeNode(n, Kp_delrep);}
# define Ip_delrep(N) (N)
# define Fp_delrep(N)

typedef struct Rp_dval * p_dval;
# define Kp_dval 8
# define Np_dval (Ip_dval((p_dval)N_INIT( \
	GetNode(sizeof(struct Rp_dval),Kp_dval), \
	Kp_dval,sizeof(struct Rp_dval))))
# define Dp_dval(n) {Fp_dval(n); FreeNode(n, Kp_dval);}
# define Ip_dval(N) (N)
# define Fp_dval(N)

typedef struct Rp_elunit * p_elunit;
# define Kp_elunit 10
# define Np_elunit (Ip_elunit((p_elunit)N_INIT( \
	GetNode(sizeof(struct Rp_elunit),Kp_elunit), \
	Kp_elunit,sizeof(struct Rp_elunit))))
# define Dp_elunit(n) {Fp_elunit(n); FreeNode(n, Kp_elunit);}
# define Ip_elunit(N) (N)
# define Fp_elunit(N)

typedef struct Rp_lval * p_lval;
# define Kp_lval 12
# define Np_lval (Ip_lval((p_lval)N_INIT( \
	GetNode(sizeof(struct Rp_lval),Kp_lval), \
	Kp_lval,sizeof(struct Rp_lval))))
# define Dp_lval(n) {Fp_lval(n); FreeNode(n, Kp_lval);}
# define Ip_lval(N) (N)
# define Fp_lval(N)

typedef struct Rp_name * p_name;
# define Kp_name 14
# define Np_name (Ip_name((p_name)N_INIT( \
	GetNode(sizeof(struct Rp_name),Kp_name), \
	Kp_name,sizeof(struct Rp_name))))
# define Dp_name(n) {Fp_name(n); FreeNode(n, Kp_name);}
# define Ip_name(N) (N)
# define Fp_name(N)

typedef struct Rp_nterm * p_nterm;
# define Kp_nterm 16
# define Np_nterm (Ip_nterm((p_nterm)N_INIT( \
	GetNode(sizeof(struct Rp_nterm),Kp_nterm), \
	Kp_nterm,sizeof(struct Rp_nterm))))
# define Dp_nterm(n) {Fp_nterm(n); FreeNode(n, Kp_nterm);}
# define Ip_nterm(N) (N)
# define Fp_nterm(N)

typedef struct Rp_nval * p_nval;
# define Kp_nval 18
# define Np_nval (Ip_nval((p_nval)N_INIT( \
	GetNode(sizeof(struct Rp_nval),Kp_nval), \
	Kp_nval,sizeof(struct Rp_nval))))
# define Dp_nval(n) {Fp_nval(n); FreeNode(n, Kp_nval);}
# define Ip_nval(N) (N)
# define Fp_nval(N)

typedef struct Rp_opt * p_opt;
# define Kp_opt 20
# define Np_opt (Ip_opt((p_opt)N_INIT( \
	GetNode(sizeof(struct Rp_opt),Kp_opt), \
	Kp_opt,sizeof(struct Rp_opt))))
# define Dp_opt(n) {Fp_opt(n); FreeNode(n, Kp_opt);}
# define Ip_opt(N) (N)
# define Fp_opt(N)

typedef struct Rp_other * p_other;
# define Kp_other 22
# define Np_other (Ip_other((p_other)N_INIT( \
	GetNode(sizeof(struct Rp_other),Kp_other), \
	Kp_other,sizeof(struct Rp_other))))
# define Dp_other(n) {Fp_other(n); FreeNode(n, Kp_other);}
# define Ip_other(N) (N)
# define Fp_other(N)

typedef struct Rp_plus * p_plus;
# define Kp_plus 24
# define Np_plus (Ip_plus((p_plus)N_INIT( \
	GetNode(sizeof(struct Rp_plus),Kp_plus), \
	Kp_plus,sizeof(struct Rp_plus))))
# define Dp_plus(n) {Fp_plus(n); FreeNode(n, Kp_plus);}
# define Ip_plus(N) (N)
# define Fp_plus(N)

typedef struct Rp_prod * p_prod;
# define Kp_prod 26
# define Np_prod (Ip_prod((p_prod)N_INIT( \
	GetNode(sizeof(struct Rp_prod),Kp_prod), \
	Kp_prod,sizeof(struct Rp_prod))))
# define Dp_prod(n) {Fp_prod(n); FreeNode(n, Kp_prod);}
# define Ip_prod(N) (N)
# define Fp_prod(N)

typedef struct Rp_prop * p_prop;
# define Kp_prop 28
# define Np_prop (Ip_prop((p_prop)N_INIT( \
	GetNode(sizeof(struct Rp_prop),Kp_prop), \
	Kp_prop,sizeof(struct Rp_prop))))
# define Dp_prop(n) {Fp_prop(n); FreeNode(n, Kp_prop);}
# define Ip_prop(N) (N)
# define Fp_prop(N)

typedef struct Rp_prop_val * p_prop_val;
# define Kp_prop_val 30
# define Np_prop_val (Ip_prop_val((p_prop_val)N_INIT( \
	GetNode(sizeof(struct Rp_prop_val),Kp_prop_val), \
	Kp_prop_val,sizeof(struct Rp_prop_val))))
# define Dp_prop_val(n) {Fp_prop_val(n); FreeNode(n, Kp_prop_val);}
# define Ip_prop_val(N) (N)
# define Fp_prop_val(N)

typedef struct Rp_star * p_star;
# define Kp_star 32
# define Np_star (Ip_star((p_star)N_INIT( \
	GetNode(sizeof(struct Rp_star),Kp_star), \
	Kp_star,sizeof(struct Rp_star))))
# define Dp_star(n) {Fp_star(n); FreeNode(n, Kp_star);}
# define Ip_star(N) (N)
# define Fp_star(N)

typedef struct Rp_string * p_string;
# define Kp_string 34
# define Np_string (Ip_string((p_string)N_INIT( \
	GetNode(sizeof(struct Rp_string),Kp_string), \
	Kp_string,sizeof(struct Rp_string))))
# define Dp_string(n) {Fp_string(n); FreeNode(n, Kp_string);}
# define Ip_string(N) (N)
# define Fp_string(N)

typedef struct Rp_sval * p_sval;
# define Kp_sval 36
# define Np_sval (Ip_sval((p_sval)N_INIT( \
	GetNode(sizeof(struct Rp_sval),Kp_sval), \
	Kp_sval,sizeof(struct Rp_sval))))
# define Dp_sval(n) {Fp_sval(n); FreeNode(n, Kp_sval);}
# define Ip_sval(N) (N)
# define Fp_sval(N)

typedef struct Rp_term * p_term;
# define Kp_term 38
# define Np_term (Ip_term((p_term)N_INIT( \
	GetNode(sizeof(struct Rp_term),Kp_term), \
	Kp_term,sizeof(struct Rp_term))))
# define Dp_term(n) {Fp_term(n); FreeNode(n, Kp_term);}
# define Ip_term(N) (N)
# define Fp_term(N)


/* Classes */
typedef union {
    someptr IDLinternal;
    CPsymb_entry IDLclassCommon;
    p_string Vp_string;
    p_name Vp_name;
} symb_entry;

typedef union {
    someptr IDLinternal;
    CPdef_entry IDLclassCommon;
    p_term Vp_term;
    p_nterm Vp_nterm;
    p_other Vp_other;
    p_prod Vp_prod;
} def_entry;

typedef union {
    someptr IDLinternal;
    HgenericHeader IDLclassCommon;
    p_alt Vp_alt;
    p_opt Vp_opt;
    p_plus Vp_plus;
    p_star Vp_star;
    p_delrep Vp_delrep;
    p_elunit Vp_elunit;
} unit;

typedef union {
    someptr IDLinternal;
    CPprop_entry IDLclassCommon;
    p_prop Vp_prop;
    p_prop_val Vp_prop_val;
} prop_entry;

typedef union {
    someptr IDLinternal;
    HgenericHeader IDLclassCommon;
    p_sval Vp_sval;
    p_nval Vp_nval;
    p_dval Vp_dval;
    p_lval Vp_lval;
} value;


/* Sets and Sequences */
typedef struct IDLtag1{
        struct IDLtag1 *next;
        value value;
} Cvalue, *Lvalue;

# define SEQvalue Lvalue
# define inSEQvalue(valueseq,valuevalue) IDLInList((pGenList)valueseq,valuevalue.IDLinternal)
# define initializeSEQvalue(valueseq) valueseq = NULL
# define appendfrontSEQvalue(valueseq,valuevalue) valueseq=\
		(SEQvalue)IDLListAddFront((pGenList)valueseq,valuevalue.IDLinternal)
# define appendrearSEQvalue(valueseq,valuevalue) valueseq=\
		(SEQvalue)IDLListAddRear((pGenList)valueseq,valuevalue.IDLinternal)
# define orderedinsertSEQvalue(valueseq,valuevalue,valuecompfn) valueseq=\
		(SEQvalue)IDLListOrderedInsert((pGenList)valueseq,valuevalue.IDLinternal,valuecompfn)
# define retrievefirstSEQvalue(valueseq, valuevalue)\
 		valuevalue.IDLclassCommon = (HgenericHeader)IDLListRetrieveFirst((pGenList)valueseq)
# define retrievelastSEQvalue(valueseq, valuevalue)\
 		valuevalue.IDLclassCommon = (HgenericHeader)IDLListRetrieveLast((pGenList)valueseq)
# define ithinSEQvalue(valueseq, index, valuevalue)\
		valuevalue.IDLclassCommon = (HgenericHeader)IDLListRetrieveIth((pGenList)valueseq, index)
# define tailSEQvalue(valueseq)\
		((valueseq) ? valueseq->next : NULL)
# define removefirstSEQvalue(valueseq) valueseq=\
		(SEQvalue)IDLListRemoveFirstCell((pGenList)valueseq)
# define removeSEQvalue(valueseq,valuevalue) valueseq=\
		(SEQvalue)IDLListRemoveCell((pGenList)valueseq,valuevalue.IDLinternal)
# define removelastSEQvalue(valueseq) valueseq=\
		(SEQvalue)IDLListRemoveLastCell((pGenList)valueseq)
# define foreachinSEQvalue(valueseq,valueptr,valuevalue) for\
(valueptr = valueseq; \
		valueptr!=NULL&&((valuevalue.IDLinternal=valueptr->value.IDLinternal)||1); \
valueptr=valueptr->next)
# define emptySEQvalue(valueseq) ((valueseq)==NULL)
# define lengthSEQvalue(valueseq) IDLListLength(valueseq)
# define copySEQvalue(valueseq) (SEQvalue)IDLListCopy(valueseq)
# define sortSEQvalue(valueseq, cmpfn) valueseq = (SEQvalue)IDLListSort(valueseq, cmpfn)

typedef struct IDLtag2{
        struct IDLtag2 *next;
        prop_entry value;
} Cprop_entry, *Lprop_entry;

# define SEQprop_entry Lprop_entry
# define inSEQprop_entry(prop_entryseq,prop_entryvalue) IDLInList((pGenList)prop_entryseq,prop_entryvalue.IDLinternal)
# define initializeSEQprop_entry(prop_entryseq) prop_entryseq = NULL
# define appendfrontSEQprop_entry(prop_entryseq,prop_entryvalue) prop_entryseq=\
		(SEQprop_entry)IDLListAddFront((pGenList)prop_entryseq,prop_entryvalue.IDLinternal)
# define appendrearSEQprop_entry(prop_entryseq,prop_entryvalue) prop_entryseq=\
		(SEQprop_entry)IDLListAddRear((pGenList)prop_entryseq,prop_entryvalue.IDLinternal)
# define orderedinsertSEQprop_entry(prop_entryseq,prop_entryvalue,prop_entrycompfn) prop_entryseq=\
		(SEQprop_entry)IDLListOrderedInsert((pGenList)prop_entryseq,prop_entryvalue.IDLinternal,prop_entrycompfn)
# define retrievefirstSEQprop_entry(prop_entryseq, prop_entryvalue)\
 		prop_entryvalue.IDLclassCommon = (CPprop_entry)IDLListRetrieveFirst((pGenList)prop_entryseq)
# define retrievelastSEQprop_entry(prop_entryseq, prop_entryvalue)\
 		prop_entryvalue.IDLclassCommon = (CPprop_entry)IDLListRetrieveLast((pGenList)prop_entryseq)
# define ithinSEQprop_entry(prop_entryseq, index, prop_entryvalue)\
		prop_entryvalue.IDLclassCommon = (CPprop_entry)IDLListRetrieveIth((pGenList)prop_entryseq, index)
# define tailSEQprop_entry(prop_entryseq)\
		((prop_entryseq) ? prop_entryseq->next : NULL)
# define removefirstSEQprop_entry(prop_entryseq) prop_entryseq=\
		(SEQprop_entry)IDLListRemoveFirstCell((pGenList)prop_entryseq)
# define removeSEQprop_entry(prop_entryseq,prop_entryvalue) prop_entryseq=\
		(SEQprop_entry)IDLListRemoveCell((pGenList)prop_entryseq,prop_entryvalue.IDLinternal)
# define removelastSEQprop_entry(prop_entryseq) prop_entryseq=\
		(SEQprop_entry)IDLListRemoveLastCell((pGenList)prop_entryseq)
# define foreachinSEQprop_entry(prop_entryseq,prop_entryptr,prop_entryvalue) for\
(prop_entryptr = prop_entryseq; \
		prop_entryptr!=NULL&&((prop_entryvalue.IDLinternal=prop_entryptr->value.IDLinternal)||1); \
prop_entryptr=prop_entryptr->next)
# define emptySEQprop_entry(prop_entryseq) ((prop_entryseq)==NULL)
# define lengthSEQprop_entry(prop_entryseq) IDLListLength(prop_entryseq)
# define copySEQprop_entry(prop_entryseq) (SEQprop_entry)IDLListCopy(prop_entryseq)
# define sortSEQprop_entry(prop_entryseq, cmpfn) prop_entryseq = (SEQprop_entry)IDLListSort(prop_entryseq, cmpfn)

typedef struct IDLtag3{
        struct IDLtag3 *next;
        unit value;
} Cunit, *Lunit;

# define SEQunit Lunit
# define inSEQunit(unitseq,unitvalue) IDLInList((pGenList)unitseq,unitvalue.IDLinternal)
# define initializeSEQunit(unitseq) unitseq = NULL
# define appendfrontSEQunit(unitseq,unitvalue) unitseq=\
		(SEQunit)IDLListAddFront((pGenList)unitseq,unitvalue.IDLinternal)
# define appendrearSEQunit(unitseq,unitvalue) unitseq=\
		(SEQunit)IDLListAddRear((pGenList)unitseq,unitvalue.IDLinternal)
# define orderedinsertSEQunit(unitseq,unitvalue,unitcompfn) unitseq=\
		(SEQunit)IDLListOrderedInsert((pGenList)unitseq,unitvalue.IDLinternal,unitcompfn)
# define retrievefirstSEQunit(unitseq, unitvalue)\
 		unitvalue.IDLclassCommon = (HgenericHeader)IDLListRetrieveFirst((pGenList)unitseq)
# define retrievelastSEQunit(unitseq, unitvalue)\
 		unitvalue.IDLclassCommon = (HgenericHeader)IDLListRetrieveLast((pGenList)unitseq)
# define ithinSEQunit(unitseq, index, unitvalue)\
		unitvalue.IDLclassCommon = (HgenericHeader)IDLListRetrieveIth((pGenList)unitseq, index)
# define tailSEQunit(unitseq)\
		((unitseq) ? unitseq->next : NULL)
# define removefirstSEQunit(unitseq) unitseq=\
		(SEQunit)IDLListRemoveFirstCell((pGenList)unitseq)
# define removeSEQunit(unitseq,unitvalue) unitseq=\
		(SEQunit)IDLListRemoveCell((pGenList)unitseq,unitvalue.IDLinternal)
# define removelastSEQunit(unitseq) unitseq=\
		(SEQunit)IDLListRemoveLastCell((pGenList)unitseq)
# define foreachinSEQunit(unitseq,unitptr,unitvalue) for\
(unitptr = unitseq; \
		unitptr!=NULL&&((unitvalue.IDLinternal=unitptr->value.IDLinternal)||1); \
unitptr=unitptr->next)
# define emptySEQunit(unitseq) ((unitseq)==NULL)
# define lengthSEQunit(unitseq) IDLListLength(unitseq)
# define copySEQunit(unitseq) (SEQunit)IDLListCopy(unitseq)
# define sortSEQunit(unitseq, cmpfn) unitseq = (SEQunit)IDLListSort(unitseq, cmpfn)

typedef struct IDLtag4{
        struct IDLtag4 *next;
        def_entry value;
} Cdef_entry, *Ldef_entry;

# define SEQdef_entry Ldef_entry
# define inSEQdef_entry(def_entryseq,def_entryvalue) IDLInList((pGenList)def_entryseq,def_entryvalue.IDLinternal)
# define initializeSEQdef_entry(def_entryseq) def_entryseq = NULL
# define appendfrontSEQdef_entry(def_entryseq,def_entryvalue) def_entryseq=\
		(SEQdef_entry)IDLListAddFront((pGenList)def_entryseq,def_entryvalue.IDLinternal)
# define appendrearSEQdef_entry(def_entryseq,def_entryvalue) def_entryseq=\
		(SEQdef_entry)IDLListAddRear((pGenList)def_entryseq,def_entryvalue.IDLinternal)
# define orderedinsertSEQdef_entry(def_entryseq,def_entryvalue,def_entrycompfn) def_entryseq=\
		(SEQdef_entry)IDLListOrderedInsert((pGenList)def_entryseq,def_entryvalue.IDLinternal,def_entrycompfn)
# define retrievefirstSEQdef_entry(def_entryseq, def_entryvalue)\
 		def_entryvalue.IDLclassCommon = (CPdef_entry)IDLListRetrieveFirst((pGenList)def_entryseq)
# define retrievelastSEQdef_entry(def_entryseq, def_entryvalue)\
 		def_entryvalue.IDLclassCommon = (CPdef_entry)IDLListRetrieveLast((pGenList)def_entryseq)
# define ithinSEQdef_entry(def_entryseq, index, def_entryvalue)\
		def_entryvalue.IDLclassCommon = (CPdef_entry)IDLListRetrieveIth((pGenList)def_entryseq, index)
# define tailSEQdef_entry(def_entryseq)\
		((def_entryseq) ? def_entryseq->next : NULL)
# define removefirstSEQdef_entry(def_entryseq) def_entryseq=\
		(SEQdef_entry)IDLListRemoveFirstCell((pGenList)def_entryseq)
# define removeSEQdef_entry(def_entryseq,def_entryvalue) def_entryseq=\
		(SEQdef_entry)IDLListRemoveCell((pGenList)def_entryseq,def_entryvalue.IDLinternal)
# define removelastSEQdef_entry(def_entryseq) def_entryseq=\
		(SEQdef_entry)IDLListRemoveLastCell((pGenList)def_entryseq)
# define foreachinSEQdef_entry(def_entryseq,def_entryptr,def_entryvalue) for\
(def_entryptr = def_entryseq; \
		def_entryptr!=NULL&&((def_entryvalue.IDLinternal=def_entryptr->value.IDLinternal)||1); \
def_entryptr=def_entryptr->next)
# define emptySEQdef_entry(def_entryseq) ((def_entryseq)==NULL)
# define lengthSEQdef_entry(def_entryseq) IDLListLength(def_entryseq)
# define copySEQdef_entry(def_entryseq) (SEQdef_entry)IDLListCopy(def_entryseq)
# define sortSEQdef_entry(def_entryseq, cmpfn) def_entryseq = (SEQdef_entry)IDLListSort(def_entryseq, cmpfn)

typedef struct IDLtag5{
        struct IDLtag5 *next;
        symb_entry value;
} Csymb_entry, *Lsymb_entry;

# define SEQsymb_entry Lsymb_entry
# define inSEQsymb_entry(symb_entryseq,symb_entryvalue) IDLInList((pGenList)symb_entryseq,symb_entryvalue.IDLinternal)
# define initializeSEQsymb_entry(symb_entryseq) symb_entryseq = NULL
# define appendfrontSEQsymb_entry(symb_entryseq,symb_entryvalue) symb_entryseq=\
		(SEQsymb_entry)IDLListAddFront((pGenList)symb_entryseq,symb_entryvalue.IDLinternal)
# define appendrearSEQsymb_entry(symb_entryseq,symb_entryvalue) symb_entryseq=\
		(SEQsymb_entry)IDLListAddRear((pGenList)symb_entryseq,symb_entryvalue.IDLinternal)
# define orderedinsertSEQsymb_entry(symb_entryseq,symb_entryvalue,symb_entrycompfn) symb_entryseq=\
		(SEQsymb_entry)IDLListOrderedInsert((pGenList)symb_entryseq,symb_entryvalue.IDLinternal,symb_entrycompfn)
# define retrievefirstSEQsymb_entry(symb_entryseq, symb_entryvalue)\
 		symb_entryvalue.IDLclassCommon = (CPsymb_entry)IDLListRetrieveFirst((pGenList)symb_entryseq)
# define retrievelastSEQsymb_entry(symb_entryseq, symb_entryvalue)\
 		symb_entryvalue.IDLclassCommon = (CPsymb_entry)IDLListRetrieveLast((pGenList)symb_entryseq)
# define ithinSEQsymb_entry(symb_entryseq, index, symb_entryvalue)\
		symb_entryvalue.IDLclassCommon = (CPsymb_entry)IDLListRetrieveIth((pGenList)symb_entryseq, index)
# define tailSEQsymb_entry(symb_entryseq)\
		((symb_entryseq) ? symb_entryseq->next : NULL)
# define removefirstSEQsymb_entry(symb_entryseq) symb_entryseq=\
		(SEQsymb_entry)IDLListRemoveFirstCell((pGenList)symb_entryseq)
# define removeSEQsymb_entry(symb_entryseq,symb_entryvalue) symb_entryseq=\
		(SEQsymb_entry)IDLListRemoveCell((pGenList)symb_entryseq,symb_entryvalue.IDLinternal)
# define removelastSEQsymb_entry(symb_entryseq) symb_entryseq=\
		(SEQsymb_entry)IDLListRemoveLastCell((pGenList)symb_entryseq)
# define foreachinSEQsymb_entry(symb_entryseq,symb_entryptr,symb_entryvalue) for\
(symb_entryptr = symb_entryseq; \
		symb_entryptr!=NULL&&((symb_entryvalue.IDLinternal=symb_entryptr->value.IDLinternal)||1); \
symb_entryptr=symb_entryptr->next)
# define emptySEQsymb_entry(symb_entryseq) ((symb_entryseq)==NULL)
# define lengthSEQsymb_entry(symb_entryseq) IDLListLength(symb_entryseq)
# define copySEQsymb_entry(symb_entryseq) (SEQsymb_entry)IDLListCopy(symb_entryseq)
# define sortSEQsymb_entry(symb_entryseq, cmpfn) symb_entryseq = (SEQsymb_entry)IDLListSort(symb_entryseq, cmpfn)


/* Class Attributes */
struct CAsymb_entry {
    IDLnodeHeader IDLhidden;
    int sid;
    String str;
};
struct CAdef_entry {
    IDLnodeHeader IDLhidden;
    int did;
    int sid;
    SEQprop_entry prop;
};
struct CAprop_entry {
    IDLnodeHeader IDLhidden;
    int did;
    int sid;
};

/* Node Structures*/
struct Rp_alt { IDLnodeHeader IDLhidden;
    SEQunit rhs2;
    SEQunit rhs1;
};
struct Rp_comar { IDLnodeHeader IDLhidden;
    SEQdef_entry definitions;
    SEQsymb_entry symbols;
};
struct Rp_delrep { IDLnodeHeader IDLhidden;
    SEQunit sep;
    SEQunit rhs;
};
struct Rp_dval { IDLnodeHeader IDLhidden;
    int did;
};
struct Rp_elunit { IDLnodeHeader IDLhidden;
    int did;
};
struct Rp_lval { IDLnodeHeader IDLhidden;
    SEQvalue list;
};
struct Rp_name { IDLnodeHeader IDLhidden;
    int sid;
    String str;
};
struct Rp_nterm { IDLnodeHeader IDLhidden;
    int did;
    int sid;
    SEQprop_entry prop;
};
struct Rp_nval { IDLnodeHeader IDLhidden;
    int val;
};
struct Rp_opt { IDLnodeHeader IDLhidden;
    SEQunit rhs;
};
struct Rp_other { IDLnodeHeader IDLhidden;
    int did;
    int sid;
    SEQprop_entry prop;
};
struct Rp_plus { IDLnodeHeader IDLhidden;
    SEQunit rhs;
};
struct Rp_prod { IDLnodeHeader IDLhidden;
    int did;
    int sid;
    SEQprop_entry prop;
    SEQunit rhs;
    int lhsdid;
};
struct Rp_prop { IDLnodeHeader IDLhidden;
    int did;
    int sid;
};
struct Rp_prop_val { IDLnodeHeader IDLhidden;
    int did;
    int sid;
    value val;
};
struct Rp_star { IDLnodeHeader IDLhidden;
    SEQunit rhs;
};
struct Rp_string { IDLnodeHeader IDLhidden;
    int sid;
    String str;
};
struct Rp_sval { IDLnodeHeader IDLhidden;
    int sid;
};
struct Rp_term { IDLnodeHeader IDLhidden;
    int did;
    int sid;
    SEQprop_entry prop;
};

/* Port Declarations */
void OUTPUT();
p_comar INPUT();

#endif

