#!/usr/bin/perl -w
#
# Makedistrib.pl: create package to be distributed
#
# Laurent.Gougeon@ecmwf.int - 2011-09-21
#
# Required libraries to run this script:
#
#  perl -MCPAN -e "install PAR"
#  perl -MCPAN -e "install PAR::Packer"
#  perl -MCPAN -e "install Archive::Tar"
#

use Cwd;
use File::Path;
use Archive::Tar;

# Get the ECaccess version number
#
my $cwd     = getcwd();
my $version = substr $cwd, -5, length($cwd);

# Get the target system name (OS)
#
my $system;
if ( $^O =~ /^MSWin/ ) {
	$system = "Windows";
} else {
	my $unameS = `uname -s 2>&1`;
	my $unameM = `uname -m 2>&1`;
	chomp($unameS);
	chomp($unameM);

	if ( $ENV{'ECACCESS_OS'} ) {
		$unameS = $ENV{'ECACCESS_OS'};
	}

	$system = $unameS . "-" . $unameM;
}

# Build the package name
#
my $packageName = "ecaccess-webtoolkit-" . $version . "-" . $system;

# Clean/create the target directory
#
rmtree $packageName;
mkdir $packageName;

# Get the list of scripts from the MANIFEST
#
my $scriptsList = "";
open( MANIFEST, "MANIFEST" );
while ( $record = <MANIFEST> ) {
	chomp($record);
	$scriptsList = "$scriptsList $record" if ( $record =~ m/^script/ );
}
close(MANIFEST);

# Get the Runtime dependencies and options
#
my $dependencies = "--compress=9 -M IO::Socket::INET6 -M IO::Socket::SSL";

# Create the distribution
#
if ( $^O =~ /^MSWin/ ) {

	# Process the Windows package
	foreach ( split( / /, $scriptsList ) ) {
		$name = $_;
		if ( length($name) > 7 ) {
			my $pp = "pp " . $dependencies . " --tempcache=$packageName --output=$packageName/" . ( substr $name, 7 ) . ".exe " . $name;
			print $pp, "\n";
			`$pp`;
			die "Packing failed: $!" if not( $? >> 8 == 0 );
		}
	}
}
else {

	# Process the Unix packages
	my $pp = "pp " . $dependencies . " --output=$packageName/.ecaccess $scriptsList";
	print $pp, "\n";
	`$pp`;
	die "Packing failed: $!" if not( $? >> 8 == 0 );

	# Goto the distrib directory
	chdir $packageName or die "Chdir failed ($packageName):  $!";

	# Create the links/copies
	$source = ".ecaccess";
	foreach ( split( / /, $scriptsList ) ) {
		$name = $_;
		if ( length($name) > 7 ) {
			print "ln ", $source, "->", ( substr $name, 7 ), "\n";
			symlink $source, ( substr $name, 7 );
		}
	}

	# Go back to the main directory
	chdir "..";
}

# Build the list of files to distribute
#
@tarfiles = <$packageName/*>;

# If Unix then push the ".ecaccess" file
push( @tarfiles, "$packageName/.ecaccess" ) if ( not $^O =~ /^MSWin/ );

# Compress the distribution files
#
print "Packing in tgz\n";
Archive::Tar->create_archive( "$packageName" . ".tar.gz", 9, @tarfiles );

# Clean
#
rmtree $packageName;
