#ifndef PURE_X

/* 
    gtvscreen for v4l frame grabber driver

    Copyright (C) 1999 Marcus Metzler (mocm@metzlerbros.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __GTVSCREEN_H__
#define __GTVSCREEN_H__

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <X11/Xlib.h>
#include <X11/extensions/xf86dga.h>
#include <X11/IntrinsicP.h>
#include <X11/ObjectP.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <gdk/gdktypes.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkeventbox.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#undef HAVE_LIBXV

#ifndef NOCARD
#include <linux/videodev.h>
#endif
	/* some defaults */
#define DCOL 254
#define DBRI 0
#define DHUE 0
#define DCONTRAST 216
#define DNORM  PAL
#define DIN COMP1
#define MAXCLIP 200
#define DEFAULT_WIDTH 400
#define DEFAULT_HEIGHT 300
#define FULLX 640
#define FULLY 480
#define FULLX1 720
#define FULLY1 576
#define FULLX2 800
#define FULLY2 600


#ifdef HAVE_LIBXV
#define xv_width 320 
#define xv_height 240
#endif


enum
{
  GTV_NOTHING,
  GTV_CAP,
  GTV_OVL,
  GTV_DEVICE,
  GTV_NORM,
  GTV_INPUT,
  GTV_BRIGHT,
  GTV_COLOR,
  GTV_HUE,
  GTV_CONTRAST,
  GTV_WHITE,
  GTV_BPP,
  GTV_VISNAME,
  GTV_AUDIO,
  GTV_REALW,
  GTV_REMOTE,
  GTV_NINPUT,
  GTV_NAUDIO,
  GTV_FULLS,
  GTV_FD,
  GTV_MAXX,
  GTV_MAXY,
  GTV_COVL
};

extern char *combost[];

#define GTVSCREEN(obj)          GTK_CHECK_CAST (obj, gtvscreen_get_type (), Gtvscreen)
#define GTVSCREEN_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtvscreen_get_type (), GtvscreenClass)
#define IS_GTVSCREEN(obj)       GTK_CHECK_TYPE (obj, gtvscreen_get_type ())


typedef struct _Gtvscreen Gtvscreen;
typedef struct _GtvscreenClass GtvscreenClass;

struct _Gtvscreen
{
  GtkWidget widget;

  /* resources */
  gchar     devname[20];
  gint      CAP_ON;
  gint      OVL_ON;
  gint      pause;
  gint      dummy;	/* there is some kind of wrong memory access */
  gint      bpp;
  gchar    *visname;
  gint      realw;

#ifndef NOCARD
  struct video_window     vwin;
  struct video_buffer     vbuf;
  struct video_tuner      vtuner;
  struct video_clip       cliprecs[MAXCLIP];
  guchar                 *TargetMem;
  struct video_mbuf       mbuf;
  struct video_play_mode  pmode;
#endif

  /* private state */
  struct video_picture     vp;
  struct video_channel     vc;
  struct video_audio       va;
  struct video_capability  vcap;
  gint                     fbttv;
  gboolean                 Change;
  GdkVisual               *visual;
  GdkColor                 colors[256];
  GdkColormap             *cmap;
  gboolean                 CMSET;
  gint                     audio_state;
  guint                    Format;
  GdkImage                *image;
  GdkGC                   *gc;
  gboolean                 start;
  gboolean                 stop;
  gboolean                 remote;
  GtkAccelGroup           *accel_group;
  gint                     timeout;
  gint                     refresh;
  gboolean                 Move;
  Window                   lastrwin;
#ifdef HAVE_LIBXXF86VM
  gint  next_vid;
  gint  isfull;
#endif
#ifdef HAVE_LIBXV
  XvImage                   *xv_im;
  void                      *xv_shm;
#endif

};

struct _GtvscreenClass
{
  GtkVBoxClass parent_class;

  void (* chinput)   (Gtvscreen *gtv);
  void (* chcapture) (Gtvscreen *gtv);
  void (* choverlay) (Gtvscreen *gtv);
  void (* chattrib)  (Gtvscreen *gtv);
  void (* chfreq)    (Gtvscreen *gtv);
  void (* chaudio)   (Gtvscreen *gtv);
  void (* chplay)    (Gtvscreen *gtv);
  void (* chstop)    (Gtvscreen *gtv);
  void (* chpause)   (Gtvscreen *gtv);
  void (* chrecord)  (Gtvscreen *gtv);
  void (* chffwd)    (Gtvscreen *gtv);
  void (* chfbwd)    (Gtvscreen *gtv);
  void (* chfskp)    (Gtvscreen *gtv);
  void (* chbskp)    (Gtvscreen *gtv);
};

guint       gtvscreen_get_type     (void);

GtkWidget * gtvscreen_new          (void);
GtkWidget * gtvscreen_new_with_dev (gchar     *dev);
GtkWidget * gtvscreen_new_with_fd  (gint       fd);

gboolean    gtvscreen_set_values   (Gtvscreen *gtv,
				    gint       val_type,
				    gpointer   value);
gboolean    gtvscreen_get_values   (Gtvscreen *gtv,
				    gint       val_type,
				    gint      *value);

void        gtk_gtvscreen_size     (Gtvscreen *gtv,
				    gint       width,
				    gint       height);


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* ! __GTVSCREEN_H__ */

#endif /* ! PURE_X */
