/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * dscolor.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "dscolor.h"
#include "constants.h"
#include "symbols.h"
#include "pm.h"

#define DSCOLOR_ERROR 0
#define DSCOLOR_OK    1
#define DSCOLOR_USER  2
#define DSCOLOR_DEF   3
#define DSCOLOR_NULL  4

static int dscolor_def = DSCOLOR_NULL;
static int numcolors;

DsColor *user_dscolor;
DsColor dscolor[] = {
        { 255,  0,  0 },  /* red */
        {   0,255,  0 },  /* green */
        {   0,  0,255 },  /* blue */
        { 238,130,238 },  /* violet */
        { 160, 32,240 },  /* purple */
        { 255,255,  0 },  /* yellow */
        { 255,192,203 },  /* pink */
        { 173,216,230 },  /* light blue */
/*        { 255,215,  0 },   gold */
        {   0,255,255 },  /* cyan */
        { 190,190,190 },  /* grey */
/*        {  32,178,170 },   light sea green */
	{ 255,165,  0 },  /* orange */
        { 255,  0,255 },  /* magenta */
	{  46,139, 87 }   /* sea green */
};

int DsColor_init( char* filename )
{
  FILE* fp;
  int   num;
  int   i, r, g, b;

  if( (fp = fopen( filename, "r" ))==NULL  ) {
    dscolor_def = DSCOLOR_DEF;  
    numcolors = MAX_DSCOLOR;
    return (DSCOLOR_ERROR);
  }

 /* read colormap rgb values */ 
  fscanf( fp, "%d", &num);

 /* Use default if user tries to put in less than 4 colors */
  if (num<=N_SYS_COLORS) {
    dscolor_def = DSCOLOR_DEF;
    numcolors = MAX_DSCOLOR;
    return (DSCOLOR_ERROR);
    }

 /* Now, set numcolors */
  if (num < MAX_DSCOLOR) 
    numcolors = num;
  else 
    numcolors = MAX_DSCOLOR;  	

  /*print colormap rgb values to stdout for debugging 
  */
  fprintf( stdout, "\n numcolors ---   %d", numcolors);
 

  user_dscolor = (DsColor*)calloc( numcolors, sizeof(DsColor) );

  for(i=0; i<numcolors; i++ ) {
    fscanf( fp, "%d %d %d", &r, &g, &b );
    fprintf( stdout, "\n%d %d %d", r, g, b );
    user_dscolor[i].r = r; 
    user_dscolor[i].g = g; 
    user_dscolor[i].b = b; 
  }

  dscolor_def = DSCOLOR_USER;
  return (DSCOLOR_OK);
}


DsColor* DsColor_get_rgb( int idx )
{
  char *env_value;
  char path1[MAX_LONG_STR], path2[MAX_LONG_STR], path3[MAX_LONG_STR];

  if( dscolor_def == DSCOLOR_NULL ) {
	/* Try MY_DSTOOL */
    if ( (env_value = getenv("MY_DSTOOL")) != NULL ) {
        strcpy(path1,env_value);
	strcat(path1,"/rgb_color.txt");
	DsColor_init( path1 );
	}
	/* Try DSTOOL */
    if ((dscolor_def != DSCOLOR_USER) && (env_value = getenv("DSTOOL")) != NULL) {
        strcpy(path2,env_value);
        strcat(path2,"/rgb_color.txt");
        DsColor_init( path2 );
        }
	/* Try the current working directory */
    if (dscolor_def != DSCOLOR_USER) {
        strcpy(path3,".");
        strcat(path3,"/rgb_color.txt");
        DsColor_init( path3 );
        }
    pmcolorinfo();
    }

  if( dscolor_def == DSCOLOR_USER )
    return( &user_dscolor[idx] );  
  
  if( dscolor_def == DSCOLOR_DEF )
    return( &dscolor[idx] );  
  
/* none of the above */
  return(DSCOLOR_ERROR);
}
 

int DsColor_get_index( int colormode, int color0, int color1 )
{
  /*
   color index organized

   [0 1 2 3 ....                   N]

    0 Red
    1 Green
    2 Blue

    alternating colors use only 3-N
    pick colors use all of 0-N
  */

  switch(colormode) {
    case 0:
        if( color0 < 0 ) {
          return (color1 % numcolors);
        }
        else {
          return (SYS_COLORS + (color0 % (numcolors - SYS_COLORS)) );
        }
        break;
    case 1:
        return (color1 % numcolors);
        break;
    default:
        return (color1 % numcolors);
        break;
  }
}


int
ncolors()
{
    return numcolors;
}

int 
pmcolorinfo()
{
  int i;

  pm (INIT, "Color.Cont_Colors", N_CONT_COLORS, NULL);
  pm (PUT, "Color.Sys_Colormap_Size", N_SYS_COLORS, NULL);
  pm (PUT, "Color.Traj_Colormap_Size", (numcolors-N_SYS_COLORS), NULL);
  pm (PUT, "Color.Cont_Colormap_Size", N_CONT_COLORS, NULL);
  pm (PUT, "Color.Cont_Colors", 0, SYS_GREEN, NULL);
  for (i=1;i<=3;i++) 
      pm(PUT, "Color.Cont_Colors", i, numcolors-i, NULL);

  return(DSCOLOR_OK); 
}
