/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * pm_hash.h 
 */

#ifndef PM_HASH_h
#define PM_HASH_h

#include <stdarg.h>
#include "pm.h"


#define HASHSIZE 1013  /* this constant should be tweeked to maximize performance */

/* struct pm_list defined in pm.h */
extern struct pm_list *hashtab[];

/* pm_hash.c */
struct pm_list *pm_hash_lookup( char *label );
int pm_query(char *label, int data_type, int i, va_list *pargptr);
struct pm_list *pm_hash_lookup(char *label);
struct pm_list *pm_hash_add( char *label );
int pm_hash_rm( char *label );

/* pm_build.c */
int pm_add_object( char *name );
int pm_delete_object( char *name );
int pm_add_element( char *name, int type );
int pm_rm_element( char *name );
int pm_fnct_exec( char *name );
int pm_valid_obj_name( char *name );
int pm_valid_elmt_name( char *name );

#endif /* PM_HASH_H */
