/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../config.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <gnome.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "callbacks.h"
#include "process.h"
#include "interface.h"
#include "support.h"
#include "drip.h"
#include "../encoder/plugin-loader.hh"

GtkWidget *appbar1;
GtkWidget *textscreen;
GtkWidget *gpixmap;
GtkWidget *hbox_main;
GtkWidget *combo_entry_divx_filename = NULL;
GtkWidget *fileentry_divx;
GtkWidget *plugin_GUI_socket;
GtkWidget *checkbutton_active;
GtkWidget *combo_entry12;
GtkWidget *label_filter_type;
GtkWidget *label_filter_phase;
GtkWidget *hbox35;  // box for buttons for progres frame
static guint druidpagestandard1_next_signal_handler = -1;



/* Backing pixmap for drawing area */
static GdkPixmap *pixmap = NULL;


static GnomeUIInfo file1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Copy DVD"),
    N_("Copy DVD"),
    (gpointer) on_ripdvd_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CDROM,
    GDK_F1, (GdkModifierType) 0, NULL
  },
/*
  {
    GNOME_APP_UI_ITEM, N_("_DVD to VCD"),
    N_("DVD to VCD"),
    (gpointer) on_dvd2vcd_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CONVERT,
    GDK_F2, (GdkModifierType) 0, NULL
  },
*/
  {
    GNOME_APP_UI_ITEM, N_("Select _MPEG input"),
    N_("Select MPEG file(s) as input"),
    (gpointer) on_rescan_for_dvd_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
    GDK_F3, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Stop encoding"),
    N_("Quit encoding"),
    (gpointer) on_stop_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
    GDK_F4, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Pause encoding"),
    N_("Pause & resume encoding"),
    (gpointer) on_pause_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TIMER_STOP,
    GDK_F5, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Eject DVD disk"),
    N_("Ejects the DVD from drive"),
    (gpointer) on_button_eject_clicked, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UP,
    GDK_F6, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Save preferences"),
    N_("Save Preferences"),
    (gpointer) on_save_preferences_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
    GDK_F7, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (on_exit1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo settings1_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (on_preferences1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo help1_menu_uiinfo[] =
{
  GNOMEUIINFO_HELP ((gpointer)"drip"),
  {
    GNOME_APP_UI_ITEM, N_("_Web Site"),
    N_("Open http browser to Drip's web page"),
    (gpointer)on_homepage_activate , NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_ABOUT_ITEM (on_about1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo menubar_uiinfo[] =
{
  GNOMEUIINFO_MENU_FILE_TREE (file1_menu_uiinfo),
  GNOMEUIINFO_MENU_SETTINGS_TREE (settings1_menu_uiinfo),
  GNOMEUIINFO_MENU_HELP_TREE (help1_menu_uiinfo),
  GNOMEUIINFO_END
};

GtkWidget*
create_mainwindow (void) {
  GtkWidget *mainwindow;
  GtkWidget *dock1;
  GtkWidget *toolbar;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *button_main_rip;
  //GtkWidget *button_main_rip2vcd;
  GtkWidget *button_main_rescan;
  GtkWidget *button_main_exit;
  GtkWidget *button_main_pref;
  //GtkWidget *button_stop;
  //GtkWidget *button_pause;
  GtkWidget *scrolledwindow3;
  GtkWidget *button20,*button21,*button22,*button23,*button24,*button25;
  GtkTooltips *tooltips;
  GString *title = g_string_new("");

  g_string_sprintf(title,"Drip %s",VERSION);

  mainwindow = gnome_app_new ("Drip", title->str);
  gtk_window_set_default_size(GTK_WINDOW(mainwindow),Config.mainwindow_X,Config.mainwindow_Y);
  g_string_free(title,TRUE);

  gtk_object_set_data (GTK_OBJECT (mainwindow), "mainwindow", mainwindow);

  dock1 = GNOME_APP (mainwindow)->dock;
  gtk_widget_ref (dock1);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "dock1", dock1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dock1);

  gnome_app_create_menus (GNOME_APP (mainwindow), menubar_uiinfo);

  gtk_widget_ref (menubar_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "file1",
                            menubar_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file1_menu_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "ripdvd",
                            file1_menu_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file1_menu_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "dvd2vcd",
                            file1_menu_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file1_menu_uiinfo[2].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "rescan_for_dvd",
                            file1_menu_uiinfo[2].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file1_menu_uiinfo[3].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "separator1",
                            file1_menu_uiinfo[3].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file1_menu_uiinfo[4].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "exit1",
                            file1_menu_uiinfo[4].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (menubar_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "settings1",
                            menubar_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (settings1_menu_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "preferences1",
                            settings1_menu_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (menubar_uiinfo[2].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "help1",
                            menubar_uiinfo[2].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (help1_menu_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "about1",
                            help1_menu_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_widget_ref (toolbar);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "toolbar", toolbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar);
  gnome_app_add_toolbar (GNOME_APP (mainwindow), GTK_TOOLBAR (toolbar), "toolbar",
                                GNOME_DOCK_ITEM_BEH_EXCLUSIVE
                                | GNOME_DOCK_ITEM_BEH_NEVER_VERTICAL,
                                GNOME_DOCK_TOP, 1, 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (toolbar), 1);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 16);
  gtk_toolbar_set_space_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_SPACE_LINE);
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);

  // ------------------------------------ Progressframeeditor
  tooltips = gtk_tooltips_new ();

  hbox35 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox35);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "hbox35", hbox35,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_hide(hbox35);
  gnome_app_add_docked(GNOME_APP(mainwindow), hbox35, "Progressframeeditor", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 2, 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox35), 0);

  button20 = gnome_stock_button (GNOME_STOCK_BUTTON_UP);
  gtk_widget_ref (button20);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button20", button20,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button20);
  gtk_box_pack_start (GTK_BOX (hbox35), button20, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button20), 0);
  gtk_tooltips_set_tip (tooltips, button20, _(" +  Increases size of the progress frame"), NULL);
  gtk_button_set_relief (GTK_BUTTON (button20), GTK_RELIEF_HALF);

  button21 = gnome_stock_button (GNOME_STOCK_BUTTON_DOWN);
  gtk_widget_ref (button21);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button21", button21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button21);
  gtk_box_pack_start (GTK_BOX (hbox35), button21, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button21), 0);
  gtk_tooltips_set_tip (tooltips, button21, _(" -  Decreases size of the progress frame"), NULL);
  gtk_button_set_relief (GTK_BUTTON (button21), GTK_RELIEF_HALF);

  button23 = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_widget_ref (button23);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button23", button23,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button23);
  gtk_box_pack_start (GTK_BOX (hbox35), button23, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, button23, _("    Refreshes the progress frame"), NULL);
  gtk_button_set_relief (GTK_BUTTON (button23), GTK_RELIEF_HALF);
  button22 = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);
  gtk_widget_ref (button22);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button22", button22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button22);
  gtk_box_pack_start (GTK_BOX (hbox35), button22, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button22), 0);
  gtk_tooltips_set_tip (tooltips, button22, _("Disables the progress frame"), NULL);

  button25 = gtk_button_new_with_label(" Stop ");//gnome_stock_button (GNOME_STOCK_MENU_STOP);
  gtk_widget_ref (button25);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button25", button25,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button25);
  //gtk_label_set_text(GTK_LABEL(GTK_BIN(button25)->child)," STOP ");
  gtk_box_pack_end (GTK_BOX (hbox35), button25, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button25), 0);
  gtk_tooltips_set_tip (tooltips, button25, _(" Stops the encoding process "), NULL);

  button24 = gtk_button_new_with_label(" Pause ");//gnome_stock_button (GNOME_STOCK_MENU_TIMER_STOP);
  gtk_widget_ref (button24);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button24", button24,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button24);
  //gtk_label_set_text(GTK_LABEL(GTK_BIN(button24)->child)," PAUSE ");
  gtk_box_pack_end (GTK_BOX (hbox35), button24, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button24), 0);
  gtk_tooltips_set_tip (tooltips, button24, _(" Pauses (and resumes) the encoding process "), NULL);


  // Signals
  gtk_signal_connect (GTK_OBJECT (button20), "clicked",
                      GTK_SIGNAL_FUNC (on_button20_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button21), "clicked",
                      GTK_SIGNAL_FUNC (on_button21_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button22), "clicked",
                      GTK_SIGNAL_FUNC (on_button22_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button23), "clicked",
                      GTK_SIGNAL_FUNC (on_button23_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button25), "clicked",
                      GTK_SIGNAL_FUNC (on_stop_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button24), "clicked",
                      GTK_SIGNAL_FUNC (on_pause_activate),
                      NULL);



  gtk_object_set_data (GTK_OBJECT (mainwindow), "tooltips", tooltips);



// ------------------------------------ gtk_toolbar

  tmp_toolbar_icon = gnome_stock_pixmap_widget (mainwindow, GNOME_STOCK_PIXMAP_CDROM);
  button_main_rip = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Copy DVD"),
                                _("Converts a DVD title to a divx file"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (button_main_rip);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_main_rip", button_main_rip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_main_rip);

/*
  tmp_toolbar_icon = gnome_stock_pixmap_widget (mainwindow, GNOME_STOCK_PIXMAP_CONVERT);
  button_main_rip2vcd = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("DVD to VCD"),
                                _("Converts a DVD title to a (S)VCD image"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (button_main_rip2vcd);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_main_rip2vcd", button_main_rip2vcd,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_main_rip);
*/
  tmp_toolbar_icon = gnome_stock_pixmap_widget (mainwindow, GNOME_STOCK_PIXMAP_OPEN);
  button_main_rescan = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Copy MPEG"),
                                _("MPEG file(s) as input"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (button_main_rescan);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_main_rescan", button_main_rescan,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_main_rescan);

/*
  tmp_toolbar_icon = gnome_stock_pixmap_widget (mainwindow, GNOME_STOCK_PIXMAP_TIMER_STOP);
  button_pause = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Pause"),
                                _("Pauses (and resumes) current encoding process"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (button_pause);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_pause", button_pause,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_pause);

  tmp_toolbar_icon = gnome_stock_pixmap_widget (mainwindow, GNOME_STOCK_PIXMAP_STOP);
  button_stop = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Stop"),
                                _("Stop current encoding process"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (button_stop);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_stop", button_stop,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_stop);
*/
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  tmp_toolbar_icon = gnome_stock_pixmap_widget (mainwindow, GNOME_STOCK_PIXMAP_PREFERENCES);
  button_main_pref = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Preferences"),
                                _("Setup preferences"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (button_main_pref);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_main_pref", button_main_pref,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_main_pref);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  tmp_toolbar_icon = gnome_stock_pixmap_widget (mainwindow, GNOME_STOCK_PIXMAP_EXIT);
  button_main_exit = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Exit"),
                                _("Exit Drip"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (button_main_exit);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_main_exit", button_main_exit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_main_exit);

  /* Main VBOX */
  hbox_main = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (hbox_main);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "hbox_main", hbox_main,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox_main);
  gnome_app_set_contents (GNOME_APP (mainwindow), hbox_main);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_main), 0);

  /* Progress frame pixmap */
  gpixmap = NULL;

  /* Logging display */
  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow3);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "scrolledwindow3", scrolledwindow3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow3);
  gtk_box_pack_end (GTK_BOX (hbox_main), scrolledwindow3, TRUE, TRUE, 1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  textscreen = gtk_text_new (NULL, NULL);
  gtk_widget_ref (textscreen);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "textscreen", textscreen,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_text_set_line_wrap(GTK_TEXT(textscreen),TRUE);
  gtk_widget_show (textscreen);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), textscreen);
  /* Logging display end */

  appbar1 = gnome_appbar_new (TRUE, TRUE, GNOME_PREFERENCES_NEVER);
  gtk_widget_ref (appbar1);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "appbar1", appbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (appbar1);
  gnome_app_set_statusbar (GNOME_APP (mainwindow), appbar1);

  gtk_signal_connect (GTK_OBJECT (mainwindow), "destroy_event",
                      GTK_SIGNAL_FUNC (on_mainwindow_destroy_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (mainwindow), "delete_event",
                      GTK_SIGNAL_FUNC (on_mainwindow_delete_event),
                      NULL);
  gnome_app_install_menu_hints (GNOME_APP (mainwindow), menubar_uiinfo);
  gtk_signal_connect (GTK_OBJECT (button_main_rip), "clicked",
                      GTK_SIGNAL_FUNC (on_button_main_rip_clicked),
                      NULL);
/*
  gtk_signal_connect (GTK_OBJECT (button_main_rip2vcd), "clicked",
                      GTK_SIGNAL_FUNC (on_button_main_dvd2vcd_clicked),
                      NULL);
*/
  gtk_signal_connect (GTK_OBJECT (button_main_rescan), "clicked",
                      GTK_SIGNAL_FUNC (on_button_main_rescan_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_main_pref), "clicked",
                      GTK_SIGNAL_FUNC (on_preferences1_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_main_exit), "clicked",
                      GTK_SIGNAL_FUNC (on_button_main_exit_clicked),
                      NULL);
/*
  gtk_signal_connect (GTK_OBJECT (button_stop), "clicked",
                      GTK_SIGNAL_FUNC (on_stop_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_pause), "clicked",
                      GTK_SIGNAL_FUNC (on_pause_activate),
                      NULL);
*/
  return mainwindow;
}

void bind_titles_guitype(void) {

    if (druidpagestandard1 == NULL) return;

    if (/*Config.conversion_mode == DVDTITLE_DVDDISK || Config.conversion_mode == DVDTITLE_DVDIMAGE ||*/ Config.useDVDdevice) {
        if (druidpagestandard1_next_signal_handler != -1) 
            gtk_signal_disconnect(GTK_OBJECT(druidpagestandard1),druidpagestandard1_next_signal_handler);
        druidpagestandard1_next_signal_handler = gtk_signal_connect(GTK_OBJECT(druidpagestandard1),"next",GTK_SIGNAL_FUNC (on_drip_druid_next),NULL);
    } else {
        if (druidpagestandard1_next_signal_handler != -1) 
            gtk_signal_disconnect(GTK_OBJECT(druidpagestandard1),druidpagestandard1_next_signal_handler);
        druidpagestandard1_next_signal_handler = gtk_signal_connect (GTK_OBJECT(druidpagestandard1),"next",GTK_SIGNAL_FUNC(on_drip_druid_next_cache),NULL);
    }
    return;
}

GtkWidget* 
create_configdruid(void) {
  GtkWidget *drip_druid;
  GtkWidget *druidpagestart1;
  GdkColor druidpagestart1_bg_color = { 0, 110, 110, 496 };
  GdkColor druidpagestart1_textbox_color = { 0, 45179, 45179, 45179 };
  GdkColor druidpagestart1_title_color = { 0, 65535, 65535, 65535 };
  GtkWidget *druidpagestandard2;
  GtkWidget *druidpagestandard3;
  GtkWidget *druidpagestandard4;
  GtkWidget *druid_vbox1;
  GtkWidget *druid_vbox4;
  GtkWidget *hbox18;
  GtkWidget *hbox4;
  GtkWidget *hbox5;
  GtkWidget *hbox6;
  GtkWidget *vbox11;
  GtkWidget *label7;
  GtkWidget *druidpagefinish1;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *fileentry3dvddevice;
  GtkWidget *fileentry3location;
  GtkWidget *combo2;
  GtkWidget *combo3;
  GtkWidget *checkbutton_eject;
  GtkWidget *hseparator2;
  GtkWidget *hbox19;
  GtkWidget *hbox23;
  GtkWidget *combo_title;
  GtkWidget *label_ripdvd_select_audio_channel;
  GtkWidget *label_ripdvd_select_2nd_audio_channel;
  GtkWidget *vbox9;
  GtkWidget *vbox9_2nd;
  GtkWidget *vbox23;
  GtkObject *spinbutton_video_bitrate_adj;
  GtkWidget *spinbutton_video_bitrate;
  GtkWidget *button_calculate_bitrate;
  GtkWidget *label_divx_audio_bitrate;
  GtkWidget *combo_audio_bitrate;
  GtkWidget *label_divx_video_bitrate;
  GList *combo_audio_bitrate_items = NULL;
  GtkWidget *combo_entry3;
  GtkWidget *combo_entry11;
  GtkTooltips *tooltips;
  GtkWidget *scrolledwindow6;
  GtkWidget *viewport1;
  GtkWidget *frame2;
  GtkWidget *vbox23c;
  GSList *source_group = NULL;
  GList *combo_title_items = NULL;
  GtkWidget *label10;
  GtkWidget *hbox6b;
  GtkWidget *label10b;
  GtkWidget *combo_audio_codec;
  GList *combo_audio_codec_items = NULL;
  GtkWidget *combo_entry11b;
  GtkWidget *combo_codec;
  GList *combo_codec_items = NULL;
  GString *title_nr = g_string_new("1234");
  GString *text_add = g_string_new("");
  GString *text = g_string_new("");
  GString *time = g_string_new("");
  GString *format = g_string_new("");
/* list widgets */
  GtkWidget *clist1;
  GtkWidget *label_select_titel;
  GtkWidget *label_select_playback;
  GtkWidget *label_select_frames;
  GtkWidget *label_select_aspect;
  GtkWidget *label_select_FPS;
  GtkWidget *label_select_selected;
  GtkWidget *label_divx_filename;
  GtkWidget *hbox15;
  GtkWidget *vbox41;
  GtkWidget *hbox3; 
  GtkWidget *label_divx_width;
  GtkObject *spinbutton_width_adj;
  GtkWidget *spinbutton_width;
  GtkWidget *label_divx_height;
  GtkObject *spinbutton_height_adj;
  GtkWidget *spinbutton_height;

  gint i;
  tooltips = gtk_tooltips_new ();

  drip_druid = gnome_druid_new ();
  window1 = drip_druid;
  gtk_widget_ref (drip_druid);
  gtk_object_set_data_full (GTK_OBJECT (window1), "drip_druid", drip_druid,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (drip_druid);
  gtk_box_pack_start (GTK_BOX (hbox_main), drip_druid, FALSE, FALSE, 0);


  /* PAGE 1 */
  druidpagestart1 = gnome_druid_page_start_new ();
  gtk_widget_ref (druidpagestart1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druidpagestart1", druidpagestart1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druidpagestart1);
  gnome_druid_append_page (GNOME_DRUID (drip_druid), GNOME_DRUID_PAGE (druidpagestart1));
  gnome_druid_set_page (GNOME_DRUID (drip_druid), GNOME_DRUID_PAGE (druidpagestart1));
  gnome_druid_page_start_set_bg_color (GNOME_DRUID_PAGE_START (druidpagestart1), &druidpagestart1_bg_color);
  gnome_druid_page_start_set_textbox_color (GNOME_DRUID_PAGE_START (druidpagestart1), &druidpagestart1_textbox_color);
  gnome_druid_page_start_set_title_color (GNOME_DRUID_PAGE_START (druidpagestart1), &druidpagestart1_title_color);
  gnome_druid_page_start_set_title (GNOME_DRUID_PAGE_START (druidpagestart1), _("New Backup"));
  gnome_druid_page_start_set_text (GNOME_DRUID_PAGE_START (druidpagestart1), _("Starting a new DVD backup..."));
  gnome_druid_page_start_set_logo (GNOME_DRUID_PAGE_START (druidpagestart1),create_image ("gnome-die1.png"));

  /* PAGE 2 : Content source */
  druidpagestandard1 = gnome_druid_page_standard_new_with_vals ("DVD Content", NULL);
  gtk_widget_ref (druidpagestandard1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druidpagestandard1", druidpagestandard1,(GtkDestroyNotify) gtk_widget_unref);
  gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard1), &druidpagestart1_bg_color);
  gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard1), &druidpagestart1_title_color);
  gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (druidpagestandard1),create_image ("gnome-die2.png"));
  gtk_widget_show_all (druidpagestandard1);
  gnome_druid_append_page (GNOME_DRUID (drip_druid), GNOME_DRUID_PAGE (druidpagestandard1));

  druid_vbox1 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard1)->vbox;
  gtk_widget_ref (druid_vbox1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druid_vbox1", druid_vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druid_vbox1);

  frame5 = gtk_frame_new (NULL);
  gtk_widget_ref (frame5);
  gtk_object_set_data_full (GTK_OBJECT (window1), "frame5", frame5,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame5);
  gtk_container_add (GTK_CONTAINER (druid_vbox1), frame5);
  gtk_container_set_border_width (GTK_CONTAINER (frame5), 5);

  vbox11 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox11);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox11", vbox11,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox11);
  gtk_container_add (GTK_CONTAINER (frame5),vbox11);
  gtk_container_set_border_width (GTK_CONTAINER(vbox11), 5);

  hbox18 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox18);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox18", hbox18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox18);
  gtk_box_pack_start (GTK_BOX (vbox11), hbox18, FALSE, FALSE, 5);

  radiobutton1 = gtk_radio_button_new_with_label (source_group, _("Use DVDrom device  "));
  source_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton1));
  gtk_widget_ref (radiobutton1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton1", radiobutton1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton1);
  gtk_box_pack_start (GTK_BOX (hbox18), radiobutton1, FALSE, FALSE, 0);
  gtk_widget_set_usize (radiobutton1, -2, 24);
  gtk_tooltips_set_tip (tooltips, radiobutton1, _("Use the DVDrom device as the source location"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton1), Config.useDVDdevice);

  fileentry3dvddevice = gnome_file_entry_new (NULL, NULL);
  gtk_widget_ref (fileentry3dvddevice);
  gtk_object_set_data_full (GTK_OBJECT (window1), "fileentry3dvddevice", fileentry3dvddevice,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry3dvddevice);
  gtk_box_pack_start (GTK_BOX (hbox18), fileentry3dvddevice, TRUE, TRUE, 0);

  combo2 = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry3dvddevice));
  gtk_widget_ref (combo2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry_cache_location", combo2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text (GTK_ENTRY (combo2), Config.DVDdevice->str);
  gtk_tooltips_set_tip (tooltips,  combo2 , _("Use the DVDrom device as the source location"), NULL);
  gtk_widget_show (combo2);

  checkbutton_eject = gtk_check_button_new_with_label (_("Eject DVD"));
  gtk_widget_ref (checkbutton_eject);
  gtk_object_set_data_full (GTK_OBJECT (window1), "checkbutton_eject", checkbutton_eject,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_eject);
  gtk_box_pack_start (GTK_BOX (vbox11), checkbutton_eject, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_eject, _("Eject DVDrom when the disc is no longer needed"),NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_eject), Config.eject_dvdrom);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox11), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, -1, 30);

  hbox19 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox19);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox19", hbox19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox19);
  gtk_box_pack_start (GTK_BOX (vbox11), hbox19, FALSE, FALSE, 5);

  radiobutton2 = gtk_radio_button_new_with_label (source_group, _("Use Drip Cache  "));
  source_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton2));
  gtk_widget_ref (radiobutton2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton2", radiobutton2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton2);
  gtk_box_pack_start (GTK_BOX (hbox19), radiobutton2, FALSE, FALSE, 0);
  gtk_widget_set_usize (radiobutton2, -2, 24);
  gtk_tooltips_set_tip (tooltips, radiobutton2, _("Use a specific location for source streams. In the specified location Drip expects cached content from a previous backup run. Using cache as input allowes to try out encoding settings without having to read from DVD disc anytime."), NULL);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton2), !Config.useDVDdevice);

  fileentry3location = gnome_file_entry_new (NULL, NULL);
  gtk_widget_ref (fileentry3location);
  gtk_object_set_data_full (GTK_OBJECT (window1), "fileentry3location", fileentry3location,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry3location);
  gtk_box_pack_start (GTK_BOX (hbox19), fileentry3location, TRUE, TRUE, 0);

  combo3 = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry3location));
  gtk_widget_ref (combo3);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo3", combo3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text (GTK_ENTRY (combo3), Config.DVDsource->str);
  gtk_tooltips_set_tip (tooltips,  combo3 , _("Use a specific location for source streams"), NULL);
  gtk_widget_show (combo3);

  /* PAGE 3 : Titles */
  druidpagestandard2 = gnome_druid_page_standard_new_with_vals ("DVD Title", NULL);
  gtk_widget_ref (druidpagestandard2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druidpagestandard2", druidpagestandard2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard2), &druidpagestart1_bg_color);
  gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard2), &druidpagestart1_title_color);
  gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (druidpagestandard2),create_image ("gnome-die3.png"));
  gtk_widget_show_all (druidpagestandard2);
  gnome_druid_append_page (GNOME_DRUID (drip_druid), GNOME_DRUID_PAGE (druidpagestandard2));

  druid_vbox2 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard2)->vbox;
  gtk_widget_ref (druid_vbox2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druid_vbox2", druid_vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druid_vbox2);

  frame5 = gtk_frame_new (NULL);
  gtk_widget_ref (frame5);
  gtk_object_set_data_full (GTK_OBJECT (window1), "frame5", frame5,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame5);
  gtk_container_add (GTK_CONTAINER (druid_vbox2), frame5);
  gtk_container_set_border_width (GTK_CONTAINER (frame5), 5);

  vbox23 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox23);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox23", vbox23,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox23);
  gtk_container_add (GTK_CONTAINER (frame5), vbox23);
  gtk_container_set_border_width (GTK_CONTAINER (vbox23), 5);

  /* Build list of titles */
  for (i=0;i<Config.DVD_Total_ChapterSequences;i++) {
      seconds2time((gint)(Config.frames2encode[i]/Config.framerate),time);
      g_string_sprintf(text_add,"Title %i: %s, %i frames %.2g:1 %gFPS\n",i+1,time->str,Config.frames2encode[i],Config.VTS_Aspects[Config.VT_belongs_to_VTS[i]+1],Config.framerate);
      g_string_append(text,text_add->str);
  }

  scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow6);
  gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow6", scrolledwindow6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow6);
  gtk_box_pack_start (GTK_BOX (vbox23), scrolledwindow6, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "viewport1", viewport1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow6), viewport1);

  clist1 = gtk_clist_new (6);
  gtk_widget_ref (clist1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "clist1", clist1,(GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (viewport1), clist1);
  gtk_widget_show (clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 100);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 100);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 2, 100);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 3, 100);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 4, 100);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));

  label_select_titel = gtk_label_new (_("DVD Title"));
  gtk_widget_ref (label_select_titel);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_titel", label_select_titel,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_titel);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label_select_titel);

  label_select_playback = gtk_label_new (_("Playback"));
  gtk_widget_ref (label_select_playback);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_playback", label_select_playback,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_playback);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label_select_playback);

  label_select_frames = gtk_label_new (_("Frames"));
  gtk_widget_ref (label_select_frames);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_frames", label_select_frames,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_frames);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 2, label_select_frames);

  label_select_aspect = gtk_label_new (_("Aspect"));
  gtk_widget_ref (label_select_aspect);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_aspect", label_select_aspect,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_aspect);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 3, label_select_aspect);

  label_select_FPS = gtk_label_new (_("FPS"));
  gtk_widget_ref (label_select_FPS);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_FPS", label_select_FPS,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_FPS);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 4, label_select_FPS);

  label_select_selected = gtk_label_new (_("Selected"));
  gtk_widget_ref (label_select_selected);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_selected", label_select_selected,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_selected);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 5, label_select_selected);


  hbox23 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox23);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox23", hbox23,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox23);
  gtk_box_pack_start (GTK_BOX (vbox23), hbox23, FALSE, FALSE, 5);

  label7 = gtk_label_new (_(" DVD Title   "));
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox23), label7, TRUE, TRUE, 0);

  combo_title = gtk_combo_new ();
  gtk_widget_ref (combo_title);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_title", combo_title,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_title);
  gtk_box_pack_start (GTK_BOX (hbox23), combo_title, TRUE, TRUE, 20);
  for (i=0;i<Config.DVD_Total_ChapterSequences;i++) {
      title_nr = g_string_new(""); //memleaking.. 
      g_string_sprintf(title_nr,"%i",i+1);
      combo_title_items = g_list_append (combo_title_items, title_nr->str);
  }
  g_list_free (combo_title_items);

  /* PAGE 4 : Audio and subpicture channels */
  druidpagestandard3 = gnome_druid_page_standard_new_with_vals ("Languages  -  Audio & Subpicture", NULL);
  gtk_widget_ref (druidpagestandard3);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druidpagestandard3", druidpagestandard3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard3), &druidpagestart1_bg_color);
  gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard3), &druidpagestart1_title_color);
  gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (druidpagestandard3),create_image ("gnome-die4.png"));
  gtk_widget_show_all (druidpagestandard3);
  gnome_druid_append_page (GNOME_DRUID (drip_druid), GNOME_DRUID_PAGE (druidpagestandard3));

  druid_vbox3 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard3)->vbox;
  gtk_widget_ref (druid_vbox3);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druid_vbox3", druid_vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druid_vbox3);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_container_add (GTK_CONTAINER (druid_vbox3), frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  vbox9b = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox9b);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox9b", vbox9b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9b);
  gtk_container_add (GTK_CONTAINER (frame1), vbox9b);
  gtk_container_set_border_width (GTK_CONTAINER (vbox9b), 3);

  hbox21 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox21);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox21", hbox21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox21);
  gtk_box_pack_start (GTK_BOX (vbox9b), hbox21, TRUE, TRUE, 0);

  label_ripdvd_select_audio_channel = gtk_label_new (_(" Audio channel  "));
  gtk_widget_ref (label_ripdvd_select_audio_channel);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_ripdvd_select_audio_channel", label_ripdvd_select_audio_channel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_ripdvd_select_audio_channel);
  gtk_box_pack_start (GTK_BOX (hbox21), label_ripdvd_select_audio_channel, FALSE, FALSE, 0);

  vbox9 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox9);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox9", vbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9);
  gtk_box_pack_start (GTK_BOX (hbox21), vbox9, TRUE, TRUE, 0);

  label_ripdvd_select_2nd_audio_channel = gtk_label_new (_(" 2nd Audio channel  "));
  gtk_widget_ref (label_ripdvd_select_2nd_audio_channel);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_ripdvd_select_2nd_audio_channel", label_ripdvd_select_2nd_audio_channel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_ripdvd_select_2nd_audio_channel);
  gtk_box_pack_start (GTK_BOX (hbox21), label_ripdvd_select_2nd_audio_channel, FALSE, FALSE, 0);

  vbox9_2nd = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox9_2nd);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox9_2nd", vbox9_2nd,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9_2nd);
  gtk_box_pack_start (GTK_BOX (hbox21), vbox9_2nd, TRUE, TRUE, 0);


  /* PAGE 5 : Output filename */
  druidpagestandard4 = gnome_druid_page_standard_new_with_vals ("Output  -  Codecs, Quality & Dimensions", NULL);
  gtk_widget_ref (druidpagestandard4);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druidpagestandard4", druidpagestandard4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard4), &druidpagestart1_bg_color);
  gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard4), &druidpagestart1_title_color);
  gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (druidpagestandard4),create_image ("gnome-die5.png"));
  gtk_widget_show_all (druidpagestandard4);
  gnome_druid_append_page (GNOME_DRUID (drip_druid), GNOME_DRUID_PAGE (druidpagestandard4));

  druid_vbox4 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard4)->vbox;
  gtk_widget_ref (druid_vbox4);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druid_vbox4", druid_vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druid_vbox4);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_ref (frame2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "frame2", frame2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame2);
  gtk_container_add (GTK_CONTAINER (druid_vbox4), frame2);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

  vbox23c = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox23c);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox23c", vbox23c,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox23c);
  gtk_container_add (GTK_CONTAINER (frame2), vbox23c);
  gtk_container_set_border_width (GTK_CONTAINER (vbox23c), 3);


  hbox15 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox15);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox15", hbox15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox15);
  gtk_box_pack_start (GTK_BOX (vbox23c), hbox15, FALSE, FALSE, 0);

  label_divx_filename = gtk_label_new (_("DIVX Filename "));
  gtk_widget_ref (label_divx_filename);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_divx_filename", label_divx_filename,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_filename);
  gtk_box_pack_start (GTK_BOX (hbox15), label_divx_filename, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_filename), GTK_JUSTIFY_RIGHT);

  fileentry_divx = gnome_file_entry_new (NULL, _("Filename of output Divx"));
  gtk_widget_ref (fileentry_divx);
  gtk_object_set_data_full (GTK_OBJECT (window1), "fileentry_divx", fileentry_divx,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry_divx);
  gtk_box_pack_start (GTK_BOX (hbox15), fileentry_divx, TRUE, TRUE, 0);

  combo_entry_divx_filename = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry_divx));
  gtk_widget_ref (combo_entry_divx_filename);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry_divx_filename", combo_entry_divx_filename,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry_divx_filename);
  gtk_entry_set_text (GTK_ENTRY(combo_entry_divx_filename), Config.DIVXfileUser->str);

  /* Video codec */
  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox23c), hbox6, TRUE, TRUE, 0);

  label10 = gtk_label_new (_("Output Video Codec  "));
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, FALSE, 0);
  combo_codec = gtk_combo_new ();
  gtk_widget_ref (combo_codec);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_codec", combo_codec,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_codec);
  gtk_box_pack_start (GTK_BOX (hbox6), combo_codec, TRUE, TRUE, 0);

  for (i=0;i<Config.codecs_amount;i++) {
      if (Config.codecs[i].cav == VIDEO_CODEC) {
          combo_codec_items = g_list_append (combo_codec_items, (gpointer)Config.codecs[i].cdescription->str);
      }
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_codec), combo_codec_items);
  g_list_free (combo_codec_items);
  combo_entry11 = GTK_COMBO (combo_codec)->entry;
  gtk_widget_ref (combo_entry11);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry11", combo_entry11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_tooltips_set_tip (tooltips, combo_entry11, _("Select encoding video codec. List presented represent the available video codecs supported by avifile"),NULL);
  gtk_widget_show (combo_entry11);
  gtk_entry_set_text (GTK_ENTRY (combo_entry11), Config.codecs[Config.encoding_video_codec].cdescription->str);

  /* Video bitrate */
  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox23c), hbox4, TRUE, TRUE, 0);

  label_divx_video_bitrate = gtk_label_new (_("Video bitrate  "));
  gtk_widget_ref (label_divx_video_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_divx_video_bitrate", label_divx_video_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_video_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox4), label_divx_video_bitrate, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_video_bitrate), GTK_JUSTIFY_RIGHT);

  spinbutton_video_bitrate_adj = gtk_adjustment_new (Config.video_bitrate, 200, 20000, 1, 10, 10);
  spinbutton_video_bitrate = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_video_bitrate_adj), 50, 0);
  gtk_widget_ref (spinbutton_video_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (window1), "spinbutton_video_bitrate", spinbutton_video_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_video_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox4), spinbutton_video_bitrate, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, spinbutton_video_bitrate, _("DIVX encoding bitrate. Start with 600 for low but acceptable, 1000 average and 1400 for high quality."), NULL);


  button_calculate_bitrate = gtk_button_new_with_label (_("Calculate bitrate"));
  gtk_widget_ref (button_calculate_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (window1), "button_calculate_bitrate", button_calculate_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_calculate_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox4), button_calculate_bitrate, FALSE, FALSE, 0);
  GTK_WIDGET_UNSET_FLAGS (button_calculate_bitrate, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (tooltips, button_calculate_bitrate, _("Calculated divx encoding bitrate"), NULL);
  gtk_button_set_relief (GTK_BUTTON (button_calculate_bitrate), GTK_RELIEF_HALF);

  /* Audio codec */
  hbox6b = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6b);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox6b", hbox6b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6b);
  gtk_box_pack_start (GTK_BOX (vbox23c), hbox6b, TRUE, TRUE, 0);

  label10b = gtk_label_new (_("Output Audio Codec  "));
  gtk_widget_ref (label10b);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label10b", label10b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10b);
  gtk_box_pack_start (GTK_BOX (hbox6b), label10b, FALSE, FALSE, 0);
  combo_audio_codec = gtk_combo_new ();
  gtk_widget_ref (combo_audio_codec);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_audio_codec", combo_audio_codec,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_audio_codec);
  gtk_box_pack_start (GTK_BOX (hbox6b), combo_audio_codec, TRUE, TRUE, 0);

  for (i=0;i<Config.codecs_amount;i++) {
      if (Config.codecs[i].cav == AUDIO_CODEC) {
          combo_audio_codec_items = g_list_append (combo_audio_codec_items, (gpointer)Config.codecs[i].cdescription->str);
      }
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_audio_codec), combo_audio_codec_items);
  g_list_free (combo_audio_codec_items);
  combo_entry11b = GTK_COMBO (combo_audio_codec)->entry;
  gtk_widget_ref (combo_entry11b);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry11b", combo_entry11b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_tooltips_set_tip (tooltips, combo_entry11b, _("Select encoding audio codec. List presented represent the available audio codecs supported by avifile"),NULL);
  gtk_widget_show (combo_entry11b);
  gtk_entry_set_text (GTK_ENTRY(combo_entry11b), Config.codecs[Config.encoding_audio_codec].cdescription->str);

  /* Audio bitrate */
  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox23c), hbox5, TRUE, TRUE, 0);

  label_divx_audio_bitrate = gtk_label_new (_("Audio bitrate  "));
  gtk_widget_ref (label_divx_audio_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_divx_audio_bitrate", label_divx_audio_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_audio_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox5), label_divx_audio_bitrate, FALSE, FALSE, 0);
  combo_audio_bitrate = gtk_combo_new ();
  gtk_widget_ref (combo_audio_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_audio_bitrate", combo_audio_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_audio_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox5), combo_audio_bitrate, TRUE, TRUE, 0);
  if (Config.two_audio_channels_support==FALSE) {
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("auto"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("32"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("40"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("48"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("56"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("64"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("80"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("96"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("112"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("128"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("160"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("192"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("224"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("256"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("320"));
  } else {
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("128"));
  }

  gtk_combo_set_popdown_strings (GTK_COMBO (combo_audio_bitrate), combo_audio_bitrate_items);
  g_list_free (combo_audio_bitrate_items);

  combo_entry3 = GTK_COMBO (combo_audio_bitrate)->entry;
  gtk_widget_ref (combo_entry3);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry3", combo_entry3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry3);
  if (Config.audio_bitrate>-1) {
      g_string_sprintf(format,"%i",Config.audio_bitrate);
  } else {
      g_string_sprintf(format,"auto");
  }
  gtk_entry_set_text (GTK_ENTRY (combo_entry3), format->str);
  gtk_tooltips_set_tip (tooltips, combo_entry3, _("Audio MP3 bitrate (kBit). LEAVE SET TO 'auto', else the result might have it's audio out of sync with the video."), NULL);

  /* Dimensions */
  vbox41 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox41);
  gtk_object_set_data_full(GTK_OBJECT(window1), "vbox41", vbox41,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox41);
  gtk_box_pack_start(GTK_BOX(vbox23c), vbox41, TRUE, TRUE, 0);
  gtk_container_set_border_width(GTK_CONTAINER (vbox41), 9);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox41), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, -1, 30);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full(GTK_OBJECT(window1), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start(GTK_BOX(vbox41), hbox3, TRUE, TRUE, 0);

  label_divx_width = gtk_label_new (_("Width   "));
  gtk_widget_ref (label_divx_width);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_divx_width", label_divx_width,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_width);
  gtk_box_pack_start (GTK_BOX (hbox3), label_divx_width, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_width), GTK_JUSTIFY_RIGHT);

 
  spinbutton_width_adj = gtk_adjustment_new (Config.set_width, -1, 10000, 1, 10, 10);
  spinbutton_width = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_width_adj), 1, 0);
  gtk_widget_ref (spinbutton_width);
  gtk_object_set_data_full (GTK_OBJECT (window1), "spinbutton_width", spinbutton_width,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_width);
  gtk_box_pack_start (GTK_BOX (hbox3), spinbutton_width, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, spinbutton_width, _("Output width (input content width = -1)"), NULL);


  label_divx_height = gtk_label_new (_("       Height   "));
  gtk_widget_ref (label_divx_height);
  gtk_object_set_data_full (GTK_OBJECT(window1), "label_divx_height", label_divx_height,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_height);
  gtk_box_pack_start (GTK_BOX (hbox3), label_divx_height, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_height), GTK_JUSTIFY_RIGHT);

  spinbutton_height_adj = gtk_adjustment_new(Config.set_height, -1, 10000, 1, 10, 10);
  spinbutton_height = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_height_adj), 1, 0);
  gtk_widget_ref (spinbutton_height);
  gtk_object_set_data_full (GTK_OBJECT (window1), "spinbutton_height", spinbutton_height,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_height);
  gtk_box_pack_start (GTK_BOX (hbox3), spinbutton_height, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, spinbutton_height, _("Output height (relative to width = -1)"), NULL);


  /* PAGE 6 */
  druidpagefinish1 = gnome_druid_page_finish_new_with_vals("Ready to go","Click Finish to begin backup procedure.",NULL,NULL);

  gtk_widget_ref (druidpagefinish1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "druidpagefinish1", druidpagefinish1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gnome_druid_page_finish_set_bg_color (GNOME_DRUID_PAGE_FINISH (druidpagefinish1), &druidpagestart1_bg_color);
  gnome_druid_page_finish_set_title_color (GNOME_DRUID_PAGE_FINISH (druidpagefinish1), &druidpagestart1_title_color);
  gnome_druid_page_finish_set_logo (GNOME_DRUID_PAGE_FINISH (druidpagefinish1),create_image ("gnome-die6.png"));
  gtk_widget_show (druidpagefinish1);
  gnome_druid_append_page (GNOME_DRUID (drip_druid), GNOME_DRUID_PAGE (druidpagefinish1));


  /* Callbacks */
  gtk_signal_connect (GTK_OBJECT (spinbutton_width), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_width_changed),
                      spinbutton_width);
  gtk_signal_connect (GTK_OBJECT (spinbutton_height), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_heigth_changed),
                      spinbutton_height);
  gtk_signal_connect (GTK_OBJECT (checkbutton_eject), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_eject_toggled),
                      checkbutton_eject);
  gtk_signal_connect (GTK_OBJECT (combo2), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry_dvddevice_changed),
                      combo2);
  gtk_signal_connect (GTK_OBJECT (combo3), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry_dvdsource_changed),
                      combo3);
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "toggled",
                      GTK_SIGNAL_FUNC (on_radiobutton_useDVDdevice_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "toggled",
                      GTK_SIGNAL_FUNC (on_radiobutton_useDVDsource_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spinbutton_video_bitrate), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_video_bitrate_changed),
                      spinbutton_video_bitrate);
  gtk_signal_connect (GTK_OBJECT (button_calculate_bitrate), "clicked",
                      GTK_SIGNAL_FUNC (on_button_calculate_bitrate_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO(combo_audio_bitrate)->entry), "changed",
                      GTK_SIGNAL_FUNC (on_combo_audio_bitrate_changed),
                      GTK_COMBO(combo_audio_bitrate)->entry);
  gtk_signal_connect (GTK_OBJECT (combo_entry_divx_filename), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry2_changed),
                      combo_entry_divx_filename);
  gtk_signal_connect (GTK_OBJECT (combo_entry11), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry11_changed),
                      combo_entry11);
  gtk_signal_connect (GTK_OBJECT (combo_entry11b), "changed",
                      GTK_SIGNAL_FUNC (on_combo_audiocodec_changed),
                      combo_entry11b);
  gtk_signal_connect (GTK_OBJECT (drip_druid), "cancel",
                      GTK_SIGNAL_FUNC (on_drip_druid_cancel),
                      NULL);
  bind_titles_guitype();
  gtk_signal_connect (GTK_OBJECT (druidpagefinish1), "finish",
                      GTK_SIGNAL_FUNC (on_drip_druidpagefinish1_finish),
                      NULL);

  return window1;
}

GtkWidget*
create_propertybox1 (void)
{
  GtkWidget *propertybox1;
  GtkWidget *notebook1;
  GtkWidget *labelprop1;
  GtkWidget *vbox4;
  GtkWidget *vbox41;
  GtkWidget *vbox42;
  GtkWidget *vbox43;
  GtkWidget *vbox44;
  GtkWidget *vbox45;
  GtkWidget *vbox46;
  GtkWidget *fileentry_divx;
  GtkWidget *combo_entry2;
  GtkWidget *combo_audio_prefA;
  GtkWidget *combo_spu_prefA;
  GtkWidget *combo_entry_audio_prefA;
  GtkWidget *combo_entry_spu_prefA;
  GtkWidget *combo_audio_prefB;
  GtkWidget *combo_spu_prefB;
  GtkWidget *combo_entry_audio_prefB;
  GtkWidget *combo_entry_spu_prefB;

  GtkWidget *hbox3;
  GtkWidget *label_divx_width;
  GtkObject *spinbutton_width_adj;
  GtkWidget *spinbutton_width;
  GtkWidget *label_divx_height;
  GtkObject *spinbutton_height_adj;
  GtkWidget *spinbutton_height;
  GtkWidget *hbox4;
  GtkWidget *label_divx_video_bitrate;
  GtkObject *spinbutton_video_bitrate_adj;
  GtkWidget *spinbutton_video_bitrate;
  GtkWidget *button_calculate_bitrate;
  GtkWidget *hbox5;
  GtkWidget *label_divx_audio_bitrate;
  GtkWidget *combo_audio_bitrate;
  GList *combo_audio_bitrate_items = NULL;
  GList *combo_audio_prefA_items = NULL;
  GList *combo_audio_prefB_items = NULL;
  GList *combo_spu_prefA_items = NULL;
  GList *combo_spu_prefB_items = NULL;
  GtkWidget *combo_entry3;
  GtkWidget *checkbutton_dvddb;
  GtkWidget *hbox6;
  GtkWidget *hbox7;
  GtkWidget *label_divx_linesclip;
  GtkObject *spinbutton_clip_adj;
  GtkWidget *spinbutton_clip;
  GtkWidget *hbox7r;
  GtkWidget *label_divx_linesclip_right;
  GtkObject *spinbutton_clip_adj_right;
  GtkWidget *spinbutton_clip_right;
  GtkWidget *hbox7l;
  GtkWidget *label_divx_linesclip_left;
  GtkObject *spinbutton_clip_adj_left;
  GtkWidget *spinbutton_clip_left;
  GtkWidget *hbox8;
  GtkWidget *label_divx_offsetclip;
  GtkObject *spinbutton_clip_offset_adj;
  GtkWidget *spinbutton_clip_offset;
  GtkWidget *hbox9;
  GtkWidget *label_divx_blurradius;
  GtkObject *spinbutton_blur_adj;
  GtkWidget *checkbutton_autoclip;
  GtkObject *spinbutton_nice_adj;
  GtkWidget *spinbutton_nice;
  GtkWidget *hbox17;
  GtkWidget *label_divx_framesclip;
  GtkObject *spinbutton_clip_frames_adj;
  GtkWidget *spinbutton_clip_frames;
  GtkWidget *scrolledwindow;
  GtkWidget *viewport;
  GtkWidget *maxsizeoutput;
  GtkObject *spinbutton_maxsizeoutput_adj;
  GtkWidget *hseparator2;
  GtkWidget *spinbutton_maxsizeoutput;
  GtkWidget *spinbutton_blur;
  GtkWidget *labelprop2;
  GtkWidget *vbox3;
  GtkWidget *checkbutton_eject;
  GtkWidget *checkbutton_deinterlace;
  GtkWidget *checkbutton_pulldown;
  GtkWidget *hbox2;
  GtkWidget *hbox15;
  GtkWidget *label_nice;
  GtkWidget *label10;
  GtkWidget *checkbutton_encode;
  GtkWidget *vbox8;
  GtkWidget *hbox18;
  GtkWidget *radiobutton1;
  GtkWidget *combo2;
  GtkWidget *fileentry3dvddevice;
  GtkWidget *hbox19;
  GtkWidget *hbox20;
  GtkWidget *hbox21;
  GtkWidget *label_cpus;
  GtkWidget *combo_codec;
  GtkWidget *combo_entry11;
  GList *combo_codec_items = NULL;
  GtkObject *spinbutton_cpus_adj;
  GtkWidget *spinbutton_cpus;
  GtkWidget *radiobutton2;
  GtkWidget *cache_location_label;
  GtkWidget *fileentry3;
  GtkWidget *combo_filter;
  GList *combo_filter_items = NULL;
  GtkWidget *combo_entry_cache_location;
  GtkWidget *combo3;
  GtkWidget *fileentry3location;
  GtkWidget *checkbutton_delete_cache;
  GtkWidget *checkbutton_chunk_cache;
  GtkWidget *checkbutton_iso;
  GtkWidget *checkbutton_debug;
  GtkWidget *plugin_frame;
  GtkWidget *hbox6b;
  GtkWidget *hbox10;
  GtkWidget *checkbutton_audionorm;
  GtkWidget *label10b;
  GtkWidget *label11;
  GtkWidget *button20;
  GtkWidget *combo_audio_codec;
  GtkWidget *hbox22;
  GList *combo_audio_codec_items = NULL;
  GtkWidget *combo_entry11b;
  GSList *source_group = NULL;
  GtkTooltips *tooltips;
  GString *format = g_string_new("");
  gint i;

  tooltips = gtk_tooltips_new ();

  propertybox1 = gnome_property_box_new ();
  gtk_object_set_data (GTK_OBJECT (propertybox1), "propertybox1", propertybox1);
  gtk_window_set_default_size (GTK_WINDOW (propertybox1), 667, 500);
  gtk_window_set_policy (GTK_WINDOW (propertybox1), FALSE, TRUE, TRUE);
  gtk_window_set_title (GTK_WINDOW (propertybox1), _("Drip - Preferences"));
  gtk_widget_show (propertybox1);

  notebook1 = GNOME_PROPERTY_BOX (propertybox1)->notebook;
  gtk_object_set_data (GTK_OBJECT (propertybox1), "notebook1", notebook1);
  gtk_widget_show (notebook1);
  gtk_container_set_border_width (GTK_CONTAINER (notebook1), 9);

  // --- Source tab ---
  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox8);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox8", vbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox8);
  gtk_container_set_border_width (GTK_CONTAINER (vbox8), 9);

  hbox18 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox18);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox18", hbox18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox18);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox18, FALSE, FALSE, 5);

  radiobutton1 = gtk_radio_button_new_with_label (source_group, _("Use DVDrom device  "));
  source_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton1));
  gtk_widget_ref (radiobutton1);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "radiobutton1", radiobutton1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton1);
  gtk_box_pack_start (GTK_BOX (hbox18), radiobutton1, FALSE, FALSE, 0);
  gtk_widget_set_usize (radiobutton1, -2, 24);
  gtk_tooltips_set_tip (tooltips, radiobutton1, _("Use the DVDrom device as the source location"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton1), Config.useDVDdevice);

  fileentry3dvddevice = gnome_file_entry_new (NULL, NULL);
  gtk_widget_ref (fileentry3dvddevice);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "fileentry3dvddevice", fileentry3dvddevice,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry3dvddevice);
  gtk_box_pack_start (GTK_BOX (hbox18), fileentry3dvddevice, TRUE, TRUE, 0);

  combo2 = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry3dvddevice));
  gtk_widget_ref (combo2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry_cache_location", combo2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text (GTK_ENTRY (combo2), Config.DVDdevice->str);
  gtk_tooltips_set_tip (tooltips,  combo2 , _("Use the DVDrom device as the source location"), NULL);
  gtk_widget_show (combo2);

  checkbutton_eject = gtk_check_button_new_with_label (_("Eject DVD"));
  gtk_widget_ref (checkbutton_eject);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_eject", checkbutton_eject,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_eject);
  gtk_box_pack_start (GTK_BOX (vbox8), checkbutton_eject, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_eject, _("Eject DVDrom when the disc is no longer needed"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_eject), Config.eject_dvdrom);


  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox8), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, -1, 30);

  hbox19 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox19);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox19", hbox19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox19);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox19, FALSE, FALSE, 5);

  radiobutton2 = gtk_radio_button_new_with_label (source_group, _("Use Drip Cache  "));
  source_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton2));
  gtk_widget_ref (radiobutton2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "radiobutton2", radiobutton2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton2);
  gtk_box_pack_start (GTK_BOX (hbox19), radiobutton2, FALSE, FALSE, 0);
  gtk_widget_set_usize (radiobutton2, -2, 24);
  gtk_tooltips_set_tip (tooltips, radiobutton2, _("Use a specific location for source streams"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton2), !Config.useDVDdevice);
  
  fileentry3location = gnome_file_entry_new (NULL, NULL);
  gtk_widget_ref (fileentry3location);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "fileentry3location", fileentry3location,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry3location);
  gtk_box_pack_start (GTK_BOX (hbox19), fileentry3location, TRUE, TRUE, 0);

  combo3 = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry3location));
  gtk_widget_ref (combo3);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo3", combo3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text (GTK_ENTRY (combo3), Config.DVDsource->str);
  gtk_tooltips_set_tip (tooltips,  combo3 , _("Use a specific location for source streams"), NULL);
  gtk_widget_show (combo3);

  labelprop1 = gtk_label_new (_("Source"));
  gtk_widget_ref (labelprop1);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop1", labelprop1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), labelprop1);

  // --- DIVX tab ---
  vbox4 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox4);
  gtk_container_set_border_width (GTK_CONTAINER (vbox4), 9);

  hbox15 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox15);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox15", hbox15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox15);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox15, FALSE, FALSE, 0);

  label_divx_video_bitrate = gtk_label_new (_("DIVX Filename "));
  gtk_widget_ref (label_divx_video_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_video_bitrate", label_divx_video_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_video_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox15), label_divx_video_bitrate, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_video_bitrate), GTK_JUSTIFY_RIGHT);

  fileentry_divx = gnome_file_entry_new (NULL, _("Filename of output Divx"));
  gtk_widget_ref (fileentry_divx);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "fileentry_divx", fileentry_divx,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry_divx);
  gtk_box_pack_start (GTK_BOX (hbox15), fileentry_divx, FALSE, FALSE, 0);

  combo_entry2 = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry_divx));
  gtk_widget_ref (combo_entry2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry2", combo_entry2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry2);
  gtk_tooltips_set_tip (tooltips, combo_entry2, _("Filename of encoded Divx"), NULL);
  gtk_entry_set_text (GTK_ENTRY (combo_entry2), Config.DIVXfileUser->str);

  checkbutton_dvddb = gtk_check_button_new_with_label (_("Use DVDdb"));
  gtk_widget_ref (checkbutton_dvddb);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_dvddb", checkbutton_dvddb,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_dvddb);
  gtk_box_pack_start (GTK_BOX (hbox15), checkbutton_dvddb, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_dvddb, _("Use DVDdb for naming output Divx file. If the DVDdb doesn't know the dvd title, the user supplied name is used"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_dvddb), Config.use_dvddb);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox4, TRUE, FALSE, 0);

  label_divx_video_bitrate = gtk_label_new (_("Video bitrate  "));
  gtk_widget_ref (label_divx_video_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_video_bitrate", label_divx_video_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_video_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox4), label_divx_video_bitrate, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_video_bitrate), GTK_JUSTIFY_RIGHT);

  spinbutton_video_bitrate_adj = gtk_adjustment_new (Config.video_bitrate, 200, 20000, 1, 10, 10);
  spinbutton_video_bitrate = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_video_bitrate_adj), 50, 0);
  gtk_widget_ref (spinbutton_video_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_video_bitrate", spinbutton_video_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_video_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox4), spinbutton_video_bitrate, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, spinbutton_video_bitrate, _("DIVX encoding bitrate"), NULL);

  button_calculate_bitrate = gtk_button_new_with_label (_("Calculate bitrate"));
  gtk_widget_ref (button_calculate_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "button_calculate_bitrate", button_calculate_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_calculate_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox4), button_calculate_bitrate, FALSE, FALSE, 0);
  GTK_WIDGET_UNSET_FLAGS (button_calculate_bitrate, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (tooltips, button_calculate_bitrate, _("Calculated divx encoding bitrate"), NULL);
  gtk_button_set_relief (GTK_BUTTON (button_calculate_bitrate), GTK_RELIEF_HALF);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox5, TRUE, TRUE, 0);

  label_divx_audio_bitrate = gtk_label_new (_("Audio bitrate  "));
  gtk_widget_ref (label_divx_audio_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_audio_bitrate", label_divx_audio_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_audio_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox5), label_divx_audio_bitrate, FALSE, FALSE, 0);

  combo_audio_bitrate = gtk_combo_new ();
  gtk_widget_ref (combo_audio_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_audio_bitrate", combo_audio_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_audio_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox5), combo_audio_bitrate, TRUE, TRUE, 0);
  if (Config.two_audio_channels_support==FALSE) {
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("auto"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("32"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("40"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("48"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("56"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("64"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("80"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("96"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("112"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("128"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("160"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("192"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("224"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("256"));
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("320"));
  } else {
      combo_audio_bitrate_items = g_list_append (combo_audio_bitrate_items, (gpointer)_("128"));
  }

  gtk_combo_set_popdown_strings (GTK_COMBO (combo_audio_bitrate), combo_audio_bitrate_items);
  g_list_free (combo_audio_bitrate_items);

  combo_entry3 = GTK_COMBO (combo_audio_bitrate)->entry;
  gtk_widget_ref (combo_entry3);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry3", combo_entry3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry3);
  if (Config.audio_bitrate>-1) {
      g_string_sprintf(format,"%i",Config.audio_bitrate);
  } else {
      g_string_sprintf(format,"auto");
  }
  gtk_entry_set_text (GTK_ENTRY (combo_entry3), format->str);
  gtk_tooltips_set_tip (tooltips, combo_entry3, _("Audio MP3 bitrate (kBit)"), NULL);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox6, TRUE, TRUE, 0);

  label10 = gtk_label_new (_("Output Video Codec  "));
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, FALSE, 0);

  combo_codec = gtk_combo_new ();
  gtk_widget_ref (combo_codec);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_codec", combo_codec,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_codec);
  gtk_box_pack_start (GTK_BOX (hbox6), combo_codec, TRUE, TRUE, 0);
  for (i=0;i<Config.codecs_amount;i++) {
      if (Config.codecs[i].cav == VIDEO_CODEC) {
          combo_codec_items = g_list_append (combo_codec_items, (gpointer)Config.codecs[i].cdescription->str);
      }
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_codec), combo_codec_items);
  g_list_free (combo_codec_items);

  combo_entry11 = GTK_COMBO (combo_codec)->entry;
  gtk_widget_ref (combo_entry11);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry11", combo_entry11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry11);
  gtk_entry_set_text (GTK_ENTRY (combo_entry11), Config.codecs[Config.encoding_video_codec].cdescription->str);

  /* Audio codec */
  hbox6b = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox6b", hbox6b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6b);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox6b, TRUE, TRUE, 0);

  label10b = gtk_label_new (_("Output Audio Codec  "));
  gtk_widget_ref (label10b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label10b", label10b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10b);
  gtk_box_pack_start (GTK_BOX (hbox6b), label10b, FALSE, FALSE, 0);
  combo_audio_codec = gtk_combo_new ();
  gtk_widget_ref (combo_audio_codec);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_audio_codec", combo_audio_codec,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_audio_codec);
  gtk_box_pack_start (GTK_BOX (hbox6b), combo_audio_codec, TRUE, TRUE, 0);

  for (i=0;i<Config.codecs_amount;i++) {
      if (Config.codecs[i].cav == AUDIO_CODEC) {
          combo_audio_codec_items = g_list_append (combo_audio_codec_items, (gpointer)Config.codecs[i].cdescription->str);
      }
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_audio_codec), combo_audio_codec_items);
  g_list_free (combo_audio_codec_items);
  combo_entry11b = GTK_COMBO (combo_audio_codec)->entry;
  gtk_widget_ref (combo_entry11b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry11b", combo_entry11b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry11b);
  gtk_entry_set_text (GTK_ENTRY (combo_entry11b), Config.codecs[Config.encoding_audio_codec].cdescription->str);

  labelprop2 = gtk_label_new (_("Codecs"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                             (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), labelprop2);

//   --- Audio normalisation tab ---
  vbox46 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox46);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox46", vbox46,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox46);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox46);
  gtk_container_set_border_width (GTK_CONTAINER (vbox46), 2);

  hbox10 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox10);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox10", hbox10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox10);
  gtk_box_pack_start (GTK_BOX (vbox46), hbox10, FALSE, FALSE, 0);

  checkbutton_audionorm = gtk_check_button_new_with_label (_("Audio Volume normalisation"));
  gtk_widget_ref (checkbutton_audionorm);
  gtk_object_set_data_full (GTK_OBJECT(propertybox1), "checkbutton_audionorm",checkbutton_audionorm,(GtkDestroyNotify) gtk_widget_unref);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_audionorm), Config.audio_norm);
  gtk_widget_show (checkbutton_audionorm);
  gtk_box_pack_start (GTK_BOX (hbox10), checkbutton_audionorm, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_audionorm, _("DVD audio is multiplied by this value while encoding to DIVX"), NULL);

  labelprop2 = gtk_label_new (_("Volume"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                             (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), labelprop2);
  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2));

  // --- Dimensions tab ---
  vbox41 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox41);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox41", vbox41,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox41);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox41);
  gtk_container_set_border_width (GTK_CONTAINER (vbox41), 9);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox41), hbox3, TRUE, TRUE, 0);

  label_divx_width = gtk_label_new (_("   Width    "));
  gtk_widget_ref (label_divx_width);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_width", label_divx_width,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_width);
  gtk_box_pack_start (GTK_BOX (hbox3), label_divx_width, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_width), GTK_JUSTIFY_RIGHT);

  
  spinbutton_width_adj = gtk_adjustment_new (Config.set_width, -1, 10000, 1, 10, 10);
  spinbutton_width = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_width_adj), 1, 0);
  gtk_widget_ref (spinbutton_width);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_width", spinbutton_width,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_width);
  gtk_box_pack_start (GTK_BOX (hbox3), spinbutton_width, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, spinbutton_width, _("Output width (input content width = -1)"), NULL);


  label_divx_height = gtk_label_new (_("     Height    "));
  gtk_widget_ref (label_divx_height);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_height", label_divx_height,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_height);
  gtk_box_pack_start (GTK_BOX (hbox3), label_divx_height, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_height), GTK_JUSTIFY_RIGHT);

  spinbutton_height_adj = gtk_adjustment_new (Config.set_height, -1, 10000, 1, 10, 10);
  spinbutton_height = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_height_adj), 1, 0);
  gtk_widget_ref (spinbutton_height);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_height", spinbutton_height,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_height);
  gtk_box_pack_start (GTK_BOX (hbox3), spinbutton_height, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, spinbutton_height, _("Output height (relative to width = -1)"), NULL);

  labelprop2 = gtk_label_new (_("Dimensions"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                        (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 3), labelprop2);


  // --- Language Preferences tab ---
  vbox42 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox42);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox42", vbox42,
                     (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox42);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox42);
  gtk_container_set_border_width (GTK_CONTAINER (vbox42), 9);

  label10b = gtk_label_new (_("\n\n   Prefered languages can be set here, Drip will autoselect these when available   \n\n"));
  gtk_widget_ref (label10b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label10b", label10b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10b);
  gtk_box_pack_start (GTK_BOX (vbox42), label10b, FALSE, FALSE, 0);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox42), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, -1, 30);

  /* Audio language preference */
  hbox6b = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox6b", hbox6b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6b);
  gtk_box_pack_start (GTK_BOX (vbox42), hbox6b, TRUE, TRUE, 0);

  label10b = gtk_label_new (_("  Audio Language Prefered    "));
  gtk_widget_ref (label10b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label10b", label10b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10b);
  gtk_box_pack_start (GTK_BOX (hbox6b), label10b, FALSE, FALSE, 0);
  combo_audio_prefA = gtk_combo_new ();
  gtk_widget_ref (combo_audio_prefA);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_audio_prefA", combo_audio_prefA,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_audio_prefA);
  gtk_box_pack_start (GTK_BOX (hbox6b), combo_audio_prefA, TRUE, TRUE, 0);

  for (i=0;strlen(lang_tbl[i].lang_long)>0;i++) {
      combo_audio_prefA_items = g_list_append (combo_audio_prefA_items, (gpointer)lang_tbl[i].lang_long);
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_audio_prefA), combo_audio_prefA_items);
  g_list_free (combo_audio_prefA_items);
  combo_entry_audio_prefA = GTK_COMBO (combo_audio_prefA)->entry;
  gtk_widget_ref (combo_entry_audio_prefA);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry_audio_prefA", combo_entry11b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry_audio_prefA);
  gtk_entry_set_text (GTK_ENTRY (combo_entry_audio_prefA), Config.audio_preferedA->str);

  /* 2nd audio preference */
  hbox6b = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox6b", hbox6b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6b);
  gtk_box_pack_start (GTK_BOX (vbox42), hbox6b, TRUE, TRUE, 0);

  label10b = gtk_label_new (_("  2nd Language Prefered    "));
  gtk_widget_ref (label10b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label10b", label10b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10b);
  gtk_box_pack_start (GTK_BOX (hbox6b), label10b, FALSE, FALSE, 0);
  combo_audio_prefB = gtk_combo_new ();
  gtk_widget_ref (combo_audio_prefB);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_audio_prefB", combo_audio_prefB,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_audio_prefB);
  gtk_box_pack_start (GTK_BOX (hbox6b), combo_audio_prefB, TRUE, TRUE, 0);

  for (i=0;strlen(lang_tbl[i].lang_long)>0;i++) {
      combo_audio_prefB_items = g_list_append (combo_audio_prefB_items, (gpointer)lang_tbl[i].lang_long);
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_audio_prefB), combo_audio_prefB_items);
  g_list_free (combo_audio_prefB_items);
  combo_entry_audio_prefB = GTK_COMBO (combo_audio_prefB)->entry;
  gtk_widget_ref (combo_entry_audio_prefB);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry_audio_prefB", combo_entry11b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry_audio_prefB);
  gtk_entry_set_text (GTK_ENTRY (combo_entry_audio_prefB), Config.audio_preferedB->str);



  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox42), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, 100, 15);



  /* Subpicture language preference */
  hbox6b = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox6b", hbox6b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6b);
  gtk_box_pack_start (GTK_BOX (vbox42), hbox6b, TRUE, TRUE, 0);

  label10b = gtk_label_new (_("  Subpicture Language Prefered    "));
  gtk_widget_ref (label10b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label10b", label10b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10b);
  gtk_box_pack_start (GTK_BOX (hbox6b), label10b, FALSE, FALSE, 0);
  combo_spu_prefA = gtk_combo_new ();
  gtk_widget_ref (combo_spu_prefA);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_spu_prefA", combo_spu_prefA,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_spu_prefA);
  gtk_box_pack_start (GTK_BOX (hbox6b), combo_spu_prefA, TRUE, TRUE, 0);

  for (i=0;strlen(lang_tbl[i].lang_long)>0;i++) {
      combo_spu_prefA_items = g_list_append (combo_spu_prefA_items, (gpointer)lang_tbl[i].lang_long);
  } 

  gtk_combo_set_popdown_strings (GTK_COMBO (combo_spu_prefA), combo_spu_prefA_items);
  g_list_free (combo_spu_prefA_items);
  combo_entry_spu_prefA = GTK_COMBO (combo_spu_prefA)->entry;
  gtk_widget_ref (combo_entry_spu_prefA);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry_spu_prefA", combo_entry11b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry_spu_prefA);
  gtk_entry_set_text (GTK_ENTRY (combo_entry_spu_prefA), Config.spu_preferedA->str);

  labelprop2 = gtk_label_new (_("Languages"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                      (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 4), labelprop2);

  /* 2nd spu */
  hbox6b = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox6b", hbox6b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6b);
  gtk_box_pack_start (GTK_BOX (vbox42), hbox6b, TRUE, TRUE, 0);

  label10b = gtk_label_new (_("  2nd Language Prefered    "));
  gtk_widget_ref (label10b);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label10b", label10b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10b);
  gtk_box_pack_start (GTK_BOX (hbox6b), label10b, FALSE, FALSE, 0);
  combo_spu_prefB = gtk_combo_new ();
  gtk_widget_ref (combo_spu_prefB);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_spu_prefB", combo_spu_prefB,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_spu_prefB);
  gtk_box_pack_start (GTK_BOX (hbox6b), combo_spu_prefB, TRUE, TRUE, 0);

  for (i=0;strlen(lang_tbl[i].lang_long)>0;i++) {
      combo_spu_prefB_items = g_list_append (combo_spu_prefB_items, (gpointer)lang_tbl[i].lang_long);
  }

  gtk_combo_set_popdown_strings (GTK_COMBO (combo_spu_prefB), combo_spu_prefB_items);
  g_list_free (combo_spu_prefB_items);
  combo_entry_spu_prefB = GTK_COMBO (combo_spu_prefB)->entry;
  gtk_widget_ref (combo_entry_spu_prefB);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry_spu_prefB", combo_entry11b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry_spu_prefB);
  gtk_entry_set_text (GTK_ENTRY (combo_entry_spu_prefB), Config.spu_preferedB->str);

  labelprop2 = gtk_label_new (_("Languages"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                      (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 4), labelprop2);


  // --- Blurring tab ---
  vbox42 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox42);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox42", vbox42,
                     (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox42);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox42);
  gtk_container_set_border_width (GTK_CONTAINER (vbox42), 9);

  hbox9 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox9);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox9", hbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox9);
  gtk_box_pack_start (GTK_BOX (vbox42), hbox9, TRUE, TRUE, 0);

  label_divx_blurradius = gtk_label_new (_("Radius blur filter (pixels)  "));
  gtk_widget_ref (label_divx_blurradius);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_blurradius", label_divx_blurradius,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_blurradius);
  gtk_box_pack_start (GTK_BOX (hbox9), label_divx_blurradius, FALSE, FALSE, 0);  gtk_label_set_justify (GTK_LABEL (label_divx_blurradius), GTK_JUSTIFY_LEFT);

  spinbutton_blur_adj = gtk_adjustment_new (Config.blurradius, 0, 100, 1, 10, 10);
  spinbutton_blur = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_blur_adj),
1, 0);
  gtk_widget_ref (spinbutton_blur);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_blur", spinbutton_blur,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_blur);
  gtk_box_pack_end (GTK_BOX (hbox9), spinbutton_blur, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_blur, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_blur, _("Radius for blur filter (blur off = 0)"), NULL);

  labelprop2 = gtk_label_new (_("Blur"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                      (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 5), labelprop2);
  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 5));
  
  // --- Clipping tab ---
  vbox43 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox43);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox43", vbox43,
                     (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox43);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox43);
  gtk_container_set_border_width (GTK_CONTAINER (vbox43), 9);

  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox7);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox7", hbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox43), hbox7, TRUE, TRUE, 0);

  label_divx_linesclip = gtk_label_new (_("Clip from top (lines)  "));
  gtk_widget_ref (label_divx_linesclip);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_linesclip", label_divx_linesclip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_linesclip);
  gtk_box_pack_start (GTK_BOX (hbox7), label_divx_linesclip, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_linesclip), GTK_JUSTIFY_LEFT);

  spinbutton_clip_adj = gtk_adjustment_new (Config.cliptop, 0, 10000, 1, 10, 10);
  spinbutton_clip = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_clip_adj), 1, 0);
  gtk_widget_ref (spinbutton_clip);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_clip", spinbutton_clip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_clip);
  gtk_box_pack_end (GTK_BOX (hbox7), spinbutton_clip, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_clip, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_clip, _("Number of lines to clip from top (default is 0, no clipping)"), NULL);

  hbox7r = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox7r);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox7r", hbox7r,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7r);
  gtk_box_pack_start (GTK_BOX (vbox43), hbox7r, TRUE, TRUE, 0);

  label_divx_linesclip_right = gtk_label_new (_("Clip from right (lines)  "));
  gtk_widget_ref (label_divx_linesclip_right);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_linesclip_right", label_divx_linesclip_right,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_linesclip_right);
  gtk_box_pack_start (GTK_BOX (hbox7r), label_divx_linesclip_right, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_linesclip_right), GTK_JUSTIFY_LEFT);

  spinbutton_clip_adj_right = gtk_adjustment_new (Config.clipright, 0, 10000, 1, 10, 10);
  spinbutton_clip_right = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_clip_adj_right), 1, 0);
  gtk_widget_ref (spinbutton_clip_right);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_clip_right", spinbutton_clip_right,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_clip_right);
  gtk_box_pack_end (GTK_BOX (hbox7r), spinbutton_clip_right, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_clip_right, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_clip_right, _("Number of lines to clip from right (default is 0, no clipping)"), NULL);

  hbox7l = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox7l);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox7l", hbox7l,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7l);
  gtk_box_pack_start (GTK_BOX (vbox43), hbox7l, TRUE, TRUE, 0);

  label_divx_linesclip_left = gtk_label_new (_("Clip from left (lines)  "));
  gtk_widget_ref (label_divx_linesclip_left);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_linesclip_left", label_divx_linesclip_left,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_linesclip_left);
  gtk_box_pack_start (GTK_BOX (hbox7l), label_divx_linesclip_left, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_linesclip_left), GTK_JUSTIFY_LEFT);

  spinbutton_clip_adj_left = gtk_adjustment_new (Config.clipleft, 0, 10000, 1, 10, 10);
  spinbutton_clip_left = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_clip_adj_left), 1, 0);
  gtk_widget_ref (spinbutton_clip_left);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_clip_left", spinbutton_clip_left,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_clip_left);
  gtk_box_pack_end (GTK_BOX (hbox7l), spinbutton_clip_left, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_clip_left, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_clip_left, _("Number of lines to clip from left (default is 0, no clipping)"), NULL);


  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox8);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox8", hbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox43), hbox8, TRUE, TRUE, 0);

  label_divx_offsetclip = gtk_label_new (_("Clip from bottom (lines)  "));
  gtk_widget_ref (label_divx_offsetclip);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_offsetclip", label_divx_offsetclip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_offsetclip);
  gtk_box_pack_start (GTK_BOX (hbox8), label_divx_offsetclip, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_offsetclip), GTK_JUSTIFY_LEFT);

  spinbutton_clip_offset_adj = gtk_adjustment_new (Config.clipbottom, 0, 10000, 1, 10, 10);
  spinbutton_clip_offset = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_clip_offset_adj), 1, 0);
  gtk_widget_ref (spinbutton_clip_offset);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_clip_offset", spinbutton_clip_offset,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_clip_offset);
  gtk_box_pack_end (GTK_BOX (hbox8), spinbutton_clip_offset, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_clip_offset, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_clip_offset, _("Number of lines to clip from bottom (default is 0, no clipping)"), NULL);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox43), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, -1, 30);

  checkbutton_autoclip = gtk_check_button_new_with_label (_("Automatic clipping"));
  gtk_widget_ref (checkbutton_autoclip);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_autoclip",
checkbutton_autoclip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_autoclip);
  gtk_box_pack_start (GTK_BOX (vbox43), checkbutton_autoclip, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_autoclip, _("Automatic cut off black borders"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_autoclip), Config.autoclip);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox8);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox8", hbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox43), hbox8, TRUE, TRUE, 0);

  label_divx_framesclip = gtk_label_new (_("Amount of frames per autoclip sample  "));
  gtk_widget_ref (label_divx_framesclip);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_divx_framesclip", label_divx_framesclip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_framesclip);
  gtk_box_pack_start (GTK_BOX (hbox8), label_divx_framesclip, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_framesclip), GTK_JUSTIFY_LEFT);

  spinbutton_clip_frames_adj = gtk_adjustment_new (Config.autoclip_frames, 0, 10000, 1, 10, 10);
  spinbutton_clip_frames = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_clip_frames_adj), 1, 0);
  gtk_widget_ref (spinbutton_clip_frames);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_clip_frames", spinbutton_clip_frames,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_clip_frames);
  gtk_box_pack_end (GTK_BOX (hbox8), spinbutton_clip_frames, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_clip_frames, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_clip_frames, _("Number of frames the autoclipper skips between each sample"), NULL);

  labelprop2 = gtk_label_new (_("Clip"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 6), labelprop2);

  // --- Encoding tab ---
  vbox3 = gtk_vbox_new (FALSE, 8);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox3);
  gtk_container_set_border_width (GTK_CONTAINER (vbox3), 9);

  hbox17 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox17);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox17", hbox17,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox17);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox17, FALSE, FALSE, 0);

  maxsizeoutput = gtk_label_new (_(" Maximum output chunk size (Mb)  "));
  gtk_widget_ref (maxsizeoutput);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "maxsizeoutput", maxsizeoutput,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (maxsizeoutput);
  gtk_box_pack_start (GTK_BOX (hbox17), maxsizeoutput, FALSE, FALSE, 0);

  spinbutton_maxsizeoutput_adj = gtk_adjustment_new (Config.maxsize, 0, 999999, 1, 10, 10);
  spinbutton_maxsizeoutput = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_maxsizeoutput_adj), 1, 0);
  gtk_widget_ref (spinbutton_maxsizeoutput);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_maxsizeoutput", spinbutton_maxsizeoutput,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_maxsizeoutput);
  gtk_box_pack_end (GTK_BOX (hbox17), spinbutton_maxsizeoutput, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_maxsizeoutput, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_maxsizeoutput, _("The maximum size of the output divx. If output grows bigger, another divx file is created. You can make CD sized chunks. Put this value to maximum will generally result into just one file"), NULL);

  hbox20 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox20);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox20", hbox20,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox20);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox20, FALSE, FALSE, 0);

  label_cpus = gtk_label_new (_(" MPEG2 decoding CPUS  "));
  gtk_widget_ref (label_cpus);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_cpus", label_cpus,                            (GtkDestroyNotify) gtk_widget_unref);
  //gtk_widget_show (label_cpus);
  gtk_box_pack_start (GTK_BOX (hbox20), label_cpus, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_cpus), GTK_JUSTIFY_LEFT);

  spinbutton_cpus_adj = gtk_adjustment_new (Config.cpus, 1, 32, 1, 10, 10);
  spinbutton_cpus = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_cpus_adj), 1, 0);
  gtk_widget_ref (spinbutton_cpus);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_cpus", spinbutton_cpus,
                            (GtkDestroyNotify) gtk_widget_unref);
  //gtk_widget_show (spinbutton_cpus);
  gtk_box_pack_end (GTK_BOX (hbox20), spinbutton_cpus, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_cpus, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_cpus, _("Number of cpu's to use for decoding. Note that the encoding takes up about 85% of the cpu load and is SINGLE cpu only because avifile does not supports SMP. So dont exspect too much speed gain out of your SMP machine for now ;("), NULL);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox2, FALSE, FALSE, 0);

  label_nice = gtk_label_new (_(" Nice value backend  "));
  gtk_widget_ref (label_nice);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_nice", label_nice,                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_nice);
  gtk_box_pack_start (GTK_BOX (hbox2), label_nice, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_nice), GTK_JUSTIFY_LEFT);

  spinbutton_nice_adj = gtk_adjustment_new (Config.nice,-20,19, 1, 10, 10);
  spinbutton_nice = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_nice_adj), 1,
0);
  gtk_widget_ref (spinbutton_nice);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "spinbutton_nice", spinbutton_nice,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_nice);
  gtk_box_pack_end (GTK_BOX (hbox2), spinbutton_nice, FALSE, FALSE, 0);
  gtk_widget_set_usize (spinbutton_nice, 200, -2);
  gtk_tooltips_set_tip (tooltips, spinbutton_nice, _("Divx encoding nice value, range goes from -20 (highest priority) to 19 (lowest)"), NULL);

  checkbutton_encode = gtk_check_button_new_with_label (_("Encode DVD mpeg2 streams to DIVX"));
  gtk_widget_ref (checkbutton_encode);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_encode", checkbutton_encode,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_encode);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_encode, FALSE, FALSE, 0);  gtk_tooltips_set_tip (tooltips, checkbutton_encode, _("Encode cached mpeg2 streams to divx. Disabling encoding will make Drip do just the DVD reading to HD and quit after that, usefull for when you dont know how to fill up that huge HD of yours or when you've got a DVD writer or RAM"),NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON ( checkbutton_encode), Config.encode);

  checkbutton_iso = gtk_check_button_new_with_label (_("Make ISO images out of the generated DIVX files"));
  gtk_widget_ref (checkbutton_iso);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_iso", checkbutton_iso,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_iso);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_iso, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_iso, _("Make ISO images out of the generated divx files. You needs to have mkisofs installed. (mkisofs -J -l {divx} > {divx}.iso)"),NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON ( checkbutton_iso), Config.create_iso);


  checkbutton_debug = gtk_check_button_new_with_label (_("Debug logging to screen"));
  gtk_widget_ref (checkbutton_debug);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_debug", checkbutton_debug,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_debug);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_debug, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips,  checkbutton_debug, _("Log DEBUG messages to screen"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_debug), Config.debug_log);

  labelprop2 = gtk_label_new (_("Encoding"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                  (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 7), labelprop2);

  // --- Cache tab ---
  vbox44 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox44);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox44", vbox44,
                 (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox44);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox44);
  gtk_container_set_border_width (GTK_CONTAINER (vbox44), 9);

  hbox21 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox21);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox21", hbox21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox21);
  gtk_box_pack_start (GTK_BOX (vbox44), hbox21, FALSE, FALSE, 0);

  cache_location_label = gtk_label_new (_(" Cache location  "));
  gtk_widget_ref (cache_location_label);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "cache_location_label", cache_location_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cache_location_label);
  gtk_box_pack_start (GTK_BOX (hbox21), cache_location_label, FALSE, FALSE, 0);

  fileentry3 = gnome_file_entry_new (NULL, NULL);
  gtk_widget_ref (fileentry3);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "fileentry3", fileentry3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry3);
  gtk_box_pack_start (GTK_BOX (hbox21), fileentry3, TRUE, TRUE, 0);

  combo_entry_cache_location = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry3));
  gtk_widget_ref (combo_entry_cache_location);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry_cache_location", combo_entry_cache_location,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text (GTK_ENTRY (combo_entry_cache_location), Config.CACHElocation->str);
  gtk_tooltips_set_tip (tooltips,  combo_entry_cache_location , _("Location when Drip caches it's data. Given directory is created if possible automatically."), NULL);
  gtk_widget_show (combo_entry_cache_location);

  checkbutton_chunk_cache = gtk_check_button_new_with_label (_("Cut cache files into 2Gb chunks"));
  gtk_widget_ref (checkbutton_chunk_cache);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_chunk_cache", checkbutton_chunk_cache,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_chunk_cache);
  gtk_box_pack_start (GTK_BOX (vbox44), checkbutton_chunk_cache, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips,  checkbutton_chunk_cache, _("Cut cache to files of maximal 2Gb in size. Old filesystems can not handle bigger files, most new ones can."), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_chunk_cache), Config.cache_chunk);

  checkbutton_delete_cache = gtk_check_button_new_with_label (_("Delete cache on exit"));
  gtk_widget_ref (checkbutton_delete_cache);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_delete_cache", checkbutton_delete_cache,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_delete_cache);
  gtk_box_pack_start (GTK_BOX (vbox44), checkbutton_delete_cache, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips,  checkbutton_delete_cache, _("Delete all cached video data when Drip exits."), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_delete_cache), Config.cache_delete_on_exit);

  labelprop2 = gtk_label_new (_("Cache"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
                 (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 8), labelprop2);

  // --- Deinterlace tab ---
  vbox45 = gtk_vbox_new (FALSE, 7);
  gtk_widget_ref (vbox45);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox45", vbox45,
                (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox45);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox45);
  gtk_container_set_border_width (GTK_CONTAINER (vbox45), 9);

  checkbutton_deinterlace = gtk_check_button_new_with_label (_("Deinterlace PAL video"));
  gtk_widget_ref (checkbutton_deinterlace);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_deinterlace",
                        checkbutton_deinterlace,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_deinterlace);
  gtk_box_pack_start (GTK_BOX (vbox45), checkbutton_deinterlace, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_deinterlace, _("Adaptive deinterlace PAL video stream, do not use this for NTSC video"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_deinterlace), Config.deinterlace);

  checkbutton_pulldown = gtk_check_button_new_with_label (_("Deinterlace NTSC video (Reverse 3:2 pulldown)"));
  gtk_widget_ref (checkbutton_pulldown);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_pulldown",
                        checkbutton_pulldown,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_pulldown);
  gtk_box_pack_start (GTK_BOX (vbox45), checkbutton_pulldown, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_pulldown, _("Reverse 3:2 pulldown NTSC video stream. Do not use this filter for PAL video"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_pulldown), Config.pulldown);
  /* -- */ gtk_widget_set_sensitive(checkbutton_pulldown,FALSE); /* Disable until ready */

  labelprop2 = gtk_label_new (_("Deinterlace"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 9), labelprop2);


  // --- Plugins tab ---
  vbox46 = gtk_vbox_new (FALSE, 3);
  gtk_widget_ref (vbox46);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "vbox46", vbox46,
                (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox46);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox46);
  gtk_container_set_border_width (GTK_CONTAINER (vbox46), 9);

  hbox22 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox22);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox22", hbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox22); 
  gtk_box_pack_start (GTK_BOX (vbox46), hbox22, FALSE, FALSE, 0);
  
  label11 = gtk_label_new (_(" Plugin  "));
  gtk_widget_ref (label11);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label11", label11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (hbox22), label11, FALSE, FALSE, 0);

  combo_filter = gtk_combo_new ();
  gtk_widget_ref (combo_filter);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_filter", combo_filter,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_filter);
  gtk_box_pack_start (GTK_BOX (hbox22), combo_filter, TRUE, TRUE, 0);
  for (i=0;i<filters_index;i++) {
      combo_filter_items = g_list_append (combo_filter_items, (gpointer)filters[i].module_name->str);
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_filter), combo_filter_items);
  g_list_free (combo_filter_items);
  
  combo_entry12 = GTK_COMBO (combo_filter)->entry;
  gtk_widget_ref (combo_entry12);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "combo_entry12", combo_entry12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry12);
  gtk_entry_set_text (GTK_ENTRY (combo_entry12), filters[0].module_name->str);

/* -------------------- */
  hbox22 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox22);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "hbox22", hbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox22);
  gtk_box_pack_start (GTK_BOX (vbox46), hbox22, FALSE, FALSE, 0);

  checkbutton_active = gtk_check_button_new_with_label ("Use this plugin?");
  gtk_widget_ref (checkbutton_active);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "checkbutton_active", checkbutton_active,(GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show (checkbutton_active);
  gtk_box_pack_start (GTK_BOX (hbox22), checkbutton_active, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, checkbutton_eject, "Use this filter during encoding?",NULL);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_active), filters[0].active);

  switch (filters[0].module_type) {
      case AUDIO   : label_filter_type = gtk_label_new ("      (Audio ");
                     break;
      case VIDEO   : label_filter_type = gtk_label_new ("      (Video ");
                     break;
      case SPU     : label_filter_type = gtk_label_new ("      (Subpicture ");
                     break;
      default      : label_filter_type = gtk_label_new ("      (Unknown ");
                     break;
  }
  gtk_widget_ref(label_filter_type);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_filter_type", label_filter_type,(GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start(GTK_BOX (hbox22), label_filter_type, FALSE, FALSE, 0);
  gtk_widget_show(label_filter_type);

  switch (filters[0].module_phase) {
      case PRE     : label_filter_phase = gtk_label_new ("Pre filter)    ");
                     break;
      case NORMAL  : label_filter_phase = gtk_label_new ("Normal filter)    ");
                     break;
      case POST    : label_filter_phase = gtk_label_new ("Post filter)    ");
                     break;
      default      : label_filter_phase = gtk_label_new ("Unknown filter)    ");
                     break;
  }
  gtk_widget_ref(label_filter_phase);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "label_filter_phase", label_filter_phase,(GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start(GTK_BOX (hbox22), label_filter_phase, FALSE, FALSE, 0);
  gtk_widget_show(label_filter_phase);

  button20 = gtk_button_new_with_label (_("  Reset Plugin to Default Settings  "));
  gtk_widget_ref (button20);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "button20", button20,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_button_set_relief (GTK_BUTTON (button20), GTK_RELIEF_HALF);
  gtk_widget_show (button20);
  gtk_box_pack_end (GTK_BOX (hbox22), button20, FALSE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (button20), "clicked",
                      GTK_SIGNAL_FUNC (on_reset_to_default_clicked),
                      combo_entry12);

  plugin_frame = gtk_frame_new (NULL);
  gtk_widget_ref (plugin_frame);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "plugin_frame", plugin_frame,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plugin_frame);
  gtk_container_add (GTK_CONTAINER (vbox46), plugin_frame);
  gtk_container_set_border_width (GTK_CONTAINER (plugin_frame), 2);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_ref(scrolledwindow);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
  gtk_container_add(GTK_CONTAINER(plugin_frame), scrolledwindow);
  gtk_widget_show(scrolledwindow);

  viewport = gtk_viewport_new(NULL, NULL);
  gtk_widget_ref(viewport);
  gtk_widget_show(viewport);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), viewport);

  plugin_GUI_socket = gtk_socket_new();
  gtk_widget_show (plugin_GUI_socket);
  gtk_container_add (GTK_CONTAINER (viewport), plugin_GUI_socket);

  labelprop2 = gtk_label_new (_("Plugins"));
  gtk_widget_ref (labelprop2);
  gtk_object_set_data_full (GTK_OBJECT (propertybox1), "labelprop2", labelprop2,
            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelprop2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1),10), labelprop2);

  // Call for 1st time show
  on_combo_entry_plugin_changed((GtkEditable *)combo_entry12, combo_entry12);

  /* signal handlers */
  gtk_signal_connect (GTK_OBJECT (combo_entry11), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry11_changed),
                      combo_entry11);
  gtk_signal_connect (GTK_OBJECT (propertybox1), "destroy",
                      GTK_SIGNAL_FUNC (on_propertybox1_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (combo_entry12), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry_plugin_changed),
                      combo_entry12);
  gtk_signal_connect (GTK_OBJECT (combo2), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry_dvddevice_changed),
                      combo2);
  gtk_signal_connect (GTK_OBJECT (combo3), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry_dvdsource_changed),
                      combo3);
  gtk_signal_connect (GTK_OBJECT (combo_entry2), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry2_changed),
                      combo_entry2);
  gtk_signal_connect (GTK_OBJECT (spinbutton_video_bitrate), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_video_bitrate_changed),
                      spinbutton_video_bitrate);
  gtk_signal_connect (GTK_OBJECT (spinbutton_blur), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_blur_changed),
                      spinbutton_blur);
  gtk_signal_connect (GTK_OBJECT (spinbutton_cpus), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_cpus_changed),
                      spinbutton_cpus);
  gtk_signal_connect (GTK_OBJECT (spinbutton_width), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_width_changed),
                      spinbutton_width);
  gtk_signal_connect (GTK_OBJECT (spinbutton_height), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_heigth_changed),
                      spinbutton_height);
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO(combo_audio_bitrate)->entry), "changed",
                      GTK_SIGNAL_FUNC (on_combo_audio_bitrate_changed),
                      GTK_COMBO(combo_audio_bitrate)->entry);
  gtk_signal_connect (GTK_OBJECT (spinbutton_clip), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_clip_changed),
                      spinbutton_clip);
  gtk_signal_connect (GTK_OBJECT (spinbutton_clip_left), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_clipleft_changed),
                      spinbutton_clip_left);
  gtk_signal_connect (GTK_OBJECT (spinbutton_clip_right), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_clipright_changed),
                      spinbutton_clip_right);
  gtk_signal_connect (GTK_OBJECT (spinbutton_clip_frames), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_clipframes_changed),
                      spinbutton_clip_frames);
  gtk_signal_connect (GTK_OBJECT (spinbutton_maxsizeoutput), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_maxsizeoutput_changed),
                      spinbutton_maxsizeoutput);
  gtk_signal_connect (GTK_OBJECT (spinbutton_clip_offset), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_clip_offset_changed),
                      spinbutton_clip_offset);
  gtk_signal_connect (GTK_OBJECT (checkbutton_eject), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_eject_toggled),
                      checkbutton_eject);
  gtk_signal_connect (GTK_OBJECT (checkbutton_active), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_active_toggled),
                      combo_entry12);
  gtk_signal_connect (GTK_OBJECT (checkbutton_autoclip), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_autoclip_toggled),
                      checkbutton_autoclip);
  gtk_signal_connect (GTK_OBJECT (checkbutton_deinterlace), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_deinterlace_toggled),
                      checkbutton_deinterlace);
  gtk_signal_connect (GTK_OBJECT (checkbutton_pulldown), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_pulldown_toggled),
                      checkbutton_pulldown);
  gtk_signal_connect (GTK_OBJECT (checkbutton_dvddb), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_dvddb_toggled),
                      checkbutton_dvddb);
  gtk_signal_connect (GTK_OBJECT (checkbutton_debug), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_debug_toggled),
                      checkbutton_debug);
  gtk_signal_connect (GTK_OBJECT (spinbutton_nice), "changed",
                      GTK_SIGNAL_FUNC (on_entry2_changed),
                      spinbutton_nice);
  gtk_signal_connect (GTK_OBJECT (checkbutton_audionorm), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_audionorm_toggled),
                      checkbutton_audionorm);
  gtk_signal_connect (GTK_OBJECT (combo_entry11b), "changed",
                      GTK_SIGNAL_FUNC (on_combo_audiocodec_changed),
                      combo_entry11b);
  gtk_signal_connect (GTK_OBJECT (button_calculate_bitrate), "clicked",
                      GTK_SIGNAL_FUNC (on_button_calculate_bitrate_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (checkbutton_encode), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_encode_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "toggled",
                      GTK_SIGNAL_FUNC (on_radiobutton_useDVDdevice_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "toggled",
                      GTK_SIGNAL_FUNC (on_radiobutton_useDVDsource_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (combo_entry_cache_location), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry_cache_location_changed),
                      combo_entry_cache_location);
  gtk_signal_connect (GTK_OBJECT (checkbutton_delete_cache), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_delete_cache_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (checkbutton_chunk_cache), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_chunk_cache_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (checkbutton_iso), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_iso_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (combo_entry_audio_prefA), "changed",
                      GTK_SIGNAL_FUNC (on_combo_audio_preferenceA_changed),
                      combo_entry_audio_prefA);
  gtk_signal_connect (GTK_OBJECT (combo_entry_audio_prefB), "changed",
                      GTK_SIGNAL_FUNC (on_combo_audio_preferenceB_changed),
                      combo_entry_audio_prefB);
  gtk_signal_connect (GTK_OBJECT (combo_entry_spu_prefA), "changed",
                      GTK_SIGNAL_FUNC (on_combo_spu_preferenceA_changed),
                      combo_entry_spu_prefA);
  gtk_signal_connect (GTK_OBJECT (combo_entry_spu_prefB), "changed",
                      GTK_SIGNAL_FUNC (on_combo_spu_preferenceB_changed),
                      combo_entry_spu_prefB);



  gtk_object_set_data (GTK_OBJECT (propertybox1), "tooltips", tooltips);

  g_string_free(format,TRUE);
  return propertybox1;
}


GtkWidget* create_rip_dialog (void) {
  GtkWidget *rip_dialog;
  GtkWidget *dialog_vbox5;
  GtkWidget *vbox7;
  GtkWidget *hbox15;
  GtkWidget *label_divx_video_bitrate;
  GtkWidget *fileentry_divx;
  GtkWidget *combo_entry2;
  GtkWidget *hbox21;
  GtkWidget *label_ripdvd_select_audio_channel;
  GtkWidget *vbox9;
  GtkWidget *hbox22;
  GtkWidget *label6;
  GtkWidget *combo_subpicture;
  GtkWidget *combo_entry9;
  GtkWidget *dialog_action_area5;
  GtkWidget *button11;
  GtkWidget *button13;
  GtkWidget *hbox23;
  GtkWidget *label7;
  GtkWidget *combo_title;
  GList *combo_title_items = NULL;
  GString *title_nr = NULL;

  gint i = 0;

  /* Reset subpicture & Audio channel */
  Config.subpicture_stream = -1;
  Config.audio_1st_stream = 0;
  Config.audio_2nd_stream = 0;
  
  rip_dialog = gnome_dialog_new (_("Audio & Language"), NULL);
  gtk_object_set_data (GTK_OBJECT (rip_dialog), "rip_dialog", rip_dialog);
  gtk_window_set_policy (GTK_WINDOW (rip_dialog), FALSE, TRUE, TRUE);

  dialog_vbox5 = GNOME_DIALOG (rip_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (rip_dialog), "dialog_vbox5", dialog_vbox5);
  gtk_widget_show (dialog_vbox5);

  vbox7 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox7);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "vbox7", vbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox7);
  gtk_box_pack_start (GTK_BOX (dialog_vbox5), vbox7, TRUE, TRUE, 0);

  /* Filename */
  hbox15 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox15);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "hbox15", hbox15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox15);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox15, FALSE, FALSE, 0);

  label_divx_video_bitrate = gtk_label_new (_("DIVX Filename "));
  gtk_widget_ref (label_divx_video_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "label_divx_video_bitrate", label_divx_video_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_divx_video_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox15), label_divx_video_bitrate, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_divx_video_bitrate), GTK_JUSTIFY_RIGHT);

  fileentry_divx = gnome_file_entry_new (NULL, _("Filename of output Divx"));
  gtk_widget_ref (fileentry_divx);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "fileentry_divx", fileentry_divx,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry_divx);
  gtk_box_pack_start (GTK_BOX (hbox15), fileentry_divx, TRUE, TRUE, 0);

  combo_entry2 = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (fileentry_divx));
  gtk_widget_ref (combo_entry2);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "combo_entry2", combo_entry2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry2);
  gtk_entry_set_text (GTK_ENTRY (combo_entry2), Config.DIVXfileUser->str);

  /* Titles */
  hbox23 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox23);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "hbox23", hbox23,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox23);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox23, TRUE, TRUE, 5);

  label7 = gtk_label_new (_(" DVD Title   "));
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox23), label7, FALSE, FALSE, 0);

  combo_title = gtk_combo_new ();
  gtk_widget_ref (combo_title);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "combo_title", combo_title,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_title);
  gtk_box_pack_start (GTK_BOX (hbox23), combo_title, TRUE, TRUE, 0);
  for (i=0;i<Config.DVD_Total_ChapterSequences;i++) {
      title_nr = g_string_new(""); //memleaking.. 
      g_string_sprintf(title_nr,"%i",i+1);
      combo_title_items = g_list_append (combo_title_items, title_nr->str);
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_title), combo_title_items);
  g_list_free (combo_title_items);

  /* Audio channels */
  hbox21 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox21);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "hbox21", hbox21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox21);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox21, TRUE, TRUE, 0);

  label_ripdvd_select_audio_channel = gtk_label_new (_(" Audio channel  "));
  gtk_widget_ref (label_ripdvd_select_audio_channel);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "label_ripdvd_select_audio_channel", label_ripdvd_select_audio_channel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_ripdvd_select_audio_channel);
  gtk_box_pack_start (GTK_BOX (hbox21), label_ripdvd_select_audio_channel, FALSE, FALSE, 0);

  vbox9 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox9);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "vbox9", vbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9);
  gtk_box_pack_start (GTK_BOX (hbox21), vbox9, TRUE, TRUE, 0);

  /* Subpictures */
  hbox22 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox22);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "hbox22", hbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox22);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox22, TRUE, TRUE, 5);

  label6 = gtk_label_new (_(" Subpicture   "));
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox22), label6, FALSE, FALSE, 0);

  combo_subpicture = gtk_combo_new ();
  gtk_widget_ref (combo_subpicture);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "combo_subpicture", combo_subpicture,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_subpicture);
  gtk_box_pack_start (GTK_BOX (hbox22), combo_subpicture, TRUE, TRUE, 0);

  combo_entry9 = GTK_COMBO (combo_subpicture)->entry;
  gtk_widget_ref (combo_entry9);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "combo_entry9", combo_entry9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry9);
  gtk_entry_set_text (GTK_ENTRY (combo_entry9), "None");

  /* Dialog stuff */
  dialog_action_area5 = GNOME_DIALOG (rip_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (rip_dialog), "dialog_action_area5", dialog_action_area5);
  gtk_widget_show (dialog_action_area5);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area5), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area5), 8);

  gnome_dialog_append_button (GNOME_DIALOG (rip_dialog), GNOME_STOCK_BUTTON_OK);
  button11 = GTK_WIDGET (g_list_last (GNOME_DIALOG (rip_dialog)->buttons)->data);
  gtk_widget_ref (button11);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "button11", button11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button11);
  GTK_WIDGET_SET_FLAGS (button11, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (rip_dialog), GNOME_STOCK_BUTTON_CANCEL);
  button13 = GTK_WIDGET (g_list_last (GNOME_DIALOG (rip_dialog)->buttons)->data);
  gtk_widget_ref (button13);
  gtk_object_set_data_full (GTK_OBJECT (rip_dialog), "button13", button13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button13);
  GTK_WIDGET_SET_FLAGS (button13, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (combo_entry9), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry9_changed),
                      combo_entry9);
  gtk_signal_connect (GTK_OBJECT (button11), "clicked",
                      GTK_SIGNAL_FUNC (on_button11_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button13), "clicked",
                      GTK_SIGNAL_FUNC (on_button13_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (combo_entry2), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry2_changed),
                      combo_entry2);

  return rip_dialog;
}

GtkWidget*
create_about_drip (void)
{
  const gchar *authors[] = {
    "Jarl van Katwijk",
    NULL
  };
  GtkWidget *about_drip;

  about_drip = gnome_about_new ("Drip", VERSION,
                        _("GPL"),
                        authors,
                        _("Application GUI and backend set for backing up DVD content in DIVX format. Using Drip might not be legal in your situation"),
                        "drip/drip_logo.jpg");
  gtk_object_set_data (GTK_OBJECT (about_drip), "about_drip", about_drip);
  gtk_window_set_modal (GTK_WINDOW (about_drip), TRUE);

  return about_drip;
}

GtkWidget* create_messagebox_betanotice(void) {
  GtkWidget *messagebox_betanotice;
  GtkWidget *dialog_vbox1;
  GtkWidget *button3;
  GtkWidget *dialog_action_area1;
  GtkWidget *href_drip;
  GtkWidget *href_drip_howto;
  GtkTooltips *tooltips;
  GString *temp;

  tooltips = gtk_tooltips_new ();

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  temp = g_string_new("");
  g_string_sprintf(temp,"Welcome to Drip %s\nCheck for updates and please report bugs.\n\nThis dialog is displayed because Drip could not find a valid\nconfiguration. You are running Drip for the 1st time on this host,\nor the configuration format has been changed\n\n\n-> Check all the Preferences settings before using this software! <-\n",VERSION);
  messagebox_betanotice = gnome_message_box_new (temp->str,
                              GNOME_MESSAGE_BOX_WARNING,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove ((GtkContainer*)(GTK_CONTAINER (GNOME_DIALOG (messagebox_betanotice)->action_area)), (GtkWidget*)(GNOME_DIALOG (messagebox_betanotice)->buttons->data));
  GNOME_DIALOG (messagebox_betanotice)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (messagebox_betanotice), "messagebox_betanotice", messagebox_betanotice);
  gtk_window_set_title (GTK_WINDOW (messagebox_betanotice), _("Drip - Welcome"));
  gtk_window_set_position (GTK_WINDOW (messagebox_betanotice), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (messagebox_betanotice), FALSE, FALSE, FALSE);
  gtk_window_set_modal (GTK_WINDOW (messagebox_betanotice), TRUE);

  dialog_vbox1 = GNOME_DIALOG (messagebox_betanotice)->vbox;
  gtk_object_set_data (GTK_OBJECT (messagebox_betanotice), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);



  href_drip = gnome_href_new ("http://drip.sourceforge.net/", _("Drip Homepage"));  gtk_widget_ref (href_drip);
  gtk_object_set_data_full (GTK_OBJECT (messagebox_betanotice), "href_drip", href_drip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (href_drip);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), href_drip, FALSE, FALSE, 0);

  href_drip_howto = gnome_href_new ("http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/~checkout~/drip/drip/doc/C/drip/index.html", _("Encoding HOWTO"));  gtk_widget_ref (href_drip_howto);
  gtk_object_set_data_full (GTK_OBJECT (messagebox_betanotice), "href_drip", href_drip_howto,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (href_drip_howto);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), href_drip_howto, FALSE, FALSE, 0);


  gnome_dialog_append_button (GNOME_DIALOG (messagebox_betanotice), GNOME_STOCK_BUTTON_OK);
  button3 = GTK_WIDGET (g_list_last (GNOME_DIALOG (messagebox_betanotice)->buttons)->data);
  gtk_widget_ref (button3);
  gtk_object_set_data_full (GTK_OBJECT (messagebox_betanotice), "button3", button3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button3);
  GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

  dialog_action_area1 = GNOME_DIALOG (messagebox_betanotice)->action_area;
  gtk_widget_ref (dialog_action_area1);
  gtk_object_set_data_full (GTK_OBJECT (messagebox_betanotice), "dialog_action_area1", dialog_action_area1,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_object_set_data (GTK_OBJECT (messagebox_betanotice), "tooltips", tooltips);

  return messagebox_betanotice;
}


GtkWidget* create_messagebox_buzy(void) {
  GtkWidget *messagebox_buzy;
  GtkWidget *dialog_vbox2;
  GtkWidget *button4;
  GtkWidget *dialog_action_area2;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  messagebox_buzy = gnome_message_box_new (_("Drip is buzy converting,\nplease wait or Stop the process."),
                              GNOME_MESSAGE_BOX_INFO,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (messagebox_buzy)->action_area), (GtkWidget*)GNOME_DIALOG (messagebox_buzy)->buttons->data);
  GNOME_DIALOG (messagebox_buzy)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (messagebox_buzy), "messagebox_buzy", messagebox_buzy);
  gtk_window_set_title (GTK_WINDOW (messagebox_buzy), _("Drip - Buzy"));
  gtk_window_set_position (GTK_WINDOW (messagebox_buzy), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (messagebox_buzy), TRUE);
  gtk_window_set_policy (GTK_WINDOW (messagebox_buzy), FALSE, FALSE, FALSE);

  dialog_vbox2 = GNOME_DIALOG (messagebox_buzy)->vbox;
  gtk_object_set_data (GTK_OBJECT (messagebox_buzy), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  gnome_dialog_append_button (GNOME_DIALOG (messagebox_buzy), GNOME_STOCK_BUTTON_OK);
  button4 = GTK_WIDGET (g_list_last (GNOME_DIALOG (messagebox_buzy)->buttons)->data);
  gtk_widget_ref (button4);
  gtk_object_set_data_full (GTK_OBJECT (messagebox_buzy), "button4", button4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button4);
  GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

  dialog_action_area2 = GNOME_DIALOG (messagebox_buzy)->action_area;
  gtk_widget_ref (dialog_action_area2);
  gtk_object_set_data_full (GTK_OBJECT (messagebox_buzy), "dialog_action_area2", dialog_action_area2,
                            (GtkDestroyNotify) gtk_widget_unref);

  return messagebox_buzy;
}


GtkWidget*
create_infobox(gchar *text)
{
  GtkWidget *infobox;
  GtkWidget *dialog_vbox;
  GtkWidget *button;
  GtkWidget *dialog_action_area;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  infobox = gnome_message_box_new (text,
                 GNOME_MESSAGE_BOX_INFO,
                 GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (infobox)->action_area), (GtkWidget*)GNOME_DIALOG (infobox)->buttons->data);
  GNOME_DIALOG (infobox)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (infobox), "infobox",infobox);
  gtk_window_set_title (GTK_WINDOW (infobox), _("Drip - Information"));
  gtk_window_set_position (GTK_WINDOW (infobox), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (infobox), TRUE);
  gtk_window_set_policy (GTK_WINDOW (infobox), FALSE, FALSE, FALSE);

  dialog_vbox = GNOME_DIALOG (infobox)->vbox;
  gtk_object_set_data (GTK_OBJECT (infobox), "dialog_vbox", dialog_vbox);
  gtk_widget_show (dialog_vbox);

  gnome_dialog_append_button (GNOME_DIALOG (infobox), GNOME_STOCK_BUTTON_OK);
  button = GTK_WIDGET (g_list_last (GNOME_DIALOG (infobox)->buttons)->data);
  gtk_widget_ref (button);
  gtk_object_set_data_full (GTK_OBJECT (infobox), "button", button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  dialog_action_area = GNOME_DIALOG (infobox)->action_area;
  gtk_widget_ref (dialog_action_area);
  gtk_object_set_data_full (GTK_OBJECT (infobox), "dialog_action_area", dialog_action_area,
                            (GtkDestroyNotify) gtk_widget_unref);

  return infobox;
}

GtkWidget*
create_messagebox(void)
{
  GtkWidget *messagebox1;
  GtkWidget *dialog_vbox1;
  GtkWidget *button1;
  GtkWidget *dialog_action_area1;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  messagebox1 = gnome_message_box_new ("Drip will not run on this machine due to the geographical location",
                              GNOME_MESSAGE_BOX_WARNING,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (messagebox1)->action_area), GNOME_DIALOG (messagebox1)->buttons->data);
  GNOME_DIALOG (messagebox1)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (messagebox1), "messagebox1", messagebox1);
  gtk_window_set_title (GTK_WINDOW (messagebox1), _("Wont run"));
  gtk_window_set_position (GTK_WINDOW (messagebox1), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (messagebox1), FALSE, FALSE, FALSE);

  dialog_vbox1 = GNOME_DIALOG (messagebox1)->vbox;
  gtk_object_set_data (GTK_OBJECT (messagebox1), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  gnome_dialog_append_button (GNOME_DIALOG (messagebox1), GNOME_STOCK_BUTTON_OK);
  button1 = GTK_WIDGET (g_list_last (GNOME_DIALOG (messagebox1)->buttons)->data);
  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (messagebox1), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button1);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

  dialog_action_area1 = GNOME_DIALOG (messagebox1)->action_area;
  gtk_widget_ref (dialog_action_area1);
  gtk_object_set_data_full (GTK_OBJECT (messagebox1), "dialog_action_area1", dialog_action_area1,
                            (GtkDestroyNotify) gtk_widget_unref);

  return messagebox1;
}


GtkWidget* create_manual_selection_dialog (gint files,struct dirent **vobsdir,gchar *track_dir) {
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox3;
  GtkWidget *vbox5;
  GtkWidget *label_dvd_sources;
  GtkWidget *scrolledwindow2;
  GtkWidget *clist1;
  GtkWidget *label_select_file;
  GtkWidget *label_select_size;
  GtkWidget *label_select_rip;
  GtkWidget *dialog_action_area3;
  GtkWidget *button5;
  GtkWidget *button7;
  gint cnt;
  gchar *row[4];
  GdkColor col_yes,col_no;
  struct stat file_stats;
  GString *col0 = g_string_new("");
  GString *col1 = g_string_new("");
  GString *col2 = g_string_new("");
  GString *col3 = g_string_new("");

  dialog1 = gnome_dialog_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog1", dialog1);
  GTK_WINDOW (dialog1)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_policy (GTK_WINDOW (dialog1), TRUE, TRUE, TRUE);
  gtk_widget_set_usize (dialog1, 600, 600);
  gtk_window_set_title (GTK_WINDOW (dialog1), _("Drip - Source selection"));

  dialog_vbox3 = GNOME_DIALOG (dialog1)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_vbox3", dialog_vbox3);
  gtk_widget_show (dialog_vbox3);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox5);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "vbox5", vbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (dialog_vbox3), vbox5, TRUE, TRUE, 0);

  label_dvd_sources = gtk_label_new (_("Select mpeg2 source files to be converted\nDVD .vob files are chunks of mpeg2 data\nand are NOT valid unless concatinated.\n"));  gtk_widget_ref (label_dvd_sources);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "label_dvd_sources", label_dvd_sources,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_dvd_sources);
  gtk_box_pack_start (GTK_BOX (vbox5), label_dvd_sources, FALSE, FALSE, 0);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow2);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox5), scrolledwindow2, TRUE, TRUE, 0);

  clist1 = gtk_clist_new (4);
  gtk_widget_ref (clist1);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "clist1", clist1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 160);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 100);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 2, 150);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 3, 80);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 0,TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 1,TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 2,TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 3,TRUE);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));

  label_select_file = gtk_label_new (_("DVD file"));
  gtk_widget_ref (label_select_file);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "label_select_file", label_select_file,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_file);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label_select_file);

  label_select_size = gtk_label_new (_("Size (kB)"));
  gtk_widget_ref (label_select_size);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "label_select_size", label_select_size,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_size);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label_select_size);

  label_select_size = gtk_label_new (_("Description"));
  gtk_widget_ref (label_select_size);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "label_select_size", label_select_size,                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_size);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 2, label_select_size);

  label_select_rip = gtk_label_new (_("Use this file?"));
  gtk_widget_ref (label_select_rip);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "label_select_rip", label_select_rip,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_select_rip);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 3, label_select_rip);

  /* Allocate colours */
  gdk_color_parse("tomato3",&col_no);
  gdk_color_parse("green3",&col_yes);

  for (cnt = 0; cnt < files; ++cnt) {
      
      g_string_sprintf(col0,"%s",vobsdir[cnt]->d_name);
      row[0] = col0->str;

      g_string_sprintf(col1,"%s%s",track_dir,vobsdir[cnt]->d_name);
      stat(col1->str, &file_stats);
      g_string_sprintf(col1,"   %Li   ",(long long)file_stats.st_size);
      row[1] = col1->str;

      /* lowercase filename, so both UDF and ISO9660 can be handled */
      g_strdown(vobsdir[cnt]->d_name);
      /* Build description and convertable data */
      if (strstr(vobsdir[cnt]->d_name,"subpicture")!=NULL) {
          row[2] = "   Subpicture stream   ";
          row[3] = " ";
          gtk_clist_append(GTK_CLIST(clist1),row);
          } else {
          if (strstr(vobsdir[cnt]->d_name,"video_ts.ifo")!=NULL) {
              row[2] = "   Secondary navigational information   ";
              row[3] = " ";
              gtk_clist_append(GTK_CLIST(clist1),row);
          } else {
              if (strstr(vobsdir[cnt]->d_name,"video_ts.bup")!=NULL) {
                  row[2] = "   Secondary Navigational information backup   ";
                  row[3] = " ";
                  gtk_clist_append(GTK_CLIST(clist1),row);
              } else {
                  if (strstr(vobsdir[cnt]->d_name,".vob")!=NULL) {
                      row[2] = "   Video Transport Stream   ";
                      row[3] = "   NO   ";
                      gtk_clist_append(GTK_CLIST(clist1),row);
                      gtk_clist_set_background(GTK_CLIST(clist1),cnt,&col_no);
                  } else {
                      if ( (strstr(vobsdir[cnt]->d_name,".ifo")!=NULL) && (strstr(vobsdir[cnt]->d_name,"vts")!=NULL) ) {
                          row[2] = "   Navigational information   ";
                          row[3] = "   NO   ";
                          gtk_clist_append(GTK_CLIST(clist1),row);
                          gtk_clist_set_background(GTK_CLIST(clist1),cnt,&col_no);
                      } else {
                          if (strstr(vobsdir[cnt]->d_name,".bup")!=NULL) {
                              row[2] = "   Navigational info backup   ";
                              row[3] = " ";
                              gtk_clist_append(GTK_CLIST(clist1),row);
                          } else {
                              if (strstr(vobsdir[cnt]->d_name,".aob")!=NULL) {
                                  row[2] = "   Audio Transport Stream   ";
                                  row[3] = " ";
                                  gtk_clist_append(GTK_CLIST(clist1),row);
                              } else {
                                  if (strstr(vobsdir[cnt]->d_name,".mpg")!=NULL) {
                                      row[2] = "   Mpeg file   ";
                                      row[3] = "   NO   "; 
                                      gtk_clist_append(GTK_CLIST(clist1),row);
                                      gtk_clist_set_background(GTK_CLIST(clist1),cnt,&col_no);
                                  }
                              }
                          }
                      }
                  }
              }
          }
      }
  }

  /* -------- */

  dialog_action_area3 = GNOME_DIALOG (dialog1)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_action_area3", dialog_action_area3);
  gtk_widget_show (dialog_action_area3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area3), 8);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_OK);
  button5 = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog1)->buttons)->data);
  gtk_widget_ref (button5);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "button5", button5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button5);
  GTK_WIDGET_SET_FLAGS (button5, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_CANCEL);
  button7 = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog1)->buttons)->data);
  gtk_widget_ref (button7);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "button7", button7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button7);
  GTK_WIDGET_SET_FLAGS (button7, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (clist1), "select_row",GTK_SIGNAL_FUNC (on_dvdstreams_select_row),NULL);
  gtk_signal_connect (GTK_OBJECT (button5), "clicked",GTK_SIGNAL_FUNC (on_dvdstream_ok_clicked),clist1);
  gtk_signal_connect (GTK_OBJECT (button7), "clicked",GTK_SIGNAL_FUNC (on_dvdstream_cancel_clicked),NULL);

  g_string_free(col0,TRUE);
  g_string_free(col1,TRUE);
  g_string_free(col2,TRUE);
  g_string_free(col3,TRUE);
  return dialog1;
}

GtkWidget*
create_calculate_bitrate (void)
{
  GtkWidget *dialog2;
  GtkWidget *dialog_vbox4;
  GtkWidget *vbox6;
  GtkWidget *hbox10;
  GtkWidget *label_calc_size;
  GtkObject *spinbutton1_adj;
  GtkWidget *hbox12;
  GtkWidget *label_calc_seconds;
  GtkObject *spinbutton2_adj;
  GtkWidget *hbox11;
  GtkWidget *label_calc_audio;
  GtkObject *spinbutton3_adj;
  GtkWidget *hseparator1;
  GtkWidget *hbox14;
  GtkWidget *hbox33;
  GSList *hbox33_group = NULL;
  GtkWidget *radiobutton7;
  GtkWidget *radiobutton8;
  GtkWidget *dialog_action_area4;
  GtkWidget *label_calc_bitrate;
  GtkWidget *button8;
  GtkWidget *button10;
  GtkWidget *label_calc_width;
  GtkObject *spinbutton4_adj;
  GtkWidget *label_calc_height;
  GtkObject *spinbutton5_adj;
  GtkWidget *hbox15;
  GtkWidget *hbox16; 

  dialog2 = gnome_dialog_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (dialog2), "dialog2", dialog2);
  gtk_widget_set_usize (dialog2, 500, -2);
  gtk_window_set_policy (GTK_WINDOW (dialog2), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW (dialog2), _("Drip - Calculate Bitrate"));


  dialog_vbox4 = GNOME_DIALOG (dialog2)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog2), "dialog_vbox4", dialog_vbox4);
  gtk_widget_show (dialog_vbox4);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox6);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "vbox6", vbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (dialog_vbox4), vbox6, TRUE, TRUE, 0);

  hbox10 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox10);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox10", hbox10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox10);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox10, FALSE, FALSE, 0);

  label_calc_size = gtk_label_new (_(" Requested size (Megabytes) "));
  gtk_widget_ref (label_calc_size);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "label_calc_size", label_calc_size,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_calc_size);
  gtk_box_pack_start (GTK_BOX (hbox10), label_calc_size, FALSE, FALSE, 0);

  /*spinbutton1_adj = gtk_adjustment_new (737280000, 0, 999999999, 1, 10, 10);*/
  spinbutton1_adj = gtk_adjustment_new (700, 0, 2047, 1, 10, 10);
  spinbutton1 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton1_adj), 1, 0);
  gtk_widget_ref (spinbutton1);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "spinbutton1", spinbutton1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton1);
  gtk_box_pack_start (GTK_BOX (hbox10), spinbutton1, TRUE, TRUE, 0);

  hbox12 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox12);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox12", hbox12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox12);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox12, TRUE, TRUE, 0);

  label_calc_seconds = gtk_label_new (_(" Movie duration (minutes) "));
  gtk_widget_ref (label_calc_seconds);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "label_calc_seconds", label_calc_seconds,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_calc_seconds);
  gtk_box_pack_start (GTK_BOX (hbox12), label_calc_seconds, FALSE, FALSE, 0);

  spinbutton2_adj = gtk_adjustment_new (90, 0, 999999999, 1, 10, 10);
  spinbutton2 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton2_adj), 1, 0);
  gtk_widget_ref (spinbutton2);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "spinbutton2", spinbutton2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton2);
  gtk_box_pack_start (GTK_BOX (hbox12), spinbutton2, TRUE, TRUE, 0);

  hbox11 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox11);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox11", hbox11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox11);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox11, TRUE, TRUE, 0);

  label_calc_audio = gtk_label_new (_(" Audio (kBit) "));
  gtk_widget_ref (label_calc_audio);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "label_calc_audio", label_calc_audio,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_calc_audio);
  gtk_box_pack_start (GTK_BOX (hbox11), label_calc_audio, FALSE, FALSE, 0);

  spinbutton3_adj = gtk_adjustment_new (160, 0, 300, 1, 10, 10);
  spinbutton3 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton3_adj), 1, 0);
  gtk_widget_ref (spinbutton3);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "spinbutton3", spinbutton3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton3);
  gtk_box_pack_start (GTK_BOX (hbox11), spinbutton3, TRUE, TRUE, 0);

 hbox15 = gtk_hbox_new (FALSE, 0);
 gtk_widget_ref (hbox15);
 gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox15", hbox15,
 (GtkDestroyNotify) gtk_widget_unref);
 gtk_widget_show (hbox15);
 gtk_box_pack_start (GTK_BOX (vbox6), hbox15, TRUE, TRUE, 0);

 label_calc_width = gtk_label_new (_("Output Width  "));
 gtk_widget_ref (label_calc_width);
 gtk_object_set_data_full (GTK_OBJECT (dialog2), "label_calc_width", label_calc_width,
 (GtkDestroyNotify) gtk_widget_unref);
 gtk_widget_show (label_calc_width);
 gtk_box_pack_start (GTK_BOX (hbox15), label_calc_width, FALSE, FALSE, 0);

 spinbutton4_adj = gtk_adjustment_new (512, 0, 1024, 1, 10, 10);
 spinbutton4 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton4_adj), 1, 0);
 gtk_widget_ref (spinbutton4);
 gtk_object_set_data_full (GTK_OBJECT (dialog2), "spinbutton4", spinbutton4,
 (GtkDestroyNotify) gtk_widget_unref);
 gtk_widget_show (spinbutton4);
 gtk_box_pack_start (GTK_BOX (hbox15), spinbutton4, TRUE, TRUE, 0);

 hbox16 = gtk_hbox_new (FALSE, 0);
 gtk_widget_ref (hbox16);
 gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox16", hbox16,
 (GtkDestroyNotify) gtk_widget_unref);
 gtk_widget_show (hbox16);
 gtk_box_pack_start (GTK_BOX (vbox6), hbox16, TRUE, TRUE, 0);
 label_calc_height = gtk_label_new (_("Output Height  "));
 gtk_widget_ref (label_calc_height);
 gtk_object_set_data_full (GTK_OBJECT (dialog2), "label_calc_height", label_calc_height,
 (GtkDestroyNotify) gtk_widget_unref);
 gtk_widget_show (label_calc_height);
 gtk_box_pack_start (GTK_BOX (hbox16), label_calc_height, FALSE, FALSE, 0);

 spinbutton5_adj = gtk_adjustment_new (288, 0, 1024, 1, 10, 10);
 spinbutton5 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton5_adj), 1, 0);
 gtk_widget_ref (spinbutton5);
 gtk_object_set_data_full (GTK_OBJECT (dialog2), "spinbutton5", spinbutton5,
 (GtkDestroyNotify) gtk_widget_unref);
 gtk_widget_show (spinbutton5);
 gtk_box_pack_start (GTK_BOX (hbox16), spinbutton5, TRUE, TRUE, 0);

  hbox33 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox33);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox33", hbox33,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox33);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox33, TRUE, TRUE, 0);

  radiobutton7 = gtk_radio_button_new_with_label (hbox33_group, _("PAL"));
  hbox33_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton7));
  gtk_widget_ref (radiobutton7);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "radiobutton7", radiobutton7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton7);
  gtk_box_pack_start (GTK_BOX (hbox33), radiobutton7, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton7), TRUE);

  radiobutton8 = gtk_radio_button_new_with_label (hbox33_group, _("NTSC"));
  hbox33_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton8));
  gtk_widget_ref (radiobutton8);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "radiobutton8", radiobutton8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton8);
  gtk_box_pack_start (GTK_BOX (hbox33), radiobutton8, FALSE, FALSE, 0);


  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox6), hseparator1, TRUE, TRUE, 10);

  hbox14 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox14);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox14", hbox14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox14);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox14, TRUE, TRUE, 0);

  label_calc_bitrate = gtk_label_new (_(" Encoding bitrate "));
  gtk_widget_ref (label_calc_bitrate);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "label_calc_bitrate", label_calc_bitrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_calc_bitrate);
  gtk_box_pack_start (GTK_BOX (hbox14), label_calc_bitrate, FALSE, FALSE, 0);

  entry3 = gtk_entry_new ();
  gtk_widget_ref (entry3);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "entry3", entry3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry3);
  gtk_box_pack_start (GTK_BOX (hbox14), entry3, TRUE, TRUE, 0);
  gtk_entry_set_editable (GTK_ENTRY (entry3), FALSE);

  dialog_action_area4 = GNOME_DIALOG (dialog2)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog2), "dialog_action_area4", dialog_action_area4);
  gtk_widget_show (dialog_action_area4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area4), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area4), 8);

  gnome_dialog_append_button (GNOME_DIALOG (dialog2), GNOME_STOCK_BUTTON_OK);
  button8 = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog2)->buttons)->data);
  gtk_widget_ref (button8);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "button8", button8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button8);
  GTK_WIDGET_SET_FLAGS (button8, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog2), GNOME_STOCK_BUTTON_CLOSE);  button10 = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog2)->buttons)->data);
  gtk_widget_ref (button10);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "button10", button10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button10);
  GTK_WIDGET_SET_FLAGS (button10, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (radiobutton7), "toggled",
                      GTK_SIGNAL_FUNC (on_radiobutton_PAL_toggled),
                      radiobutton7);
  gtk_signal_connect (GTK_OBJECT (radiobutton8), "toggled",
                      GTK_SIGNAL_FUNC (on_radiobutton_NTSC_toggled),
                      radiobutton8);
  gtk_signal_connect (GTK_OBJECT (button8), "clicked",
                      GTK_SIGNAL_FUNC (on_button8_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button10), "clicked",
                      GTK_SIGNAL_FUNC (on_button10_clicked),
                      dialog2);

  return dialog2;
}


/* Create a new backing pixmap of the appropriate size */
static gint configure_event(GtkWidget *widget,GdkEventConfigure *event) {
  if (pixmap) gdk_pixmap_unref(pixmap);
  pixmap = gdk_pixmap_new(widget->window,widget->allocation.width,widget->allocation.height,-1);
  gdk_draw_rectangle (pixmap,widget->style->white_gc,TRUE,0, 0,widget->allocation.width,widget->allocation.height);
  return TRUE;
}


/* Redraw the screen from the backing pixmap */
static gint expose_event(GtkWidget *widget,GdkEventExpose *event) {
  gdk_draw_pixmap(widget->window,
          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
          pixmap,
          event->area.x, event->area.y,
          event->area.x, event->area.y,
          event->area.width, event->area.height);

  return FALSE;
}

/* Draw a rectangle on the screen */
static void draw_brush(GtkWidget *widget, gdouble x,gdouble y) {
  GdkRectangle update_rect;
  update_rect.x = (gint16)x;
  update_rect.y = (gint16)y;
  update_rect.width = 1;
  update_rect.height = 1;
  gdk_draw_rectangle (pixmap,
              widget->style->black_gc,
              TRUE,
              update_rect.x, update_rect.y,
              update_rect.width, update_rect.height);
  gtk_widget_draw (widget, &update_rect);
}

static gint button_press_event( GtkWidget      *widget,
                                GdkEventButton *event )
{
  if (event->button == 1 && pixmap != NULL)
    draw_brush (widget, event->x, event->y);

  return TRUE;
}

static gint motion_notify_event( GtkWidget *widget,
                                 GdkEventMotion *event )
{
  int x, y;
  GdkModifierType state;

  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x, &y, &state);
  else
    {
      x = (gint)event->x;
      y = (gint)event->y;
      state = (GdkModifierType)event->state;
    }

  if (state & GDK_BUTTON1_MASK && pixmap != NULL)
    draw_brush (widget, x, y);

  return TRUE;
}


GtkWidget*
create_clipping_dialog (void) {
  GtkWidget *clipping_dialog;
  GtkWidget *dialog_vbox6;
  GtkWidget *drawing_area;
  GtkWidget *dialog_action_area6;
  GtkWidget *button14;
  GtkWidget *button16;

  clipping_dialog = gnome_dialog_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (clipping_dialog), "clipping_dialog", clipping_dialog);

  dialog_vbox6 = GNOME_DIALOG (clipping_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (clipping_dialog), "dialog_vbox6", dialog_vbox6);
  gtk_widget_show (dialog_vbox6);

  drawing_area = gtk_drawing_area_new ();
  gtk_widget_ref (drawing_area);
  gtk_object_set_data_full (GTK_OBJECT (clipping_dialog), "drawingarea1", drawing_area,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (drawing_area);
  gtk_drawing_area_size (GTK_DRAWING_AREA (drawing_area), 200, 200);
  gtk_box_pack_start (GTK_BOX (dialog_vbox6), drawing_area, TRUE, TRUE, 0);

  /* Signals used to handle backing pixmap */

  gtk_signal_connect (GTK_OBJECT (drawing_area), "expose_event",
              (GtkSignalFunc) expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT(drawing_area),"configure_event",
              (GtkSignalFunc) configure_event, NULL);

  /* Event signals */

  gtk_signal_connect (GTK_OBJECT (drawing_area), "motion_notify_event",
              (GtkSignalFunc) motion_notify_event, NULL);
  gtk_signal_connect (GTK_OBJECT (drawing_area), "button_press_event",
              (GtkSignalFunc) button_press_event, NULL);

  gtk_widget_set_events (drawing_area, GDK_EXPOSURE_MASK
             | GDK_LEAVE_NOTIFY_MASK
             | GDK_BUTTON_PRESS_MASK
             | GDK_POINTER_MOTION_MASK
             | GDK_POINTER_MOTION_HINT_MASK);

  dialog_action_area6 = GNOME_DIALOG (clipping_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (clipping_dialog), "dialog_action_area6", dialog_action_area6);
  gtk_widget_show (dialog_action_area6);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area6), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area6), 8);

  gnome_dialog_append_button (GNOME_DIALOG (clipping_dialog), GNOME_STOCK_BUTTON_OK);
  button14 = GTK_WIDGET (g_list_last (GNOME_DIALOG (clipping_dialog)->buttons)->data);
  gtk_widget_ref (button14);
  gtk_object_set_data_full (GTK_OBJECT (clipping_dialog), "button14", button14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button14);
  GTK_WIDGET_SET_FLAGS (button14, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (clipping_dialog), GNOME_STOCK_BUTTON_CANCEL);
  button16 = GTK_WIDGET (g_list_last (GNOME_DIALOG (clipping_dialog)->buttons)->data);
  gtk_widget_ref (button16);
  gtk_object_set_data_full (GTK_OBJECT (clipping_dialog), "button16", button16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button16);
  GTK_WIDGET_SET_FLAGS (button16, GTK_CAN_DEFAULT);

  return clipping_dialog;
}

GtkWidget* create_stop_dialog(void) {
  GtkWidget *dialog3;
  GtkWidget *dialog_vbox7;
  GtkWidget *stop_text;
  GtkWidget *dialog_action_area7;
  GtkWidget *button_ok_stop;
  GtkWidget *button_no_stop;

  dialog3 = gnome_dialog_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (dialog3), "dialog3", dialog3);
  gtk_window_set_policy (GTK_WINDOW (dialog3), FALSE, FALSE, TRUE);
  gtk_window_set_title (GTK_WINDOW (dialog3), _("Drip - Stop"));

  dialog_vbox7 = GNOME_DIALOG (dialog3)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog3), "dialog_vbox7", dialog_vbox7);
  gtk_widget_show (dialog_vbox7);

  stop_text = gtk_label_new (_("\nStop encoding process?\n"));
  gtk_widget_ref (stop_text);
  gtk_object_set_data_full (GTK_OBJECT (dialog3), "stop_text", stop_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (stop_text);
  gtk_box_pack_start (GTK_BOX (dialog_vbox7), stop_text, FALSE, FALSE, 0);

  dialog_action_area7 = GNOME_DIALOG (dialog3)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog3), "dialog_action_area7", dialog_action_area7);
  gtk_widget_show (dialog_action_area7);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area7), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area7), 8);

  gnome_dialog_append_button (GNOME_DIALOG (dialog3), GNOME_STOCK_BUTTON_YES);
  button_ok_stop = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog3)->buttons)->data);
  gtk_widget_ref (button_ok_stop);
  gtk_object_set_data_full (GTK_OBJECT (dialog3), "button_ok_stop", button_ok_stop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ok_stop);
  GTK_WIDGET_SET_FLAGS (button_ok_stop, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog3), GNOME_STOCK_BUTTON_NO);
  button_no_stop = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog3)->buttons)->data);
  gtk_widget_ref (button_no_stop);
  gtk_object_set_data_full (GTK_OBJECT (dialog3), "button_no_stop", button_no_stop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_no_stop);
  GTK_WIDGET_SET_FLAGS (button_no_stop, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (button_ok_stop), "clicked",
                      GTK_SIGNAL_FUNC (on_button_ok_stop_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_no_stop), "clicked",
                      GTK_SIGNAL_FUNC (on_button_no_stop_clicked),
                      NULL);

  return dialog3;
}

