# 
# avi2svcd.sh    - Jarl van Katwijk 26-12-2002
#
# ./avi2svcd.sh input.avi 352x288 p 2 1


TEMPNAME="test"
INPUTNAME=$1
OUTPUT_RES=$2            # NTSC=352x240    PAL=352x288
INPUT_NORM=$3            # NTSC=n          PAL=p          SECAM=s
INPUT_ASPECT=$4          # 1:1=1           4:3=2          16:9=3       2.21:1=4
INPUT_FPS=$5             # 1=24000.0/1001.0 2=24.0 3=25.0 4=30000.0/1001.0 5=30.0 6=50.0  7=60000.0/1001.0  8=60.0


BITRATE=1381             # Total Bitrate
VIDEO_BITRATE=1121       # --------
AUDIO_BITRATE=112        # Bitrate of MP2 audio
RESERVE_BITRATE=120      # Bitrate to reserve for audio+other   / 125 ??

# -----------------------------------------------------------------------------------------------
# Cleanup
echo
echo "-0/6- CLEANING OLD FILES   ----------------------------------------------------------------"
chmod 600 $TEMPNAME.*
#rm $TEMPNAME.*
echo "-0/6- done."
# -----------------------------------------------------------------------------------------------



# -----------------------------------------------------------------------------------------------
# Decode DIVX to RAW
echo
echo "-1/6- DECODING AVI TO LAV+WAV   -----------------------------------------------------------"
time divxdec -f a -r -L $TEMPNAME-%02d.lav.avi -W $TEMPNAME.wav $INPUTNAME -q 70 -m 2000 2> $TEMPNAME.1.divxdecode.log
grep WARN $TEMPNAME.1.divxdecode.log
gzip $TEMPNAME.1.divxdecode.log
chmod 600 $TEMPNAME*.lav.avi
chmod 600 $TEMPNAME.wav
echo "-1/6- done."
# -----------------------------------------------------------------------------------------------


# -----------------------------------------------------------------------------------------------
# LAV to scaled and denoised YUV to encoded MPG1
echo
echo "-2/6- SCALING LAV -> ENCODING TO MPEG1   --------------------------------------------------"
echo "time  (lav2yuv -A 4:3 -P 4:3 $TEMPNAME-*.lav.avi 2> $TEMPNAME.2.lav2yuv.log) | (yuvscaler -n $INPUT_NORM -O SIZE_$OUTPUT_RES 2> $TEMPNAME.2.yuvscaler.log) | mpeg2enc -f 1 -b $VIDEO_BITRATE -r 16 -B $RESERVE_BITRATE -P -I 0 -V 230 -F $INPUT_FPS -a 2 -o $TEMPNAME.m1v" 2>> $TEMPNAME.2.mpeg2enc.log
time  (lav2yuv -A 4:3 -P 4:3 $TEMPNAME-*.lav.avi 2> $TEMPNAME.2.lav2yuv.log) | (yuvscaler -n $INPUT_NORM -O SIZE_$OUTPUT_RES 2> $TEMPNAME.2.yuvscaler.log) | mpeg2enc -f 1 -b $VIDEO_BITRATE -r 16 -B $RESERVE_BITRATE -P -I 0 -V 230 -F $INPUT_FPS -a 2 -o $TEMPNAME.m1v 2> $TEMPNAME.2.mpeg2enc.log
grep WARN $TEMPNAME.2.yuvscaler.log
grep WARN $TEMPNAME.2.lav2yuv.log
gzip $TEMPNAME.2.lav2yuv.log
gzip $TEMPNAME.2.yuvscaler.log
gzip $TEMPNAME.2.mpeg2enc.log
echo "-2/6- done."
# -----------------------------------------------------------------------------------------------



# -----------------------------------------------------------------------------------------------
# Extract and encode audio
echo
echo "-3/6- ENCODING AUDIO WAV TO MP2   ---------------------------------------------------------"
time cat $TEMPNAME.wav | mp2enc -b $AUDIO_BITRATE -r 44100  -o $TEMPNAME.mp2 2> $TEMPNAME.3.mp2enc.log
grep WARN $TEMPNAME.3.mp2enc.log
gzip $TEMPNAME.3.mp2enc.log
echo "-3/6- done."
# -----------------------------------------------------------------------------------------------



# -----------------------------------------------------------------------------------------------
# Multiplex Video+Audio into mpeg1 stream
echo
echo "-4/6- MULTIPLEXING AUDIO AND VIDEO   ------------------------------------------------------"
time mplex -f 1 -b 230 -r $BITRATE -o $TEMPNAME.mpg $TEMPNAME.mp2 $TEMPNAME.m1v 2> $TEMPNAME.4.mplex.log
grep -e WARN -e ERROR $TEMPNAME.4.mplex.log
gzip $TEMPNAME.4.mplex.log
echo "-4/6- done."
# -----------------------------------------------------------------------------------------------



# -----------------------------------------------------------------------------------------------
# Create SVCD bin\cue set
echo
echo "-5/6- CREATING VCD IMAGE   ----------------------------------------------------------------"
time vcdimager -t vcd2 -c $INPUTNAME.cue -b $INPUTNAME.bin $TEMPNAME.mpg > $TEMPNAME.5.vcdimager.log
gzip $TEMPNAME.5.vcdimager.log
echo "-5/6- done."
# -----------------------------------------------------------------------------------------------


# -----------------------------------------------------------------------------------------------
# Clean temp files
echo
echo "-6/6- REMOVING TEMPORARY FILES   ----------------------------------------------------------"
#rm $TEMPNAME*.lav.avi
#rm $TEMPNAME.mp2
#rm $TEMPNAME.m1v
#rm $TEMPNAME.mpg
echo "-6/6- done."
# -----------------------------------------------------------------------------------------------


