/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <math.h>
#include "scaler.hh"
#include "swscale.hh"
#include "main.hh"

#define FACTOR 1 // = factor of autoclipper -1

/* Globals */
//none


/* Loop 3 planes for zooming */
gboolean scaler_apply(gint sw,gint sh,gint dw,gint dh, guint8 *src[3], guchar *dest) {
    guint8 *destptr[3] = {dest,dest+(dw*dh),dest+(dw*dh)*5/4};
    gint stride[3] = {(sw+FACTOR)&(~FACTOR),((sw+FACTOR)&(~FACTOR))/2,((sw+FACTOR)&(~FACTOR))/2};
    
    /* Call MPlayer's software scaler */
    SwScale_YV12slice((unsigned char**)src,(int*)stride, 0, sh, destptr, dw, 12, sw, sh, dw, dh);

    return TRUE;
}


/* Initialize scalar, calculate lookup tables */
gboolean scaler_init(gint sw,gint sh,gint dw,gint dh) {

    /* Checks */
    if (dw>1023 || dh>1023) {
        g_log(DRIP_LD,G_LOG_LEVEL_ERROR,"Destination size >1023");
    }

    /* Calc tables */
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Calculating scaling tables (sw=%i,sh=%i,dw=%i,dh=%i)",sw,sh,dw,dh);
    SwScale_Init(); // MPlayer software scale init

    /* Clean & Exit */
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Scaling filter initialized");
    return TRUE;
}


