#!/usr/bin/env python

import reportbug, debianbts, getopt, sys

def main():
    system = 'debian'
    http_proxy = ''
    use_ldap = 0
    mirrors = None

    args = reportbug.parse_config_files()
    for option, arg in args.items():
        if option == 'system':
            system = arg
        elif option == 'ldap':
            use_ldap = arg
        elif option == 'mirrors':
            mirrors = arg
        elif option == 'http_proxy':
            http_proxy = arg

    try:
        (opts, args) = getopt.getopt(sys.argv[1:],
                                     'B:hlv', ['help', 'version', 'no-ldap',
                                                'bts=', 'ldap',
                                                'http_proxy=', 'proxy='])
    except getopt.error, msg:
        print msg
        sys.exit(1)

    for option, arg in opts:
        if option in ('-h', '--help'):
            print USAGE
            return
        elif option in ('-v', '--version'):
            print VERSION
            return
        elif option in ('--proxy', '--http_proxy'):
            http_proxy = arg
        elif option in ('-l', '--no-ldap'):
            use_ldap = 0
        elif option == '--ldap':
            use_ldap = 1
        elif option in ('-B', '--bts'):
            if arg in reportbug.SYSTEMS.keys():
                system = arg
            elif arg == 'help':
                print 'Permitted arguments to --bts:'
                names = reportbug.SYSTEMS.keys()
                names.sort()
                for bsys in names:
                    print ' %-11.11s %s' % \
                          (bsys, reportbug.SYSTEMS[bsys]['name'])
                return
            else:
                print "Ignoring unknown BTS server %s." % arg

    sysinfo = reportbug.SYSTEMS[system]
    
    package = 'e2fsprogs'

    try:
        (count, title, hierarchy) = debianbts.get_reports(package, system,
                                                          ldap_ok=1,
                                                          mirrors=mirrors,
                                                          http_proxy=http_proxy)

        print "%d bugs found in %s" % (count, package)
        
    except IOError:
        msgbox('Unable to connect to %s BTS.\n' % sysinfo['name'])

    return


try:
        main()
except KeyboardInterrupt:
        print "reportbug: exiting due to user interrupt."
