package Debbugs::RemoteBTS::LDAP;

@ISA = qw(Debbugs::RemoteBTS);

use Net::LDAP;
use Debbugs::BugReport;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {};
  
  my $server = shift;
  my %opts = ();
  while (@_) {
    my($k,$v) = splice(@_,0,2);
    $opts{$k} = $v;
  }

  $self->{SERVER} = $server;
  $self->{PORT} = $opts{port};
  $self->{DN} = $opts{dn};

  $self->{LDAP} = undef;

  bless ($self, $class);
  return $self;
}

sub connect {
  my $self = shift;

  unless (defined $self->{LDAP}) {
    $self->{LDAP} = Net::LDAP->new($self->{SERVER}, 
				   'port' => $self->{PORT}
				  );
    return undef unless defined $self->{LDAP};
    $self->{LDAP}->bind();
  }

  return $self->{LDAP};
}

sub DESTROY {
  $self->{LDAP}->unbind if defined $self->{LDAP};
}

sub bugFromID {
  my $self = shift;
  my ($bugid) = @_;

  # Query LDAP server
  $self->connect or return undef;
  my $date = time;
  my $result = $self->{LDAP}->search(
				     base => $self->{DN},
				     filter => "(bugid=$bugid)",
				    );

  # Build and return BugReport object
  return _entryToBug ($result->pop_entry, $date);
}

sub packageBugs {
  my $self = shift;
  my ($package) = @_;

  # Query LDAP server
  $self->connect or return undef;
  my $date = time;
  my $result = $self->{LDAP}->search(
				     base => $self->{DN},
				     filter => "(package=$package)"
				    );

  # Build and return list of BugReport object
  my @reportlist = ();
  foreach my $entry ($result->entries) {
    push @reportlist, _entryToBug ($entry, $date);
  }
  return @reportlist;
}

sub _entryToBug {
  my ($entry, $date) = @_;
  my $bugreport = Debbugs::BugReport->new;

  $bugreport->init_from_LDAP_entry ($entry);
  $bugreport->{DMBTATTRIBS}->{fetchdate} = $date;

  return $bugreport;
}

TRUE;
