/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/test_data_adaptor.ts.hpp
 *
 * @brief [LEVEL: beta] compliance test for @ref
 * diagnostics::unittest::Test_Data_Adaptor
 *
 * $Id: test_data_adaptor.ts.hpp,v 1.6 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/unittest/namespace.hpp>
#include <diagnostics/unittest/testing_namespaces.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

// used in the interface by reference
// diagnostics/unittest/test_system/test_data_adaptor.hpp
class Test_Data_Adaptor;

// used in the interface by reference
// diagnostics/unittest/test_data.hpp
class Test_Data;


TEST_NAMESPACE_BEGIN;
/**
 * @brief Compliance test for @ref Test_Data_Adaptor 
 */
class Test_Data_Adaptor_Compliance
{
private:
    typedef Test_Data_Adaptor_Compliance Self;
public:
    /**
     * @brief does not take ownership of @a adaptor
     *
     * @pre @a adaptor.backend()==NULL
     */
    Test_Data_Adaptor_Compliance(Test_Data_Adaptor * const adaptor);

    Test_Data_Adaptor_Compliance(Self const &);
    Self & operator=(Self const &);

    void operator()(Test_Data & test_data) const;
private:
    Test_Data_Adaptor * m_adaptor;
};


TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
