//
// C++ Interface: scorewizard
//
// Description: 
//
//
// Author: Adam Tee <adam@ajtee.plus.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SCOREWIZARD_H
#define SCOREWIZARD_H

#include <denemo/denemo.h>

/**
 * Paper setup callback data
 * 
 */
typedef struct headersetupcb
{
	GtkWidget *title;
	GtkWidget *subtitle;
	GtkWidget *poet;
	GtkWidget *composer;
	GtkWidget *meter;
	GtkWidget *opus;
	GtkWidget *arranger;
	GtkWidget *instrument;
	GtkWidget *dedication;
	GtkWidget *piece;
	GtkWidget *head;
	GtkWidget *copyright;
	GtkWidget *footer;
	GtkWidget *tagline;

}headersetupcb;


typedef struct papersetupcb
{
	GtkWidget *papersize;
	GtkWidget *lilyversion;
	GtkWidget *portrait;
	GtkWidget *fontsize;
}papersetupcb;

/**
 * Instrument setup callbackdata
 *
 */
typedef struct instsdata
{
	GList *instruments;
	GtkListStore *list_store;
}instsdata;

/**
 * Score setup callback data
 */
typedef struct scoresetup
{
  scoreinfo *si;
  papersetupcb *paper;
  instsdata *insts;
}scoresetup;

typedef struct scoredata
{
	GtkListStore **list_store;
	GtkTreeSelection *selection;
	GtkListStore *score_list;
}scoredata;

typedef struct wizarddata
{
	scoreinfo *si;
	GtkListStore *list_store;
	GList *instruments;
	GtkTreeIter iter;
   GtkWidget *notebook;
	GList *score_instruments;
	scoredata *sdata;
	papersetupcb *paper;
}wizarddata;




void scorewizard(GtkAction *action, scoreinfo *si);
void setpaperconfig(papersetupcb *cbdata, scoreinfo *si);
papersetupcb *papersetup(GtkWidget *notebook, scoreinfo *si, gboolean isnotebook); /* isnotebook should defaults to TRUE */
#endif
