/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * init_fnc.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: init_fnc.h,v 1.1 2003/12/26 14:31:52 uid68112 Exp $
*/

#ifndef __INIT_FNC_H__
#define __INIT_FNC_H__

/**************************************************************************************/
/* search in the given treemodel, in the given column a string matching the given one */
/**************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_string(GtkTreeModel *gtm, int column_number, const char *string, GtkTreeIter *iter);

/*********************************************************************************************************/
/* search in the given treemodel, in the given column a string matching the given one (case insensitive) */
/*********************************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_string_nocase(GtkTreeModel *gtm, int column_number, const char *string, GtkTreeIter *iter);

/*************************************************************************************/
/* search in the given treemodel, in the given column a value matching the given one */
/*************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_ulong(GtkTreeModel *gtm, int column_number, const unsigned long value, GtkTreeIter *iter);

/***************************************************/
/* check if the given gtk_tree_model contains rows */
/***************************************************/
/* output: TRUE: yes, FALSE: no, it is empty */
/*********************************************/
int gtk_tree_model_is_not_empty(GtkTreeModel *gtm);

void init_clist(void);

#endif
