/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * status.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/file.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <gnome.h>

#include "main.h"
#include "status.h"

int get_client_status(pid_t my_pid, unsigned long *array)
{
	int fd;
	unsigned long entry_local[NB_LONG_PER_ENTRY];

	unsigned long *entry;
	int ret=NOT_EXIST;

	if(array!=NULL)
		entry=array;
	else
		entry=&(entry_local[0]);
	
	fd=open(dctc_active_client_file->str,O_RDWR|O_CREAT,0644);
	if(fd==-1)
	{
		fprintf(stderr,"get_client_status: open %s\n",strerror(errno));
		return NOT_EXIST;
	}

	if(flock(fd,LOCK_EX)==-1)
	{
		fprintf(stderr,"get_client_status: flock %s\n",strerror(errno));
		close(fd);
		return NOT_EXIST;
	}

	for(;;)
	{
		int ln;

		ln=read(fd,entry,sizeof(entry_local));
		if(ln!=sizeof(entry_local))
			break;
			
		if(entry[0]==my_pid)
		{
			ret=entry[1];
			break;
		}
	}

	flock(fd,LOCK_UN);
	close(fd);
	return ret;
}

void del_client_status(pid_t my_pid)
{
	int fd;
	unsigned long entry[NB_LONG_PER_ENTRY];
	int cur_pos;
	int i;
	
	fd=open(dctc_active_client_file->str,O_RDWR|O_CREAT,0644);
	if(fd==-1)
	{
		fprintf(stderr,"del_client_status: open %s\n",strerror(errno));
		return;
	}

	if(flock(fd,LOCK_EX)==-1)
	{
		fprintf(stderr,"del_client_status: flock %s\n",strerror(errno));
		close(fd);
		return;
	}

	cur_pos=0;
	for(;;)
	{
		int ln;

		ln=read(fd,entry,sizeof(entry));
		if(ln!=sizeof(entry))
			break;
			
		if(entry[0]==my_pid)
		{
			lseek(fd,cur_pos,SEEK_SET);
			for(i=0;i<NB_LONG_PER_ENTRY;i++)
				entry[i]=0;
			if(write(fd,entry,sizeof(entry))!=sizeof(entry))
			{
				fprintf(stderr,"del_client_status: write %s\n",strerror(errno));
			}
			break;
		}
		cur_pos+=sizeof(entry);
	}

	flock(fd,LOCK_UN);
	close(fd);
	return;

}

