
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

/* string buffering for web interface */

#include "content.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <assert.h>



inline content *c_new(void)
{
	content *c = (content*)malloc(sizeof(content));
	if (!c)
		freakout("not enough memory for content struct in c_new()");

	c->pool = CONTENT_POOL_START;
	c->buf = (char*)malloc(CONTENT_POOL_START);
	if (!c->buf)
		freakout("not enough memory for content buffer in c_new()");

	c->buf[0] = 0;
	c->used = 0;

	return c;
}



void c_delete(content **c)
{
	free((*c)->buf);
	free(*c);
	*c = NULL;
}



inline void c_appendsl(content *c, const char *str, const int length)
{
	if (c->used + length+1 > c->pool)
	{
		if (c->used + length+1 - c->pool > CONTENT_POOL_GROW)
			c->pool = c->used + length+1 + CONTENT_POOL_GROW;
		else
			c->pool += CONTENT_POOL_GROW;

		c->buf = realloc(c->buf, c->pool);
		if (c->buf == NULL)
			freakout("realloc() failed in c_appends()");
	}
	memcpy(c->buf+c->used, str, length+1);
	c->used += length;
}



inline void c_appends(content *c, const char *str)
{
	c_appendsl(c,str,strlen(str));
}



void c_appendf(content *c, const char *format, ...)
{
	char buf[CONTENT_POOL_GROW];
	int len;
	va_list va;

	va_start(va, format);
	len = vsnprintf(buf, CONTENT_POOL_GROW-1, format, va);
	if (len == -1 || len > CONTENT_POOL_GROW-1)
		freakout("buffer overflow in c_append()");
	va_end(va);

	c_appendsl(c, buf, len);
}

