.\"
.\" ipptoolfile man page for CUPS.
.\"
.\" Copyright 2010-2014 by Apple Inc.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH ipptoolfile 5 "CUPS" "4 February 2015" "Apple Inc."
.SH NAME
ipptoolfile \- ipptool file format
.SH DESCRIPTION
The
.BR ipptool (1)
program accepts free-form plain text files that describe one or more IPP requests. Comments start with the "#" character and continue to the end of the line. Each request is enclosed by curly braces, for example:
.nf

    # This is a comment
    {
      # The name of the test
      NAME "Print PostScript File"

      # The request to send
      OPERATION Print\-Job
      GROUP operation\-attributes\-tag
      ATTR charset attributes\-charset utf\-8
      ATTR language attributes\-natural\-language en
      ATTR uri printer\-uri $uri
      ATTR name requesting\-user\-name $user
      FILE testfile.ps

      # The response to expect
      STATUS successful\-ok
      EXPECT job\-id OF\-TYPE integer WITH\-VALUE >0
      EXPECT job\-uri OF\-TYPE uri
    }
    {
      # The name of the test
      NAME "Get Attributes of PostScript Job"

      # The request to send
      OPERATION Get\-Job\-Attributes
      GROUP operation\-attributes\-tag
      ATTR charset attributes\-charset utf\-8
      ATTR language attributes\-natural\-language en
      ATTR uri printer\-uri $uri
      ATTR integer job\-id $job\-id
      ATTR name requesting\-user\-name $user

      # The response to expect
      STATUS successful\-ok
      EXPECT job\-id OF\-TYPE integer WITH\-VALUE $job\-id
      EXPECT job\-uri OF\-TYPE uri
      EXPECT job\-state OF\-TYPE enum WITH\-VALUE 3,4,5,6,7,8,9
      EXPECT job\-originating\-user\-name OF\-TYPE name WITH\-VALUE "$user"
    }
.fi
.SS TOP-LEVEL DIRECTIVES
The following directives can be used outside of a \fItest\fR:
.TP 5
\fB{ \fItest \fB}\fR
Defines a test.
.TP 5
\fBDEFINE \fIvariable-name value\fR
Defines the named variable to the given value. This is equivalent to specifying \fI\-d variable-name=value\fR on the
.BR ipptool (8)
command-line.
.TP 5
\fBDEFINE\-DEFAULT \fIvariable-name value\fR
Defines the named variable to the given value if it does not already have a value.
.TP 5
\fBFILE\-ID "\fIidentifier\fB"\fR
Specifies an identifier string for the current file.
.TP 5
\fBIGNORE\-ERRORS yes\fR
.TP 5
\fBIGNORE\-ERRORS no\fR
Specifies whether, by default,
.BR ipptool (8)
will ignore errors and continue with subsequent tests.
.TP 5
\fBINCLUDE "\fIfilename\fB"\fR
.TP 5
\fBINCLUDE <\fIfilename\fB>\fR
Includes another test file. The first form includes a file relative to the current test file, while the second form includes a file from the
.BR ipptool (8)
include directory.
.TP 5
\fBINCLUDE\-IF\-DEFINED \fIname \fB"\fIfilename\fB"\fR
.TP 5
\fBINCLUDE\-IF\-DEFINED \fIname \fB<\fIfilename\fB>\fR
Includes another test file if the named variable is defined. The first form includes a file relative to the current test file, while the second form includes a file from the
.BR ipptool (8)
include directory.
.TP 5
\fBINCLUDE\-IF\-NOT\-DEFINED \fIname \fB"\fIfilename\fB"\fR
.TP 5
\fBINCLUDE\-IF\-NOT\-DEFINED \fIname \fB<\fIfilename\fB>\fR
Includes another test file if the named variable is not defined. The first form includes a file relative to the current test file, while the second form includes a file from the
.BR ipptool (8)
include directory.
.TP 5
\fBSKIP\-IF\-DEFINED \fIvariable-name\fR
.TP 5
\fBSKIP\-IF\-NOT\-DEFINED \fIvariable-name\fR
Specifies that the remainder of the test file should be skipped when the variable is or is not defined.
.TP 5
\fBSTOP\-AFTER\-INCLUDE\-ERROR no\fR
.TP 5
\fBSTOP\-AFTER\-INCLUDE\-ERROR yes\fR
Specifies whether tests will be stopped after an error in an included file.
.TP 5
\fBTRANSFER auto\fR
Specifies that tests will, by default, use "Transfer-Encoding: chunked" for requests with attached files and "Content-Length:" for requests without attached files.
.TP 5
\fBTRANSFER chunked\fR
Specifies that tests will, by default, use the HTTP/1.1 "Transfer-Encoding: chunked" header. This is the default and is equivalent to specifying \fI\-c\fR on the
.BR ipptool (8)
command-line. Support for chunked requests is required for conformance with all versions of IPP.
.TP 5
\fBTRANSFER length\fR
Specifies that tests will, by default, use the HTTP/1.0 "Content-Length:" header. This is equivalent to specifying \fI\-l\fR on the
.BR ipptool (8)
command-line. Support for content length requests is required for conformance with all versions of IPP.
.TP 5
\fBVERSION 1.0\fR
.TP 5
\fBVERSION 1.1\fR
.TP 5
\fBVERSION 2.0\fR
.TP 5
\fBVERSION 2.1\fR
.TP 5
\fBVERSION 2.2\fR
Specifies the default IPP version number to use for the tests that follow.
.SS TEST DIRECTIVES
The following directives are understood within a \fItest\fR:
.TP 5
\fBATTR \fItag attribute-name value(s)\fR
Adds an attribute to the test request. Values are separated by the comma (",") character - escape commas using the "\" character. Common attributes and values are listed in the IANA IPP registry - see references below.
.TP 5
\fBATTR collection \fIattribute-name \fB{ MEMBER \fItag member-name value(s) ... \fB}\fR [ \fI... \fB,{ \fI... \fB} \fR]
Adds a collection attribute to the test request. Member attributes follow the same syntax as regular attributes and can themselves be nested collections. Multiple collection values can be supplied as needed, separated by commas.
.TP 5
\fBCOMPRESSION deflate\fR
.TP 5
\fBCOMPRESSION gzip\fR
.TP 5
\fBCOMPRESSION none\fR
Uses the specified compression on the document data following the attributes in a Print-Job or Send-Document request.
.TP 5
\fBDELAY \fIseconds\fR
Specifies a delay before this test will be run.
.TP 5
\fBDISPLAY \fIattribute-name\fR
Specifies that value of the named attribute should be output as part of the
test report.
.TP 5
\fBEXPECT \fIattribute-name \fR[ \fIpredicate(s) \fR]
.TP 5
\fBEXPECT ?\fIattribute-name predicate(s)\fR
.TP 5
\fBEXPECT !\fIattribute-name\fR
Specifies that the response must/may/must not include the named attribute. Additional requirements can be added as predicates - see the "EXPECT PREDICATES" section for more information on predicates. Attribute names can specify member attributes by separating the attribute and member names with the forward slash, for example "media\-col/media\-size/x\-dimension".
.TP 5
\fBEXPECT-ALL \fIattribute-name \fR[ \fIpredicate(s) \fR]
.TP 5
\fBEXPECT-ALL ?\fIattribute-name predicate(s)\fR
Specifies that the response must/may include the named attribute and that all occurrences of that attribute must match the given predicates.
.TP 5
\fBFILE filename\fR
Specifies a file to include at the end of the request. This is typically used when sending a test print file.
.TP 5
\fBGROUP tag\fR
Specifies the group tag for subsequent attributes in the request.
.TP 5
\fBIGNORE\-ERRORS yes\fR
.TP 5
\fBIGNORE\-ERRORS no\fR
Specifies whether
.BR ipptool (8)
will ignore errors and continue with subsequent tests.
.TP 5
\fBNAME "\fIliteral string\fB"\fR
Specifies the human-readable name of the test.
.TP 5
\fBOPERATION \fIoperation-code\fR
Specifies the operation to be performed.
.TP 5
\fBPAUSE "\fImessage\fB"\fR
Displays the provided message and waits for the user to press a key to continue.
.TP 5
\fBREQUEST\-ID \fInumber\fR\fR
.TP 5
\fBREQUEST\-ID random\fR
Specifies the request-id value to use in the request, either an integer or the word "random" to use a randomly generated value (the default).
.TP 5
\fBRESOURCE \fIpath\fR
Specifies an alternate resource path that is used for the HTTP POST request. The default is the resource from the URI provided to the
.BR ipptool (8)
program.
.TP 5
\fBSKIP\-IF\-DEFINED \fIvariable-name\fR
.TP 5
\fBSKIP\-IF\-NOT\-DEFINED \fIvariable-name\fR
Specifies that the current test should be skipped when the variable is or is not defined.
.TP 5
\fBSKIP\-PREVIOUS\-ERROR yes\fR
.TP 5
\fBSKIP\-PREVIOUS\-ERROR no\fR
Specifies whether
.BR ipptool (8)
will skip the current test if the previous test resulted in an error/failure.
.TP 5
\fBSTATUS \fIstatus-code \fR[ \fIpredicate\fR ]
Specifies an expected response status-code value. Additional requirements can be added as predicates - see the "STATUS PREDICATES" section for more information on predicates.
.TP 5
\fBTEST\-ID "\fIidentifier\fR"
Specifies an identifier string for the current test.
.TP 5
\fBTRANSFER auto\fR
Specifies that this test will use "Transfer-Encoding: chunked" if it has an attached file or "Content-Length:" otherwise.
.TP 5
\fBTRANSFER chunked\fR
Specifies that this test will use the HTTP/1.1 "Transfer-Encoding: chunked" header.
.TP 5
\fBTRANSFER length\fR
Specifies that this test will use the HTTP/1.0 "Content-Length:" header.
.TP 5
\fBVERSION 1.0\fR
.TP 5
\fBVERSION 1.1\fR
.TP 5
\fBVERSION 2.0\fR
.TP 5
\fBVERSION 2.1\fR
.TP 5
\fBVERSION 2.2\fR
Specifies the IPP version number to use for this test.
.SS EXPECT PREDICATES
The following predicates are understood following the \fBEXPECT\fR test directive:
.TP 5
\fBCOUNT \fInumber\fR
Requires the \fBEXPECT\fR attribute to have the specified number of values.
.TP 5
\fBDEFINE\-MATCH \fIvariable-name\fR
Defines the variable to "1" when the \fBEXPECT\fR condition matches. A side-effect of this predicate is that this \fBEXPECT\fR will never fail a test.
.TP 5
\fBDEFINE\-NO\-MATCH \fIvariable-name\fR
Defines the variable to "1" when the \fBEXPECT\fR condition does not match. A side-effect of this predicate is that this \fBEXPECT\fR will never fail a test.
.TP 5
\fBDEFINE\-VALUE \fIvariable-name\fR
Defines the variable to the value of the attribute when the \fBEXPECT\fR condition matches. A side-effect of this predicate is that this \fBEXPECT\fR will never fail a test.
.TP 5
\fBIF\-DEFINED \fIvariable-name\fR
Makes the \fBEXPECT\fR conditions apply only if the specified variable is defined.
.TP 5
\fBIF\-NOT\-DEFINED \fIvariable-name\fR
Makes the \fBEXPECT\fR conditions apply only if the specified variable is not defined.
.TP 5
\fBIN\-GROUP \fItag\fR
Requires the \fBEXPECT\fR attribute to be in the specified group tag.
.TP 5
\fBOF\-TYPE \fItag[,tag,...]\fR
Requires the \fBEXPECT\fR attribute to use one of the specified value tag(s).
.TP 5
\fBREPEAT\-LIMIT \fInumber\fR
.br
Specifies the maximum number of times to repeat if the \fBREPEAT-MATCH\fR or \fBREPEAT-NO-MATCH\fR predicate is specified. The default value is 1000.
.TP 5
\fBREPEAT\-MATCH\fR
.TP 5
\fBREPEAT\-NO\-MATCH\fR
Specifies that the current test should be repeated when the \fBEXPECT\fR condition matches or does not match.
.TP 5
\fBSAME\-COUNT\-AS \fIattribute-name\fR
Requires the \fBEXPECT\fR attribute to have the same number of values as the specified parallel attribute.
.TP 5
\fBWITH\-ALL\-HOSTNAMES "\fIliteral string\fB"\fR
.TP 5
\fBWITH\-ALL\-HOSTNAMES "/\fIregular expression\fB/"\fR
Requires that all URI values contain a matching hostname.
.TP 5
\fBWITH\-ALL\-RESOURCES "\fIliteral string\fB"\fR
.TP 5
\fBWITH\-ALL\-RESOURCES "/\fIregular expression\fB/"\fR
Requires that all URI values contain a matching resource (including leading /).
.TP 5
\fBWITH\-ALL\-SCHEMES "\fIliteral string\fB"\fR
.TP 5
\fBWITH\-ALL-SCHEMES "/\fIregular expression\fB/"\fR
Requires that all URI values contain a matching scheme.
.TP 5
\fBWITH\-ALL\-VALUES "\fIliteral string\fB"\fR
Requires that all values of the \fBEXPECT\fR attribute match the literal string. Comparisons are case-sensitive.
.TP 5
\fBWITH\-ALL\-VALUES <\fInumber\fR
.TP 5
\fBWITH\-ALL\-VALUES =\fInumber\fR
.TP 5
\fBWITH\-ALL\-VALUES >\fInumber\fR
.TP 5
\fBWITH\-ALL\-VALUES \fInumber\fR[\fI,...,number\fR]
Requires that all values of the \fBEXPECT\fR attribute match the number(s) or numeric comparison. When comparing rangeOfInteger values, the "<" and ">" operators only check the upper bound of the range.
.TP 5
\fBWITH\-ALL\-VALUES "false"\fR
.TP 5
\fBWITH\-ALL\-VALUES "true"\fR
Requires that all values of the \fBEXPECT\fR attribute match the boolean value given.
.TP 5
\fBWITH\-ALL\-VALUES "/\fIregular expression\fB/"\fR
Requires that all values of the \fBEXPECT\fR attribute match the regular expression, which must conform to the POSIX regular expression syntax. Comparisons are case-sensitive.
.TP 5
\fBWITH\-HOSTNAME "\fIliteral string\fB"\fR
.TP 5
\fBWITH\-HOSTNAME "/\fIregular expression\fB/"\fR
Requires that at least one URI value contains a matching hostname.
.TP 5
\fBWITH\-RESOURCE "\fIliteral string\fB"\fR
.TP 5
\fBWITH\-RESOURCE "/\fIregular expression\fB/"\fR
Requires that at least one URI value contains a matching resource (including leading /).
.TP 5
\fBWITH\-SCHEME "\fIliteral string\fB"\fR
.TP 5
\fBWITH\-SCHEME "/\fIregular expression\fB/"\fR
Requires that at least one URI value contains a matching scheme.
.TP 5
\fBWITH\-VALUE "\fIliteral string\fB"\fR
Requires that at least one value of the \fBEXPECT\fR attribute matches the literal string. Comparisons are case-sensitive.
.TP 5
\fBWITH\-VALUE <\fInumber\fR
.TP 5
\fBWITH\-VALUE =\fInumber\fR
.TP 5
\fBWITH\-VALUE >\fInumber\fR
.TP 5
\fBWITH\-VALUE \fInumber\fR[\fI,...,number\fR]
Requires that at least one value of the \fBEXPECT\fR attribute matches the number(s) or numeric comparison. When comparing rangeOfInteger values, the "<" and ">" operators only check the upper bound of the range.
.TP 5
\fBWITH\-VALUE "false"\fR
.TP 5
\fBWITH\-VALUE "true"\fR
Requires that at least one value of the \fBEXPECT\fR attribute matches the boolean value given.
.TP 5
\fBWITH\-VALUE "/\fIregular expression\fB/"\fR
Requires that at least one value of the \fBEXPECT\fR attribute matches the regular expression, which must conform to the POSIX regular expression syntax. Comparisons are case-sensitive.
.TP 5
\fBWITH\-VALUE\-FROM \fIattribute-name\fR
Requires that the value(s) of the \fBEXPECT\fR attribute matches the value(s) in the specified attribute.
For example, "EXPECT job\-sheets WITH\-VALUE\-FROM job\-sheets\-supported" requires that the "job\-sheets" value is listed as a value of the "job\-sheets\-supported" attribute.
.SS STATUS PREDICATES
The following predicates are understood following the \fBSTATUS\fR test directive:
.TP 5
\fBDEFINE\-MATCH \fIvariable-name\fR
Defines the variable to "1" when the \fBSTATUS\fR matches. A side-effect of this predicate is that this \fBSTATUS\fR will never fail a test.
.TP 5
\fBDEFINE\-NO\-MATCH \fIvariable-name\fR
Defines the variable to "1" when the \fBSTATUS\fR does not match. A side-effect of this predicate is that this \fBSTATUS\fR will never fail a test.
.TP 5
\fBIF\-DEFINED \fIvariable-name\fR
Makes the \fBSTATUS\fR apply only if the specified variable is defined.
.TP 5
\fBIF\-NOT\-DEFINED \fIvariable-name\fR
Makes the \fBSTATUS\fR apply only if the specified variable is not defined.
.TP 5
\fBREPEAT\-LIMIT \fInumber\fR
.br
Specifies the maximum number of times to repeat. The default value is 1000.
.TP 5
\fBREPEAT\-MATCH\fR
.TP 5
\fBREPEAT\-NO\-MATCH\fR
Specifies that the current test should be repeated when the response status-code matches or does not match the value specified by the STATUS directive.
.SS OPERATION CODES
Operation codes correspond to the hexadecimal numbers (0xHHHH) and names from RFC 2911 and other IPP extension specifications. Here is a complete list of names supported by
.BR ipptool (8):
.nf

    Activate\-Printer
    CUPS\-Accept\-Jobs
    CUPS\-Add\-Modify\-Class
    CUPS\-Add\-Modify\-Printer
    CUPS\-Authenticate\-Job
    CUPS\-Delete\-Class
    CUPS\-Delete\-Printer
    CUPS\-Get\-Classes
    CUPS\-Get\-Default
    CUPS\-Get\-Devices
    CUPS\-Get\-Document
    CUPS\-Get\-PPD
    CUPS\-Get\-PPDs
    CUPS\-Get\-Printers
    CUPS\-Move\-Job
    CUPS\-Reject\-Jobs
    CUPS\-Set\-Default
    Cancel\-Current\-Job
    Cancel\-Job
    Cancel\-Jobs
    Cancel\-My\-Jobs
    Cancel\-Subscription
    Close\-Job
    Create\-Job
    Create\-Job\-Subscriptions
    Create\-Printer\-Subscriptions
    Deactivate\-Printer
    Disable\-Printer
    Enable\-Printer
    Get\-Job\-Attributes
    Get\-Jobs
    Get\-Notifications
    Get\-Printer\-Attributes
    Get\-Printer\-Support\-Files
    Get\-Printer\-Supported\-Values
    Get\-Subscription\-Attributes
    Get\-Subscriptions
    Hold\-Job
    Hold\-New\-Jobs
    Identify\-Printer
    Pause\-Printer
    Pause\-Printer\-After\-Current\-Job
    Print\-Job
    Print\-URI
    Promote\-Job
    Purge\-Jobs
    Release\-Held\-New\-Jobs
    Release\-Job
    Renew\-Subscription
    Reprocess\-Job
    Restart\-Job
    Restart\-Printer
    Resubmit\-Job
    Resume\-Job
    Resume\-Printer
    Schedule\-Job\-After
    Send\-Document
    Send\-Hardcopy\-Document
    Send\-Notifications
    Send\-URI
    Set\-Job\-Attributes
    Set\-Printer\-Attributes
    Shutdown\-Printer
    Startup\-Printer
    Suspend\-Current\-Job
    Validate\-Document
    Validate\-Job
.fi
.SS STATUS CODES
Status codes correspond to the hexadecimal numbers (0xHHHH) and names from RFC 2911 and other IPP extension specifications. Here is a complete list of the names supported by
.BR ipptool (8):
.nf

    client\-error\-account\-authorization\-failed
    client\-error\-account\-closed
    client\-error\-account\-info\-needed
    client\-error\-account\-limit\-reached
    client\-error\-attributes\-not\-settable
    client\-error\-attributes\-or\-values\-not\-supported
    client\-error\-bad\-request
    client\-error\-charset\-not\-supported
    client\-error\-compression\-error
    client\-error\-compression\-not\-supported
    client\-error\-conflicting\-attributes
    client\-error\-document\-access\-error
    client\-error\-document\-format\-error
    client\-error\-document\-format\-not\-supported
    client\-error\-document\-password\-error
    client\-error\-document\-permission\-error
    client\-error\-document\-security\-error
    client\-error\-document\-unprintable\-error
    client\-error\-forbidden
    client\-error\-gone
    client\-error\-ignored\-all\-notifications
    client\-error\-ignored\-all\-subscriptions
    client\-error\-not\-authenticated
    client\-error\-not\-authorized
    client\-error\-not\-found
    client\-error\-not\-possible
    client\-error\-print\-support\-file\-not\-found
    client\-error\-request\-entity\-too\-large
    client\-error\-request\-value\-too\-long
    client\-error\-timeout
    client\-error\-too\-many\-subscriptions
    client\-error\-uri\-scheme\-not\-supported
    cups\-error\-account\-authorization\-failed
    cups\-error\-account\-closed
    cups\-error\-account\-info\-needed
    cups\-error\-account\-limit\-reached
    cups\-see\-other
    redirection\-other\-site
    server\-error\-busy
    server\-error\-device\-error
    server\-error\-internal\-error
    server\-error\-job\-canceled
    server\-error\-multiple\-document\-jobs\-not\-supported
    server\-error\-not\-accepting\-jobs
    server\-error\-operation\-not\-supported
    server\-error\-printer\-is\-deactivated
    server\-error\-service\-unavailable
    server\-error\-temporary\-error
    server\-error\-version\-not\-supported
    successful\-ok
    successful\-ok\-but\-cancel\-subscription
    successful\-ok\-conflicting\-attributes
    successful\-ok\-events\-complete
    successful\-ok\-ignored\-notifications
    successful\-ok\-ignored\-or\-substituted\-attributes
    successful\-ok\-ignored\-subscriptions
    successful\-ok\-too\-many\-events
.fi
.SS TAGS
Value and group tags correspond to the names from RFC 2911 and other IPP extension specifications. Here are the group tags:
.nf

    document\-attributes\-tag
    event\-notification\-attributes\-tag
    job\-attributes\-tag
    operation\-attributes\-tag
    printer\-attributes\-tag
    subscription\-attributes\-tag
    unsupported\-attributes\-tag
.fi
.LP
Here are the value tags:
.nf

    admin\-define
    boolean
    charset
    collection
    dateTime
    default
    delete\-attribute
    enum
    integer
    keyword
    mimeMediaType
    nameWithLanguage
    nameWithoutLanguage
    naturalLanguage
    no\-value
    not\-settable
    octetString
    rangeOfInteger
    resolution
    textWithLanguage
    textWithoutLanguage
    unknown
    unsupported
    uri
    uriScheme
.fi
.SS VARIABLES
The
.BR ipptool (8)
program maintains a list of variables that can be used in any literal string or attribute value by specifying "\fI$variable-name\fR". Aside from variables defined using the \fI-d\fR option or \fBDEFINE\fR directive, the following pre-defined variables are available:
.TP 5
\fB$$\fR
Inserts a single "$" character.
.TP 5
\fB$ENV[\fIname\fB]\fR
Inserts the value of the named environment variable, or an empty string if the environment variable is not defined.
.TP 5
\fB$filename\fR
Inserts the filename provided to
.BR ipptool (8)
with the \fI-f\fR option.
.TP 5
\fB$filetype\fR
Inserts the MIME media type for the filename provided to
.BR ipptool (8)
with the \fI-f\fR option.
.TP 5
\fB$hostname\fR
Inserts the hostname from the URI provided to
.BR ipptool (8).
.TP 5
\fB$job\-id\fR
Inserts the last "job\-id" attribute value returned in a test response or 0 if no "job\-id" attribute has been seen.
.TP 5
\fB$job\-uri\fR
Inserts the last "job\-uri" attribute value returned in a test response or an empty string if no "job\-uri" attribute has been seen.
.TP 5
\fB$notify\-subscription\-id\fR
Inserts the last "notify\-subscription\-id" attribute value returned in a test response or 0 if no "notify\-subscription\-id" attribute has been seen.
.TP 5
\fB$port\fR
Inserts the port number from the URI provided to
.BR ipptool (8).
.TP 5
\fB$resource\fR
Inserts the resource path from the URI provided to
.BR ipptool (8).
.TP 5
\fB$scheme\fR
Inserts the scheme from the URI provided to
.BR ipptool (8).
.TP 5
\fB$uri\fR
Inserts the URI provided to
.BR ipptool (8).
.TP 5
\fB$uriuser\fR
Inserts the username from the URI provided to
.BR ipptool (8),
if any.
.TP 5
\fB$user\fR
Inserts the current user's login name.
.SH SEE ALSO
.BR ipptool (1),
CUPS Online Help (http://localhost:631/help),
IANA IPP Registry (http://www.iana.org/assignments/ipp-registrations),
PWG Internet Printing Protocol Workgroup (http://www.pwg.org/ipp),
RFC 2911 (http://tools.ietf.org/html/rfc3911)
.SH COPYRIGHT
Copyright \[co] 2007-2016 by Apple Inc.
