#!/usr/bin/env python
# -*- Mode: python -*-
#
# Copyright (C) 2002-2003 Mark Ferrell <xrxgrok@yahoo.com>
#
# -----------------------------------------------------------------------
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
# -----------------------------------------------------------------------

synonyms = ['lo']
summary  = """Print out history information for files"""
usage = """Usage: cscvs log [-hNb] [-P[[branch.]changeset]] [-d dates] [-w[authors]] [files...]
	-h		Only print header.
	-N		Do not list tags.
	-b		Only list revisions on the default branch.
	-P[branch.][changeset]
			Specify branch and changeset(s) to list.
			Branch specification not compatible with branch-
			based changeset syntaxes below.
	   cset1:cset2	Between set1 and set2, including set1 and set2.
	   cset1::cset2	Between set1 and set2, excluding set1 and set2.
	   cset:	set and following changesets on the same branch.
	   set::	After set on the same branch.
	   :cset	set and previous changesets on the same branch.
	   ::cset	Before set on the same branch.
	   cset		Just set
	   branch	All changesets on the branch.
	   branch.	The last changeset on the branch.
	-d dates	Specify dates (D1<D2 for range, D for latest before).
	-w[authors]	Only list changesets checked in by specified author."""

def display_changeset(display, changeset):
	import sys
	import StorageLayer
	SCM = StorageLayer.convertingImport('SCM')
	CVS = StorageLayer.convertingImport('CVS')

	print "ChangeSet: %d" % changeset.index
	print "Author: %s" % changeset.author
	stime, etime = changeset.time
	print "Date: %s" % CVS.time(stime)
	print "Branch: %s" % changeset.branchName

	if display.tags:
		if changeset.tags:
			sys.stdout.write("Tags:")
			for tag in changeset.tags:
				sys.stdout.write(" %s" % tag)
			sys.stdout.write("\n")

        if display.logs:
		print "Revisions:"
		for rev in changeset.getAllNewRevisions():
			file = rev.filename
			if rev.type == SCM.Revision.Revision.ADD or \
			  (rev.type == SCM.Revision.Revision.CHANGE and
			   rev.predecessor != None and
			   rev.predecessor.type in (SCM.Revision.Revision.PLACEHOLDER,
			                            SCM.Revision.Revision.REMOVE)):
				print "\t%s [%s] [new]" % (file, rev.revision)
			elif rev.type == SCM.Revision.Revision.REMOVE:
				print "\t%s [%s] [removed]" % (file, rev.revision)
			elif rev.type == SCM.Revision.Revision.CHANGE:
				print "\t%s [%s] +%d-%d" % (file, rev.revision, rev.addcount, rev.delcount)
			elif rev.type == SCM.Revision.Revision.PLACEHOLDER:
				pass
			else:
				print "\t%s [%s] [unknown]" % (file, rev.revision)
		
		print "\n%s\n" % changeset.log
	print "==================================="

def log(config):
	from RangeArgParser import RangeArgParser
	import StorageLayer
	import getopt
	SCM = StorageLayer.convertingImport('SCM')
	CVS = StorageLayer.convertingImport('CVS')

	catalog = SCM.Catalog.Catalog(config)

	class DisplayConfig(RangeArgParser):
		def __init__(self, catalog):
			super(DisplayConfig, self).__init__(catalog)
			self.logs=1
			self.tags=1
			self.defaultAllChangesets=True
	display = DisplayConfig(catalog)

	opts, args = getopt.getopt(config.args, 'hNP:d:b:w:')

	for opt, val in opts:
		if opt == '-h':
			display.logs = 0
		elif opt == '-b':
			display.branch = val
		elif opt == '-N':
			display.tags = 0
		elif opt == '-P':
			if display.parseArg(val): continue
		elif opt == '-d':
			raise ValueError("the -d option is currently not implemented")
		elif opt == '-w':
			display.authors.append(val)
		else:
			raise CVS.Usage

	for changeset in display.getChangesetIterator():
		display_changeset(display, changeset)

	catalog.close()


if __name__ == '__main__':
	import sys, os
	sys.path.append('modules')
	import CVS

	config = CVS.Config(os.path.curdir())
	config.cmd = 'log'
	config.args = sys.args[1:]
	config.cat_path = os.path.join(config.topdir, "CVS/Catalog.sqlite")
	try:	log(config)
	except CVS.Usage:
		sys.stderr.write("%s\n" % usage)
		sys.exit(1)

# tag: Mark Ferrell Mon Jun  2 14:28:33 CDT 2003 (cmds/log.py)
#
