/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _RECIPIENTS_DLG_HH_
#define _RECIPIENTS_DLG_HH_

#include <wx/wx.h>
#include <wx/listctrl.h>

#include "CryptonitDlg.hh"
#include "../User.hh"

class RecipientsDlg : public CryptonitDlg{
  
public :
    RecipientsDlg(wxWindow *parent, wxWindowID id,
		  Cryptonit::User *u,
		  const wxString &title=_T(""),
		  const bool s = false);
    
    ~RecipientsDlg();
    void addRecipient(wxCommandEvent &WXUNUSED(event));
    void removeRecipient(wxCommandEvent &WXUNUSED(event));
    void addRecipient2(wxListEvent &WXUNUSED(event));
    void removeRecipient2(wxListEvent &WXUNUSED(event));
    std::vector<wxString>* getRecipientList();
    void fillAvailableRecipients();
    void fillAvailableSigners();
    void enableAddBtn(wxListEvent &WXUNUSED(event));
    void enableRemoveBtn(wxListEvent &WXUNUSED(event));
    void disableAddBtn(wxListEvent &WXUNUSED(event));
    void disableRemoveBtn(wxListEvent &WXUNUSED(event));
    wxString getRecipient();

private:

    Cryptonit::User *user;
    
    wxBitmapButton *add;
    wxBitmapButton *remove;
    
    wxListCtrl *availableRecipients;
    wxListCtrl *selectedRecipients;
    


    bool signer;
    
    DECLARE_EVENT_TABLE()
	
	};

enum
  {
    RECDLG_ADD_BTN = 4000,
    RECDLG_REMOVE_BTN,
    RECDLG_AVAILABLE_LIST,
    RECDLG_SELECTED_LIST
  };

#endif
