/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _LDAP_HH_
#define _LDAP_HH_

#include "DirectoryService.hh"

#define LDAP_DEPRECATED 1

#include <ldap.h>

#ifndef LDAP_DEFAULT_PORT
#define LDAP_DEFAULT_PORT 389
#endif

namespace Cryptonit
{

   /** 
    * Class dealing with the distant LDAP containing certificates
    * 
    * @param host 
    * @param port 
    * 
    * @return 
    */
   class ldap: public DirectoryService
   {
      private:

	 LDAP* ldap_session;

	 // Timeout in seconds for asynchronous search
	 unsigned int timeout;


	 std::string current_host;
	 unsigned int current_port;
	 std::string current_base;
         int v2compatibility;

	 // Scope type for search
	 int current_scope;

        LDAP* init_ldap_session( const std::string host, int port, int v2compatibility );
	 bool add_entry( LDAP* ld, LDAPMessage *entry );

      public:
	 ldap();
	 ldap( const std::string uri );

	 /** 
	  * Connection to the ldap
	  * 
	  * @param params to be sent to the ldap
	  * 
	  * @return true if connection established
	  */
	 bool bind( const std::string params[] );

	 /** 
	  * throw a research on the ldap amount of data
	  * 
	  * @param exp the expression searched
	  * 
	  * @return true if expression found
	  */
	 bool findExpression( const std::string exp );

	 /** 
	  * getting information from the ldap
	  * 
	  * @param name the entry searched
	  * 
	  * @return data returned
	  */
	 Entry* getEntry( const std::string name );


	 unsigned int getTimeout();
	 void setTimeout( unsigned int t );


	 /** 
	  * getting the way of research
	  * 
	  * 
	  * @return 
	  */
	 int getScope();

         /** 
	  * getting if we should use ldapv2
	  * 
	  * 
	  * @return 
	  */
         unsigned int retainLDAPv2();
         void retainLDAPv2(int b);
     

	 /** 
	  * selection of the technic of research
	  * 
	  * @param s const representing the new scope
	  *            - LDAP_SCOPE_BASE
	  *            - LDAP_SCOPE_BASE
	  *            - LDAP_SCOPE_ONELEVEL
	  *            - LDAP_SCOPE_ONELEVEL
	  *            - LDAP_SCOPE_SUBTREE
	  *
	  */
	 void setScope( int s );
	 void setScope( const std::string s );
   };

} // Namespace

#endif
