/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _AuthoritiesDB_hh
#define _AuthoritiesDB_hh



#include <vector>
#include <string>
#include <iostream>

#include "DirectoryService.hh"


#define AUTHORITIESDB_DEFAULT_FILENAME "Authorities.conf"
#define AUTHORITIESDB_DEFAULT_PATH     "CA"

namespace Cryptonit 
{

    /** Database containing authorities' certificate
     *
     */
    class AuthoritiesDB
    {
	
    private :
	
	/** The Authorities Database itself */
	DirectoryService* authorities;
       
	/** Conatains the current AuthoritiesDB URI */
	std::string currentURI;
    
    public:


	/** Constructs an empty AuthoritiesDB
	 *
	 */
	AuthoritiesDB();
	

	/** Constructs an AuthoritiesDB from a given URI.
	 *  The backend is determined by the 'scheme' part of the URI.
	 */
	AuthoritiesDB( const std::string uri );


	/** Destructs this AuthoritiesDB
	 *
	 */
	~AuthoritiesDB();
    

	/** Write the Authorities database on disk.
	 *  If no filename is specified write to the file which
	 *  it was loaded.
	 *
	 *  @param fileName : the authorities databse filename
	 *  @return true if the operation succeed.
	 */
	bool save( const std::string fileName = "" );


	/** Add an authority in the authorities database.
	 *  @return true if the operation succeed.
	 *
	 * @param authority : the authority to add.
	 *
	 */
	bool addAuthority( std::string name, std::string certFilename );
    

	/** Removes an authority in the authorities database.
	 *  @return true if the operation succeed.
	 *
	 * @param name : the authority to remove.
	 *
	 */
	bool removeAuthority( const std::string name );
    

	/** Return an authority specifief by its name.
	 *  @return the corresponding authority, NULL if it 
	 *          does not exists.
	 *
	 *  @param name : authority name
	 */
	//Authority* getAuthority( const std::string name );

	Entry* getAuthority( const std::string name );


	std::vector<std::string>* getAllAuhtorityName();


	/** Returns a specified authority information, if there is more than
	 *  one value, the first is returned.
	 *  @return authority information if it exists.
	 *
	 *  @param name : authority name
	 *  @param infoName : information name
	 */
	std::string getAuthorityInfo( const std::string name, const std::string infoName );


	/** Returns a specified authority informations, all values are returned
	 *  in form of a vector.
	 *  @return authority informations if it exists.
	 *
	 *  @param name : authority name
	 *  @param infoName : information name
	 */
	std::vector<std::string> getAuthorityInfos( const std::string name, const std::string infoName );


	bool setInfo( const std::string name, const std::string infoName, const std::string value );
	bool setInfos( const std::string name, const std::string infoName, const std::vector<std::string> values );
	
    };
}
#endif
