/* This program reads a .wav file and gives the location (in byte sample
 * numbers) of the last strong (non-zero) sample.  So this will basically
 * return the byte-position of the last non-zero sample of the file.
 * It gives the position with respect to the beginning of the file and
 * does NOT take into account the 44-byte wav header.  In other words if
 * the last sample of the file is non-zero,  the program will basically
 * return the same number as the size of the file.
 * Useful for using in conjunction with sox -e trim to trim off beginning
 * silence from a .wav file.
 *
 * Returns offset from the beginning of the file (note the difference
 *  from wav_find_beginning) to the end of the non-zero data.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
FILE *f1;
unsigned short ch0, ch1;
int val = 0, threshold = 0;
long pos;

if (argc != 2)
{
        printf("Usage: wav_find_end <in.file>\n");
        exit(-1);
}
if ((f1=fopen(argv[1], "r")) == NULL)
{
        printf("wav_find_end: Unable to open %s.\n", argv[1]);
        exit(-1);
}

/* Skip to the end of the file */
pos = -2;
ch0 = 0;  ch1 = 0;
while (abs(val) <= threshold) {
	fseek(f1, pos, SEEK_END);
	ch0 = getc(f1);  ch1 = getc(f1);
	pos -= 2;
	val = ((int)ch0);
	val = val << 8;
	val = val | (int)ch1;
/* printf("%ld %d\n", pos, val); */
}

/* pos += 2; */
pos = ftell(f1);

fclose(f1);

printf("%ld\n", pos);

}


