/*
 *  Copyright (C) 2003,2004  Rene Rebe <rene@rocklinux.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Based upon the acpi version:
 *    Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                  George Staikos <staikos@0wned.org>
 */
#include "libsys.h"

int tokenize (FILE *fp, char *t, char *v);
  
char info_file[255];
char bat_file[255];
char tag[255];
char val[255];
char version[101];
int bat_num = 0;
static int err = 0;

int tokenize (FILE *fp, char *t, char *v) {
  char str[255];
  char *s1, *s2;

  t[0] = v[0] = 0;

  if (fgets(str, 255, fp) == NULL)
    return EOF;

  if ((s1 = strtok(str, ":")) == NULL)
    return 0;

  s2 = s1 + strlen (s1) - 1;
  /* remove trailing spaces */
  for ( ; s1 != s2 ; --s2)
    if ( *s2 != ' ')
      break;
    else
      *s2 = 0;
  strncpy (t, s1, 255);
  t[254] = 0;

  if ((s1 = strtok(NULL, ":")) == NULL)
    return 0;

  for ( ; *s1 != 0 ; ++s1)
    if ( *s1 != ' ')
      break;

  strncpy (v, s1, 255);
  v[254] = 0;

  return 1;
}

/* void libsys_init(void)
 *
 * Initialize local variables.
 */
int libsys_init(void) {
  
  FILE *fp;

  snprintf(info_file, 255, "%s/info", PMU_PROC_DIR);
  snprintf(bat_file, 255, "%s/battery_0", PMU_PROC_DIR); 
 
  fp = fopen(info_file, "r");
  if (!fp) {
    cp_log(LOG_ERR, "libsys_init(): %s: %s\n", info_file, strerror(errno));
    err++;
    return -1;
  }

  while (tokenize(fp, tag, val) != EOF) {

    if (strcmp (tag, "PMU driver version") == 0) {
      sprintf (version, "%s - ", val);
    } 
    else if (strcmp (tag, "PMU firmware version") == 0) {
      strncat (version, val, 100-strlen(version));
    }
  } 
  fclose(fp);

  cp_log(LOG_NOTICE, "libsys_init(): PMU driver/firmware version %s\n", version);

  return 0;
}

/* void libsys_fini (void)
 *
 * Free allocated structures.
 */

void libsys_fini (void) {}

/* int scan_system_info(sys_info *s) 
 *
 * Reads PMU info and fills the input sys_info struct.
 * Implements the prototype needed by cpufreqd to get
 * info from the PM layer.
 * 
 * Returns 0 on success, -1 otherwise
 *
 */
int scan_system_info(sys_info *s) {

  FILE *fp;

  float bat_charge = .0;
  float bat_max_charge = .0;
  
  /* check if _init was successful */
  if (err>0)
    return -1;
  
  /* set version information */
  strncpy(s->version, version, 101);
  s->version[100] = 0;
 
  /** /proc/pmu/info **/
  fp = fopen(info_file, "r");
  if (!fp) {
    cp_log(LOG_ERR, "libsys_init(): %s: %s\n", info_file, strerror(errno));
    err++;
    return -1;
  }

  while (tokenize(fp, tag, val) != EOF) {

    if (strcmp (tag, "AC Power") == 0) {
      s->ac = atoi (val); 
    }
    else if (strcmp (tag, "Battery count") == 0) {
      s->has_battery = atoi (val); 
    }
  }
  fclose(fp);

 
  /** /proc/pmu/battery_0 **/
  fp = fopen(bat_file, "r");
  if (!fp) {
    cp_log(LOG_ERR, "scan_system_info(): %s: %s\n", bat_file, strerror(errno));
    return -1;
  }

  while (tokenize(fp, tag, val) != EOF) {
    if (strcmp (tag, "charge") == 0) {
      bat_charge = atof (val); 
    }
    else if (strcmp (tag, "max_charge") == 0) {
      bat_max_charge = atof (val);
    }
  }
  fclose(fp);

  s->battery_percent = 100 * (bat_charge / bat_max_charge);

  cp_log(LOG_INFO, "scan_system_info(): battery %s - %d - %s\n",
                    s->has_battery?"present":"absent", 
                    s->battery_percent, 
                    s->ac?"on-line":"off-line");
  return 0;
}

#ifdef DEBUG_PMU
int main ()
{
  sys_info info;

  libsys_init();
  scan_system_info (&info);
  return 0;
}
#endif

