/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  2004.08.19
 *  - fixed /proc/stat reads in 2.6 kernels by Holger Ruckdeschel
 *  - detect kernel version (usefull??) by Mattia Dongili
 * 
 *  2003.16.08
 *  - added support for cpu monitoring, base code by Dietz Proepper and minor
 *    fixes by Mattia Dongili
 *    
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "libsys.h"

void libsys_preinit(void (*in_log) (const int prio, const char *fmt, ...), general *config);

static unsigned int old_weighted_activity = 0,
                    old_time = 0;

static int get_kversion(void) {
  FILE *fp;
  char kver[256];
  int f = 0;
  
  fp = fopen ("/proc/version", "r");
  if (!fp) {
    cp_log(LOG_ERR, "get_kversion(): %s: %s\n", "/proc/version", strerror(errno));
    return -1;
  }
  do {
    f = fscanf (fp, "Linux version %s", kver);
  } while (f != 1);
  fclose(fp);
  kver[255] = '\0';

  cp_log(LOG_INFO, "get_kversion(): read kernel version %s.\n", kver);
  
  if (strstr(kver, "2.6") == kver) {
    cp_log(LOG_INFO, "get_kversion(): kernel version is 2.6.\n");
    return KVER_26;
  } else if (strstr(kver, "2.4") == kver) {
    cp_log(LOG_INFO, "get_kversion(): kernel version is 2.4.\n");
    return KVER_24;
  } else {
    cp_log(LOG_WARNING, "Unknown kernel version let's try to continue assuming a 2.6 kernel.\n");
    return KVER_26;
  }

}

void libsys_preinit ( void (*in_log) (const int prio, const char *fmt, ...), general *config ) {
  cp_log = in_log;
  configuration = config;
  config->kver = get_kversion();
  cp_log(LOG_INFO, "libsys_preinit(): pre-initialization done.\n");
}

/*
int get_cpu(sys_info *si) {
*/
int get_cpu(void) {
  FILE* fp;
  int f;
  unsigned int c_user, c_nice, c_sys, c_time, delta_time, delta_activity, weighted_activity, perc;
  unsigned long int c_idle;
  unsigned long int c_iowait=0, c_irq=0, c_softirq=0; /* for linux 2.6 only */

  /* read raw jiffies... */
  fp = fopen ("/proc/stat", "r");
  if (!fp) {
    cp_log(LOG_ERR, "get_cpu(): %s: %s\n", "/proc/stat", strerror(errno));
    return -1;
  }
  do {
    f = fscanf (fp,
                "cpu  %u %u %u %lu %lu %lu %lu",
                &c_user, &c_nice, &c_sys, &c_idle, &c_iowait, &c_irq, &c_softirq);

  } while ((f!=4 && configuration->kver==KVER_24) || (f!=7 && configuration->kver==KVER_26));
  fclose(fp);

  cp_log(LOG_DEBUG,
         "get_cpu(): CPU c_user=%d c_nice=%d c_sys=%d c_idle=%d c_iowait=%d c_irq=%d c_softirq=%d.\n",
         c_user, c_nice, c_sys, c_idle, c_iowait, c_irq, c_softirq);
  /* calculate total jiffies, weight them and save */
  c_sys += c_irq + c_softirq;
  c_idle += c_iowait;
  c_time = c_user + c_nice + c_sys + c_idle;
  delta_time = c_time - old_time;
  old_time = c_time;

  /*
  si->cur_sys_activity = c_user + c_sys;
  si->cur_nice_activity = c_nice;
  */

  weighted_activity = c_user + c_nice / 3 + c_sys;
  delta_activity = weighted_activity - old_weighted_activity;
  old_weighted_activity = weighted_activity;

  cp_log(LOG_DEBUG,
         "get_cpu(): CPU delta_activity=%d delta_time=%d weighted_activity=%d.\n",
         delta_activity, delta_time, weighted_activity);

  if ( delta_activity > delta_time || delta_time <= 0) {
    perc = 100;
  } else {
    perc = delta_activity * 100 / delta_time;
  }
  cp_log(LOG_INFO, "get_cpu(): CPU usage = %d.\n", perc);

  return perc;
}
