/* pixmap.c - creates XImages and pixmaps from XPM formats
   Copyright (C) 1996-2000 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#include "coolwidget.h"
#include "mad.h"

extern struct look *look;

XImage *CCreateImage (const char *data[], int width, int height, char start_char)
{
    XImage *image;
    int bpp, x, y, u;

    if (CDepth <= 8) {
	bpp = 1;
    } else if (CDepth <= 16) {
	bpp = 2;
    } else {
	bpp = 4;
    }

    if (width & 1)
	u = 8;
    else if (width & 2)
	u = 16;
    else
	u = 32;
    
    image = XCreateImage (CDisplay, CVisual, CDepth, ZPixmap,
    		0, CMalloc (width * height * bpp), width, height, u, 0);
    if (!image)
	return 0;

    for (y = 0; y < height; y++)
	for (x = 0; x < width; x++) {
	    if (data[y][x] == ' ')
		XPutPixel (image, x, y, COLOR_FLAT);
	    else
		XPutPixel (image, x, y, color_pixels[data[y][x] - start_char]);
	}
    return image;
}

XImage *CCreateMaskImage (const char *data[], int width, int height, char backing_char)
{
    XImage *image;
    int x, y;
    image = XCreateImage (CDisplay, CVisual, 1, ZPixmap,
			  0, CMalloc (width * height), width, height, 32, 0);
    if (!image)
	return 0;
    for (y = 0; y < height; y++)
	for (x = 0; x < width; x++) {
	    if (data[y][x] == backing_char)
		XPutPixel (image, x, y, 1);
	    else
		XPutPixel (image, x, y, 0);
	}
    return image;
}

Pixmap CCreateClipMask (const char *data[], int width, int height, char backing_char)
{
    Pixmap pixmap;
    XImage *image;
    XGCValues gcv;
    GC gc;
    image = CCreateMaskImage (data, width, height, backing_char);
    if (!image)
	return 0;
    pixmap = XCreatePixmap (CDisplay, CRoot, width, height, 1);
    gc = XCreateGC (CDisplay, pixmap, 0, &gcv);
    XPutImage (CDisplay, pixmap, gc, image, 0, 0, 0, 0, width, height);
    XFreeGC (CDisplay, gc);
    free (image->data);
    image->data = 0;
    XDestroyImage (image);
    return pixmap;
}

Pixmap CCreatePixmap (const char *data[], int width, int height, char start_char)
{
    Pixmap pixmap;
    XImage *image;
    image = CCreateImage (data, width, height, start_char);
    if (!image)
	return 0;
    pixmap = XCreatePixmap (CDisplay, CRoot, width, height, CDepth);
    XPutImage (CDisplay, pixmap, CGC, image, 0, 0, 0, 0, width, height);
    free (image->data);
    image->data = 0;
    XDestroyImage (image);
    return pixmap;
}

