#!/bin/sh
LC_ALL=C
CONVMV=../convmv
SORT=sort
mycpdir() {
	# copy one directory to another new one. This is needed because cp
	# has no portable way of saying "don't follow symlinks". It is rather
	# a bug that GNU coreutils' cp does preserves symlinks with -r
	srcdir="$1"
	tgtdir="$2"
	(cd "$srcdir"
	tar -cf - .
	) | (
	mkdir "$tgtdir"
	cd "$tgtdir"
	tar -xf -
	)
}

myfind() {
	dirname="$1"
	cd $dirname
	# there is no standard tool to show symlink targets except for "ls" but
	# ls has no standard switch to only display symlink target but no time
	# stamps. And as cp can not preserve symlink timestamps we need to
	# clean up ls -l output with sed :-|
	echo links ...
	find . -type l -print | LC_ALL=C $SORT | while read file
	do
		ls -l "$file" | sed 's/.* \.\///'
	done
	echo files ...
	find . -type f -print | LC_ALL=C $SORT | while read file
	do
		ls "$file"
	done
	echo directories ...
	find . -type d -print | grep -v "^\.$" | LC_ALL=C $SORT | while read file
	do
		ls -d "$file"
	done
	cd ..
}

# first of all create file listings of how it should be if conversion was correct:
for dir in `ls -d test*`
do
	myfind $dir/ > out-$dir
done

#
echo smartness-test
rm -rf test.tmp
mycpdir test test.tmp
$CONVMV -f iso8859-15 -t utf8 --notest -r test.tmp
false
myfind test.tmp > out.tmp
diff out-test out.tmp > diff.tmp|| { echo "smartness-test failed." ; exit 1; }
#
echo double-utf8 test
rm -rf test.tmp
mycpdir test test.tmp
$CONVMV -f iso8859-15 -t utf8 --notest -r --nosmart test.tmp
myfind test.tmp > out.tmp
diff out-test-utf8 out.tmp > diff.tmp|| { echo "double-utf8 test failed." ; exit 1; }
echo undo-double-utf8 test with double-utf8 results
$CONVMV -f utf8 -t iso8859-15 --notest -r test.tmp
myfind test.tmp > out.tmp
diff out-test out.tmp > diff.tmp|| { echo undo-double-utf8 test failed. ; exit 1; }
#
echo utf8-to-iso8859-15-test
rm -r test.tmp
mycpdir test test.tmp
$CONVMV -f utf8 -t iso8859-15 --notest -r test.tmp
myfind test.tmp > out.tmp
diff out-test-iso8859-15 out.tmp > diff.tmp|| { echo utf8-to-iso8859-15-test failed. ; exit 1; }
#
echo iso8859-15-to-utf8-test
rm -r test.tmp
mycpdir test-iso8859-15 test.tmp
$CONVMV -f iso8859-15 -t utf8 --notest -r test.tmp
myfind test.tmp > out.tmp
diff out-test out.tmp > diff.tmp|| { echo iso8859-15-to-utf8-test failed. ; exit 1; }
#
echo nfc-test
rm -r test.tmp
mycpdir test test.tmp
$CONVMV -f utf-8 -t utf-8 --nfd --notest -r test.tmp
myfind test.tmp > out.tmp
diff out-test-nfd out.tmp > diff.tmp|| { echo nfd-test failed. ; exit 1; }
echo nfd-test with nfc-results
$CONVMV -f utf8 -t utf8 --nfc --notest -r test.tmp
myfind test.tmp > out.tmp
diff out-test out.tmp > diff.tmp|| { echo nfc-test failed. ; exit 1; }
#
echo escaped-test
rm -r test.tmp
mycpdir test-escaped test.tmp
$CONVMV --unescape --notest -r test.tmp
myfind test.tmp > out.tmp
diff out-test out.tmp > diff.tmp|| { echo escaped-test failed. ; exit 1; }
#
echo upper-test
rm -r test.tmp
mycpdir test test.tmp
$CONVMV --upper -f utf8 --notest -r test.tmp
myfind TEST.TMP > out.tmp
diff out-test-upper out.tmp > diff.tmp|| { echo upper-test failed. ; exit 1; }

echo All tests successful, cleaning up now ...
rm -rf TEST.TMP *.tmp out*

