#ifndef __SPRINGYMATRIX_H
#define __SPRINGYMATRIX_H

extern "C" {
#include <qsearch/qsearch.h>
};

#include <gsl/gsl_matrix.h>
#include <pthread.h>

class SpringyMatrixTreeWatcher {
  QSearchTreeMaster *_tm;
  gsl_matrix *_lastmat;
  int _seqno;
  pthread_mutex_t _matlock;
  bool _should_abort, _did_abort;
  double _tsco;
  public:
  SpringyMatrixTreeWatcher(QSearchTreeMaster *tm);
  SpringyMatrixTreeWatcher(QSearchTree *tree);
  ~SpringyMatrixTreeWatcher();
  void moveToNextTree(gsl_matrix *dm, QSearchTree *newguy);
  int get_seqno(void);
  double get_score(void);
  int get_leaf_node_count(void);
  void abort(void);
  void wait_until_done(void) const;
  bool is_done(void) const;
  gsl_matrix *get_springy_matrix(void);
  void calculate(void);
};

#endif
