/*
* Copyright (c) 2006 Rudi Cilibrasi, Rulers of the RHouse
* All rights reserved.     cilibrar@cilibrar.com
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of the RHouse nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS "AS IS" AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE RULERS AND CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*! \file clgui.c */

#include <assert.h>
#include <GL/gl.h>
#include <glib.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <qapplication.h>
#include <sys/stat.h>
#include <sys/types.h>
extern "C" {
#include <complearn/complearn.h>
#include <qsearch/qsearch.h>
};

#include <unistd.h>
#include <pthread.h>

#include "timeframe.h"
#include "springymatrix.h"
#include "springball.h"
#include "sbviewer.h"
#include "ui/mwgen.h"
#include "ui/mwgen.moc"

class MWGenWindow {
  //void close(void) {
 // }

  public:
  MWGen *m;
  MWGenWindow()
  {
    m = new MWGen();
    //m->connect(m, SIGNAL(fileExit()), m, SLOT(close()));
  //setupUi(this);
  }
};

    // m->connect(m, SIGNAL(fileExit()), m, SLOT(close()));
int main(int argc, char **argv)
{
  g_type_init();

  QApplication application(argc, argv);
  MWGen *sbv = new MWGen();
#if QT_VERSION < 0x040000
  // Set the viewer as the application main widget.
//  application.setMainWidget(sbv);
  application.setMainWidget(sbv);
#else
  sbv->setWindowTitle("QSearch / CompLearn GUI DEMO");
#endif
  sbv->show();
  return application.exec();
}

