#include "cp_types.h"
#include "cp_proto.h"

/* ======================  vert_draw_order ====================== */

/* Record in K_data element 'next_vert' the order in which circles
are drawn when the packing is laid out. (Eg. want to be able to mark
the first 500 verts which will be drawn.) 

   Caution: I don't do much maintenance or error checking on the 
'next_vert' info, so it should be updated immediately before use. */

int vert_draw_order(struct p_data *p)
{
  int nf,next,last,tick=1;
  int *uflag=(int *)calloc((size_t)(p->nodecount+1),sizeof(int));
  struct K_data *pK_ptr=p->packK_ptr;
  f_data *faces=p->faces;

  /* get started with three verts of first face */
  uflag[p->alpha]=tick++;
  nf=p->first_face;
  next=faces[nf].vert[(faces[nf].index_flag+1) % 3];
  pK_ptr[p->alpha].next_vert=next;
  last=next;
  uflag[last]=tick++;
  pK_ptr[last].next_vert=next=faces[nf].vert[(faces[nf].index_flag+2) % 3];
  last=next;
  uflag[last]=tick++;
  nf=faces[nf].next_face;

  /* continue through face drawing order, checking to avoid repeats */
  while (nf!=p->first_face)
    {
      while (nf!=p->first_face 
	     && uflag[(next=faces[nf].vert[(faces[nf].index_flag+2) % 3])])
	nf=faces[nf].next_face;
      if (nf==p->first_face) break; /* done */
      pK_ptr[last].next_vert=next;
      last=next;
      uflag[last]=tick++;
      nf=faces[nf].next_face;
    }
  pK_ptr[last].next_vert=p->alpha; /* last vert points back to alpha */
  
  return (tick-1); /* in general, tick-1 should equal nodecount */
} /* vert_draw_order */
