#include "cp_types.h"
#include "cp_proto.h"

/* Routines for programs to communicate with CirclePack through
   pipes. 
   fixup: Names changed 1/00, may have to adjust calling routines. */

extern char buf[],*msgbuf;  /* general purpose utility buffer */

int r_msg(char *msg)
     /* sends message to parent. Must send individual sections between
'\n' and must append '\n' to end each line. */
{
  char *hold,*ptr;
  int tl,i;

  if ((tl=strlen(msg)-1)<0) return 1;
  ptr=msg;
  hold=(char *)calloc((size_t)(tl+2),sizeof(char));
  while (*ptr!='\0')
    {
      i=0;
      while (*ptr!='\n' && *ptr!='\0' && i<BUFSIZE)
	{
	  hold[i]=*ptr;
	  i++;
	  ptr++;
	}
      hold[i+1]='\0';
      if (*ptr=='\n') ptr++;
      printf("msg: %s\n",hold);
    }
  free(hold);
  fflush(stdout);
  return 1;
} /* r_msg */

int r_emsg(char *msg)
     /* sends error message to parent. */
{
  char *hold,*ptr;
  int tl,i;

  if ((tl=strlen(msg)-1)<0) return 1;
  ptr=msg;
  hold=(char *)calloc((size_t)(tl+2),sizeof(char));
  while (*ptr!='\0')
    {
      i=0;
      while (*ptr!='\n' && *ptr!='\0' && i<BUFSIZE)
	{
	  hold[i]=*ptr;
	  i++;
	  ptr++;
	}
      hold[i+1]='\0';
      if (*ptr=='\n') ptr++;
      printf("emsg: %s\n",hold);
    }
  free(hold);
  fflush(stdout);
  return 1;
} /* r_emsg */

int r_cmsg(char *msg)
     /* sends command message to parent. */
{
  char *hold,*ptr;
  int tl,i;

  if ((tl=strlen(msg)-1)<0) return 1;
  ptr=msg;
  hold=(char *)calloc((size_t)(tl+2),sizeof(char));
  while (*ptr!='\0')
    {
      i=0;
      while (*ptr!='\n' && *ptr!='\0' && i<BUFSIZE)
	{
	  hold[i]=*ptr;
	  i++;
	  ptr++;
	}
      hold[i+1]='\0';
      if (*ptr=='\n') ptr++;
      printf("command: %s\n",hold);
    }
  free(hold);
  fflush(stdout);
  return 1;
} /* r_cmsg */

int r_dmsg(char *msg)
     /* sends data request to parent. */
{
  char *hold,*ptr;
  int tl,i;

  if ((tl=strlen(msg)-1)<0) return 1;
  ptr=msg;
  hold=(char *)calloc((size_t)(tl+2),sizeof(char));
  while (*ptr!='\0')
    {
      i=0;
      while (*ptr!='\n' && *ptr!='\0' && i<BUFSIZE)
	{
	  hold[i]=*ptr;
	  i++;
	  ptr++;
	}
      hold[i+1]='\0';
      if (*ptr=='\n') ptr++;
      printf("data:%s\n",hold);
    }
  free(hold);
  fflush(stdout);
  return 1;
} /* r_dmsg */

int r_lock_set(int pnum)
     /* order parent to block pack number pnum and await acknowledge. */
{
  sprintf(buf,"lock %d\n",pnum);
  fputs(buf,stdout);
  fflush(stdout);
  *buf='\n';
  while (*buf=='\n') fgets(buf,1024,stdin); 
  sscanf(buf,"%s",msgbuf);
  if (strncmp(msgbuf,"failed",6)==0) return 0; 
  /* can add more analysis of return message */
  return 1;
} /* r_lock_set */

int r_unlock(int pnum)
     /* order parent to block pack number pnum and await acknowledge. */
{
  sprintf(buf,"unlock %d\n",pnum);
  fputs(buf,stdout);
  fflush(stdout);
  *buf='\n';
  while (*buf=='\n') fgets(buf,1024,stdin); 
  sscanf(buf,"%s",msgbuf);
  if (strncmp(msgbuf,"failed",6)==0) return 0; 
  /* can add more analysis of return message */
  return 1;
} /* r_unlock */

int r_pack_read(struct p_data *p,int pnum,int opt)
     /* order parent to send pack pnum, await ack'ge, return 
nodecount. See 'readpack' for coding of 'opt' */
{
  int n,size;

  sprintf(buf,"get pack %d %d\n",pnum,opt);
  fputs(buf,stdout);
  fflush(stdout);
  *buf='\n';
  while (*buf=='\n') fgets(buf,1024,stdin); 
  sscanf(buf,"%s",msgbuf);
  if (strcmp(msgbuf,"failed")==0 
      || sscanf(buf,"%s %s %d %d",msgbuf,msgbuf,&n,&size)!=4
      || n!=pnum) 
    return 0;
  return size;
} /* r_pack_read */

int r_pack_write(struct p_data *p,int qnum,int opt)
     /* ask parent to accept pack p data into its pack number qnum 
and await acknowledge. */
{
  if (p->nodecount<=0)
    return 0;
  sprintf(buf,"sending pack %d %d\n",qnum,p->nodecount);
  fputs(buf,stdout);
  fflush(stdout);
  *buf='\n';
  while (*buf=='\n') fgets(buf,1024,stdin); 
  sscanf(buf,"%s",msgbuf);
  if (strcmp(msgbuf,"ready")!=0) return 0; 
  /* can add more analysis of return message */
  if (!writepack(stdout,p,opt,0)) return 0; 
  /* opt controls the types of data written. */
  *buf='\n';
  while (*buf=='\n') fgets(buf,1024,stdin); 
  sscanf(buf,"%s",msgbuf);
  if (strncmp(msgbuf,"failed",6)==0) return 0;
  /* can add more analysis of return message */
  return 1;
} /* r_pack_write */

int r_path_read(struct Pathlist **pathlist,int *pathlength)
     /* order parent to send current path */
{
  sprintf(buf,"get path\n");
  fputs(buf,stdout);
  fflush(stdout);
  return (readpath(stdin,pathlist,pathlength)); 
} /* r_path_read */

int r_path_write(struct Pathlist *pathlist,int pathlength)
/* send path to calling program */
{
  if (pathlist==NULL || pathlength<=0) return 0;
  sprintf(buf,"sending path\n");
  fputs(buf,stdout);
  fflush(stdout);
  writepath(stdout,(struct Pathlist *)NULL);
  *buf='\n';
  while (*buf=='\n') fgets(buf,1024,stdin); 
  sscanf(buf,"%s",msgbuf);
  if (strncmp(msgbuf,"failed",6)==0) return 0;
  /* can add more analysis of return message */
  return 1;
} /* r_path_write */

int r_get_pack_size(FILE *fp,struct p_data *p)
     /* get size of pack from open filepointer */
{
  int size=0;
  char command[64];

  while ( (fscanf(fp,"%63s",command)!=EOF)
	  && (strcmp(command,"NODECOUNT:"))
	  && (strcmp(command,"CHECKCOUNT:"))
	  && (strcmp(command,"END")) );
  if (!strcmp(command,"NODECOUNT:")
      || !strcmp(command,"CHECKCOUNT:") )
    fscanf(fp,"%d",&size);
  if (size<0) size=0;
  return size;
} /* r_get_pack_size */

int r_done_signal()
/* send 'bye' message */
{
  sprintf(buf,"done\n");
  fputs(buf,stdout);
  fflush(stdout);
  *buf='\n';
  while (*buf=='\n') fgets(buf,1024,stdin); 
  sscanf(buf,"%s",msgbuf);
  if (strcmp(msgbuf,"bye")!=0) return 0; 
  return 1;
} /* r_done_signal */





