/* blend.c  
Procedures for blending together two overlapping subcomplexes of
a parent complex.

Idea: Large complex K is given. Isolate one (or more) complicated, 
simply connected subcomplex S1 and replace a portion by a single circle 
to get a complex S2 which overlaps S1 in an annular complex A. 

Pack S2, use values of bdry radii of S1 and then pack S1, then blend 
them together in as smooth a way as possible through the overlap 
comlex A to get a packing for K.

Tasks:

* routines in eucl and hyp geometry to find best Mobius matching
two pairs of 3 points.

* count generations from boundary to locate S1.

* replace subcomplex with single circle

* blending involves smooth weighted averages of centers for A
in S1 and S2.

* read S1 and S2 with vertex_maps identifying them with K

*/

#include "cp_types.h"

